;
(function ($, window, document, undefined) {
    var pluginName = "game",
        defaults = {
            elements: [
                {
                    img: "img/vegetables/ziemniak.png",
                    correctPosition: 1
                },
                {
                    img: "img/vegetables/burak.png",
                    correctPosition: 2
                },
                {
                    img: "img/vegetables/marchewka.png",
                    correctPosition: 3
                },
                {
                    img: "img/vegetables/fasola.png",
                    correctPosition: 4
                },
                {
                    img: "img/vegetables/kapusta.png",
                    correctPosition: 5
                },
                {
                    img: "img/vegetables/pietruszka.png",
                    correctPosition: 6
                },
                {
                    img: "img/vegetables/seler.png",
                    correctPosition: 7
                },
                {
                    img: "img/vegetables/groch.png",
                    correctPosition: 8
                },
                {
                    img: "img/vegetables/oberzyna.png",
                    correctPosition: null
                },
                {
                    img: "img/vegetables/cukinia.png",
                    correctPosition: null
                },
                {
                    img: "img/vegetables/brokul.png",
                    correctPosition: null
                }
            ]
        };

    function Plugin(element, options) {
        this.element = element;
        this.$element = $(element);
        this.settings = $.extend({}, defaults, options);
        this._defaults = defaults;
        this._name = pluginName;
        this.putElements = 0;
        this.init();
    }

    $.extend(Plugin.prototype, {
        init: function () {
            var _this = this,
                $element = $("<div><img/></div>")
                    .addClass("element")
                    .addClass("draggable"),
                loadedImages = 0,
                fnOnLoad = function fnOnLoad() {
                    loadedImages += 1;
                    if (loadedImages === _this.$element.find(".element").size()) {
                        $(window).trigger("resize");
                    }
                };
            _this.$element.find(".has-input input").val('');

            $.each(this.settings.elements, function (index, obj) {
                var $el = $element.clone()
                    .find("img").attr("src", obj.img).load(fnOnLoad).end()
                    .attr("data-correct-position", obj.correctPosition)
                    .appendTo(_this.$element.find(".elements-container"));
            });

            this.$element.find(".element").draggable({
                revert: "invalid",
                helper: "clone"
            }).randomize();

            this.$element.find(".container").droppable({
                accept: '.draggable',
                drop: function (evt, ui) {
                    $(ui.draggable).detach().css({
                        top: 0,
                        left: 0
                    }).appendTo($(this));

                    $(this).removeClass("active-drop").addClass("dropped");
                    var $this = $(this);

                    setTimeout(function () {
                        $this.removeClass("dropped");
                    }, 500);

                    _this.putElements++;
                    if (_this.putElements == 8) {
                        _this.$element.find(".has-input").show().find("input").trigger("focus");
                    }

                },
                over: function (event, ui) {
                    $(this).addClass('active-drop');
                },
                out: function (event, ui) {
                    $(this).removeClass('active-drop');
                }
            });

            this.$element.find(".has-input input").on("keyup blur", function () {

                _this.check();
            });

            this.$element.find("#refresh").on("click", function () {
                window.location.reload();
                return false;
            });

            $(window).on("resize", function () {
                _this.resize();
            });
        },
        resize: function () {
            if (this.$element.find(".element").size() >= 7) {
                this.$element.find(".elements-container").css({
                    minHeight: this.$element.find(".elements-container").height()
                });
            }
        },
        check: function () {
            var correctPosition = 1;
            var correct = true;
            this.$element.find(".container .element").each(function () {
                if ($(this).attr("data-correct-position") != correctPosition) {
                    correct = false;
                }
                correctPosition += 1;
            });

            if (this.$element.find(".has-input input").val() == 8 && correct) {
                this.$element.find(".popup, .popup-overlay").show();
                this.$element.find("input").trigger("blur");
            }

            if (this.$element.find(".has-input input").val() != 8 && correct) {
                $('#popup_info').html('Podana ilość warzyw nie jest prawidłowa. Spróbuj jeszcze raz!')
                    .css('font-size', '30px');
                $('#popup_img').attr('src', 'img/pop-up-2.png');
                this.$element.find(".popup, .popup-overlay").show();
                this.$element.find("input").trigger("blur");
            }

            if (this.$element.find(".has-input input").val() == 8 && !correct) {
                $('#popup_info').html('Kolejność nie jest prawidłowa, spróbuj jeszcze raz!')
                    .css('font-size', '30px');
                $('#popup_img').attr('src', 'img/pop-up-2.png');
                this.$element.find(".popup, .popup-overlay").show();
                this.$element.find("input").trigger("blur");
            }

        }
    });
    $.fn.randomize = function (selector) {
        (selector ? this.find(selector) : this).parent().each(function () {
            $(this).children(selector).sort(function () {
                return Math.random() - 0.5;
            }).detach().appendTo(this);
        });

        return this;

    };
    $.fn[pluginName] = function (options) {
        this.each(function () {
            if (!$.data(this, "plugin_" + pluginName)) {
                $.data(this, "plugin_" + pluginName, new Plugin(this, options));
            }
        });
        return this;
    };

})(jQuery, window, document);