;
(function($, window, document, undefined)
{
    $.fn.randomize = function(selector)
    {
        (selector ? this.find(selector) : this).parent().each(function()
        {
            $(this).children(selector).sort(function()
            {
                return Math.random() - Math.random();
            }).detach().appendTo(this);
        });

        return this;
    };

    var View = function(game, opts)
    {
        var _this = this;

        this.game = game;
        this.opts = opts;
        this.$element = $(opts.element);

        this.render = function()
        {
            var $element = $("<div><div class='photo-container'><img src alt /></div><div class='draggable-container'></div></div>").addClass("element"),
                $draggable = $("<div><span/></div>").addClass("draggable");

            $.each(this.opts.elements, function(i, element)
            {
                var $el = $element.clone()
                    .find("img").attr("src", element.img).end()
                    .attr("data-element-index", i)
                    .appendTo(_this.$element.find(".elements"));

                $draggable.clone()
                    .find("span").text(element.value).end()
                    .attr("data-element-index", i)
                    .appendTo(_this.$element.find(".draggables"));
            });

            this.$element.find(".element").randomize();
            this.$element.find(".draggable").randomize();

            this.$element.find(".popup.popup-instruction, .popup-overlay").show();
        };

        this.delegateEvents = function()
        {
            this.$element.find(".popup .start").on("click", function()
            {
                _this.$element.find(".popup.popup-instruction, .popup-overlay").hide();
                return false;
            });

            this.$element.find(".draggable").draggable({
                helper: "clone",
                revert: "invalid",
                appendTo: _this.$element.find(".tmp-container")
            });

            this.$element.find(".element .draggable-container, .draggables").droppable({
                accept: ".draggable",
                drop: function(e, ui)
                {
                    if($(this).find(".draggable").size())
                    {
                        $(this).find(".draggable").appendTo(_this.$element.find(".draggables"))
                    }

                    $(ui.draggable).detach().appendTo($(this));

                    $(this).removeClass("active-drop");

                    _this.resize();
                    _this.check();
                },
                over: function()
                {
                    $(this).addClass("active-drop");
                },
                out: function()
                {
                    $(this).removeClass("active-drop");
                }
            });

            this.$element.find("#refresh").on("click", function()
            {
                window.location.reload();
                return false;
            });

            $(window).on("resize", function()
            {
                _this.resize();
            }).trigger("resize");
        };

        this.resize = function()
        {
            this.$element.find(".draggable-container .draggable").each(function()
            {
                var fontSize = 30;
                do
                {
                    $(this).css("font-size", fontSize + "px");
                    fontSize -= 1;
                }
                while($(this).find("span").outerHeight() > $(this).closest(".draggable-container").outerHeight());

                do
                {
                    $(this).css("font-size", fontSize + "px");
                    fontSize -= 1;
                }
                while($(this).find("span").outerWidth() + 20 > $(this).closest(".draggable-container").outerWidth());

            });
            this.$element.find(".draggable-container .draggable").css("line-height", (this.$element.find(".draggable-container .draggable").outerHeight() - 6) + "px");
        };

        this.check = function()
        {
            var count = 0;
            this.$element.find(".draggable-container .draggable").each(function()
            {
                var $this = $(this).removeClass("result-correct").removeClass("result-incorrect");
                if($this.attr("data-element-index") === $this.closest(".element").attr("data-element-index"))
                {
                    $this.addClass("result-correct");
                }
                else
                {
                    $this.addClass("result-incorrect");
                }
                count += 1;
            });

            if(count === this.opts.elements.length && this.$element.find(".result-incorrect").size() === 0)
            {
                this.$element.find(".popup.popup-result, .popup-overlay").show();
            }
        };
    };

    var Game = function(opts)
    {
        this.opts = opts;
        this.view = new View(this, opts);

        this.start = function()
        {
            this.view.render();
            this.view.delegateEvents();
        };
    };

    window.Game = Game;

})(jQuery, window, document);