;
(function($, window, document, undefined)
{
    $.fn.randomize = function(selector)
    {
        (selector ? this.find(selector) : this).parent().each(function()
        {
            $(this).children(selector).sort(function()
            {
                return Math.random() - Math.random();
            }).detach().appendTo(this);
        });

        return this;
    };

    var View = function(game, opts)
    {
        this.game = game;
        this.$element = $(opts.element);
        this.opts = opts;
        this.flippedCard = null;
        this.blockUI = false;

        var $element = $("<div><img src='' alt class='flip-img'><img src='' alt class='element-img' /></div>")
            .addClass("element")
            .find("flip-img").attr("src", opts.flipImg).end();

        this.render = function()
        {
            var _this = this;

            $.each(this.opts.elements, function()
            {
                var $el = $element.clone()
                    .attr("data-value", this.value)
                    .find(".element-img").attr("src", this.img).end()
                    .find(".flip-img").attr("src", _this.opts.flipImg).end()
                    .appendTo(_this.$element.find(".elements"));
            });

            this.$element.find(".element").randomize();

            $(window).on("resize", function()
            {
                _this.resize();
            }).trigger("resize");

            this.$element.find(".popup-instruction, .popup-overlay").show();
        };

        this.delegateEvents = function()
        {
            var _this = this;

            this.$element.find(".element").on("click", function()
            {
                if(_this.blockUI || $(this).hasClass("is-flipped"))
                {
                    return false;
                }

                var $card = $(this).addClass("is-flipped");

                if(_this.flippedCard)
                {
                    if(_this.flippedCard.attr("data-value") === $card.attr("data-value"))
                    {
                        _this.game.points += 1;
                        _this.flippedCard = null;
                        _this.check();
                    }
                    else
                    {
                        _this.blockUI = true;
                        setTimeout(function()
                        {
                            _this.flippedCard.removeClass("is-flipped");
                            $card.removeClass("is-flipped");
                            _this.flippedCard = null;
                            _this.blockUI = false;
                        }, 2000);
                    }
                }
                else
                {
                    _this.flippedCard = $card;
                }

                return false;
            });

            this.$element.find("#refresh").on("click", function()
            {
                window.location.reload();
                return false;
            });

            this.$element.find(".start").on("click", function()
            {
                _this.$element.find(".popup-instruction, .popup-overlay").hide();
                return false;
            });
        };

        this.check = function()
        {
            if(this.game.points === this.opts.elements.length / 2)
            {
                this.$element.find(".popup-result, .popup-overlay").show();
            }
        };

        this.resize = function()
        {
            /*
            var marginRight = 15,
                marginBottom = 15,
                containerWidth = this.$element.find(".elements-wrapper").width(),
                containerHeight = this.$element.find(".elements-wrapper").height(),
                elementSize = this.$element.find(".elements-wrapper").width(),
                elementsPerRow = 1,
                rows = this.opts.elements.length,
                elementsCount = this.opts.elements.length,
                min = Math.min(containerHeight, containerWidth);


            while(rows * (elementSize + marginBottom) > min)
            {
                elementSize -= 5;
                elementsPerRow = Math.floor(containerWidth / (elementSize + marginRight));
                rows = Math.ceil(elementsCount / elementsPerRow);
            }
            elementSize = Math.floor(elementSize) - 5;
            this.$element.find(".element").width(elementSize).height(elementSize);
            */
            var containerHeight = this.$element.find(".elements-wrapper").height();
            this.$element.find(".elements-wrapper").css("line-height", containerHeight + "px");
        };
    };

    var Game = function(opts)
    {
        this.points = 0;
        this.view = new View(this, opts);

        this.start = function()
        {
            this.view.render();
            this.view.delegateEvents();
        }
    };

    window.Game = Game;

})(jQuery, window, document);