;
(function($, window, document, undefined)
{
    $.fn.randomize = function(selector)
    {
        (selector ? this.find(selector) : this).parent().each(function()
        {
            $(this).children(selector).sort(function()
            {
                return Math.random() - Math.random();
            }).detach().appendTo(this);
        });

        return this;
    };

    var View = function(game, opts)
    {
        var _this = this;

        this.game = game;
        this.opts = opts;
        this.$element = $(opts.element);
        this.$activeDrop = null;

        $(window).on("resize", function()
        {
            _this.resize();
        });

        this.start = function()
        {
            var _this = this;

            this.render();
            this.resize();

            setTimeout(function()
            {
                _this.$element.find(".instruction").fadeOut("fast");
            }, 15000);
        };

        this.render = function()
        {
            this.$element.find(".element:not(.element-static)").draggable({
                helper: "clone",
                revert: "invalid",
                appendTo: _this.$element.find(".elements"),
                start: function()
                {
                    _this.$element.find(".placeholder:not(.placeholder-disabled)").addClass("active-drop");
                    _this.$element.find(".instruction").hide();
                },
                stop: function()
                {
                    _this.$element.find(".placeholder").removeClass("active-drop");
                }
            });

            this.$element.find(".placeholder").droppable({
                accept: function($el)
                {
                    var accepted = $(this).attr("data-accepted-elements").split(","),
                        i = 0;

                    for(; i < accepted.length; i += 1)
                    {
                        if($el.is(accepted[i]))
                        {
                            return true;
                        }
                    }
                    return false;
                },
                drop: function(event, ui)
                {
                    var $this = _this.$activeDrop.removeClass("active");

                    if(!_this.$activeDrop.is("[data-do-not-disable]"))
                    {
                        $this.addClass("placeholder-disabled").droppable("disable");
                    }

                    $(ui.draggable).detach().appendTo(_this.$activeDrop);

                    if(_this.check())
                    {
                        _this.stopGame("success");
                    }
                },
                over: function()
                {
                    _this.$element.find(".placeholder.active").removeClass("active");
                    _this.$activeDrop = $(this).addClass("active");
                },
                out: function()
                {
                    if(_this.$activeDrop)
                    {
                        _this.$activeDrop.removeClass("active");
                    }
                    _this.$activeDrop = null;
                }
            });

            this.$element.find("#refresh").on("click", function()
            {
                window.location.reload();
                return false;
            });
        };

        this.resize = function()
        {
            var windowWidth = $(window).width(),
                windowHeight = $(window).height(),
                roomWidth = 1920,
                roomHeight = 1400,
                ratio = roomWidth / roomHeight,
                wrapperWidth,
                wrapperHeight;

            if(windowWidth / windowHeight > ratio)
            {
                wrapperHeight = windowHeight;
                wrapperWidth = wrapperHeight * ratio;
            }
            else
            {
                wrapperWidth = windowWidth;
                wrapperHeight = wrapperWidth / ratio;
            }

            this.$element.find(".wrapper").css({
                width: wrapperWidth + "px",
                height: wrapperHeight + "px"
            });

            this.$element.css("line-height", windowHeight + "px");

            var instructionHeight = this.$element.find(".instruction").height();
            this.$element.find(".instruction").css("line-height", instructionHeight + "px");
        };

        this.check = function()
        {
            var nbPutElements = this.$element.find(".placeholder .element").size();
            return 16 === nbPutElements;
        };

        this.stopGame = function()
        {
            this.$element.find(".popup, .popup-overlay").show();
        };
    };

    var Game = function(opts)
    {
        this.opts = opts;
        this.view = new View(this, opts);

        this.start = function()
        {
            this.view.start();
        };
    };

    window.Game = Game;

})(jQuery, window, document);