(function (win, doc, $) {
    if (!Array.prototype.shuffle) {
        Array.prototype.shuffle = function () {
            var i = this.length,
                j, temp;
            while (i--) {
                j = Math.floor(Math.random() * (i + 1));
                temp = this[j];
                this[j] = this[i];
                this[i] = temp;
            }
            return this;
        };
    }

    var View = function (game, opts) {
        this.game = game;
        this.$gameSpace = $(game.gameSpace);
        this.$labelsSpace = $(game.labelsSpace);
        this.$itemsSpace = $(game.itemsSpace);
        this.elementsCount = 0;

        this.createItems = function (items) {
            var _this = this;

            var col = $('<div/>').addClass('col').addClass('col-xs-3'),
                itemImg = $('<div/>').addClass('col-xs-12').addClass('item-img'),
                itemLabelPlaceholder = $('<div/>').addClass('col-xs-12').addClass('placeholder').append($('<p/>').html('&nbsp;'));

            var $baseSetElement = col.append(itemImg.append(itemLabelPlaceholder));
            var item;

            for (i = 0; i < items.length; i++) {
                item = items[i];

                var $itemContainer = $baseSetElement.clone();

                $itemContainer.find('.item-img').addClass(item.name.replace(/\s+/g, '')).attr('data-id', item.id);
                $itemContainer.appendTo(this.$itemsSpace);

                ++this.elementsCount;
            }

            this.calculateItemsSize();

            $(window).on('resize', function () {
                _this.calculateItemsSize();
            });
        };

        this.createLables = function (items) {
            var itemLabel = $('<div/>').addClass('col-xs-3').addClass('item-label');
            var $baseSetElement = itemLabel;
            var paragraph = $('<p>');
            var item;

            for (i = 0; i < items.length; i++) {
                item = items[i];

                var itemLabelText = paragraph.clone().text(item.name);
                var $itemLabel = $baseSetElement.clone().attr('data-id', item.id).append(itemLabelText);

                $itemLabel.appendTo(this.$labelsSpace);
            }
        };

        this.calculateItemsSize = function () {
            $('.item-img').each(function () {
                var width = $(this).outerWidth();
                var height = Math.round(width / 1.714285714);

                $(this).height(height);

                $(this).find('.placeholder').css('marginTop', height - 45);
            });
        };

        this.delegateEvents = function () {
            var _this = this;

            this.$gameSpace.find(".item-label").draggable({
                revert: true,
                helper: "clone",
                cursor: 'move',
                cursorAt: {
                    top: 20,
                    left: 100
                }
            });

            this.$gameSpace.find(".placeholder").find("p").draggable({
                revert: false,
                helper: "clone",
                cursor: 'move',
                cursorAt: {
                    top: 20,
                    left: 20
                },
                start: function (event, ui) {
                    if ($.trim(ui.helper.text()).length == 0)
                        return false;

                    $(ui.draggable).addClass('item-label');
                }
            });

            this.$gameSpace.find(this.$labelsSpace).droppable({
                accept: 'p',
                tolerance: "pointer",
                drop: function (evt, ui) {
                    var label = $(ui.draggable).text();
                    var id = $(ui.draggable).attr('data-id');

                    $(ui.draggable)
                        .html('&nbsp;')
                        .attr('data-id', '')
                        .parent('.placeholder').removeClass('filled');

                    var itemLabel = $('<div/>').addClass('col-xs-3').addClass('item-label');
                    var $baseSetElement = itemLabel;
                    var paragraph = $('<p>');

                    var itemLabelText = paragraph.html(label);
                    var $itemLabel = $baseSetElement.clone().attr('data-id', id).append(itemLabelText);

                    $itemLabel.appendTo(_this.$labelsSpace);

                    _this.delegateEvents();

                    $('#labels').removeClass('highlighted');
                },
                over: function () {
                    $('#labels').addClass('highlighted');
                },
                out: function () {
                    $('#labels').removeClass('highlighted');
                }
            });

            this.$gameSpace.find(".placeholder").droppable({
                accept: '.item-label, .dropped-label',
                tolerance: "pointer",
                drop: function (evt, ui) {
                    if ($(this).hasClass('filled')) {
                        $(this).removeClass('active-drop');

                        return true;
                    }

                    $('.ui-draggable-dragging').hide();


                    $(this).addClass('filled');
                    $(this).removeClass('active-drop');

                    if (!$(ui.draggable).hasClass('dropped-label')) {

                        $(this).append($(ui.draggable));
                        var label = $(ui.draggable).find('p').text();
                        var id = $(ui.draggable).attr('data-id');

                        $(this).find('p').text(label);
                        $(this).find('p').attr('data-id', id);
                        $(this).find('p').addClass('dropped-label');

                        $(ui.draggable).remove();
                    }else{
                        var label = $(ui.draggable).text();
                        var id = $(ui.draggable).attr('data-id');

                        $(ui.draggable)
                            .html('&nbsp;')
                            .attr('data-id', '')
                            .parent('.placeholder').removeClass('filled');

                        $(this).find('p').text(label);
                        $(this).find('p').attr('data-id', id);
                        $(this).find('p').addClass('dropped-label');
                    }


                    var result = _this.check();

                    if (_this.elementsCount == result.filled) {
                        if (result.correct == result.filled) {
                            _this.showEndMessage(1);

                            return;
                        }

                        if ((result.wrong == result.total) || (result.wrong + result.correct == result.total)) {
                            _this.showEndMessage(0);
                        }
                    }
                },
                over: function (event, ui) {
                    if (!$(this).hasClass('filled')) {
                        $(this).addClass('active-drop');
                    }
                },
                out: function (event, ui) {
                    $(this).removeClass('active-drop');
                }
            });
        };

        this.showEndMessage = function (type) {
            var messageNode = $('<p/>');

            if (type == 1) {
                this.msgSuccess();
            } else {
                this.msgFail();
            }

            messageNode.hide();

            this.$gameSpace.append(messageNode);

            messageNode.fadeIn();
        };

        this.showEndScreen = function (success) {
            var curtain = $('<div/>');
            var imageContainer = $('<div/>');
            var imgSrc;

            if (success) {
                imgSrc = 'success.png';
            } else {
                imgSrc = 'fail.png';
            }

            imageContainer
                .html('<img src="images/' + imgSrc + '" alt="">')
                .addClass('imageContainer');

            imageContainer.click(function () {
                location.reload();
            });

            curtain
                .addClass('curtain')
                .append(imageContainer);

            $('body').prepend(curtain);

            $('#refresh').addClass('btn_overlay');
        };

        this.msgSuccess = function () {
            self = this;

            this.showEndScreen(true);
        };

        this.msgFail = function () {
            self = this;

            this.showEndScreen(false);
        };

        this.check = function () {
            var correct = 0,
                wrong = 0,
                total = 0,
                filled = 0;

            this.$gameSpace.find(".col").each(function () {
                var colId = $(this).find('.item-img').attr("data-id");

                $(this).find(".placeholder").each(function () {
                    var placeholderId = $(this).find('p').attr("data-id");

                    if ($(this).hasClass('filled')) {
                        ++filled;
                    }

                    if (colId === placeholderId) {
                        ++correct;
                        $(this).find('p').draggable({disabled: true});
                        $(this)
                            .removeClass('filled_correct')
                            .removeClass('filled_incorrect')
                            .addClass('filled_correct');
                    } else {
                        ++wrong;

                        $(this)
                            .removeClass('filled_correct')
                            .removeClass('filled_incorrect')
                            .addClass('filled_incorrect');
                    }

                    ++total;
                });
            });

            return {
                correct: correct,
                wrong: wrong,
                total: total,
                filled: filled
            }
        };
    };

    var Game = function (opts) {
        this.gameSpace = opts.gameSpace;
        this.labelsSpace = opts.labelsSpace;
        this.itemsSpace = opts.itemsSpace;
        this.view = new View(this, {});
        this.configuration = {
            game: {
                items: []
            }
        };

        this.init = function (config) {
            $.extend(this.configuration, config);
            this.view.createItems(this.configuration.game.items.shuffle());
            this.view.createLables(this.configuration.game.items.shuffle());
            this.view.delegateEvents();
        };

        this.check = function () {
            var result = this.view.check();
        }
    };

    $(function () {
        var app = new Game({
            gameSpace: "#game-7ISE",
            labelsSpace: "#labels",
            itemsSpace: "#items"
        });

        app.init(config);

        $("#refresh").on("click", function (e) {
            var confirmation = confirm('Czy na pewno chcesz zacząć od początku?');

            if (confirmation)
                location.reload();

            return confirmation;
        });
    });

    var config = {
        game: {
            successMsg: 'Gratulacje!',
            defeatMsg: 'Nie udało się...',
            items: [{
                id: 1,
                name: 'kitchen'
            }, {
                id: 2,
                name: 'bedroom'
            }, {
                id: 3,
                name: 'bathroom'
            }, {
                id: 4,
                name: 'living room'
            }, {
                id: 5,
                name: 'hall'
            }, {
                id: 6,
                name: 'study'
            }, {
                id: 7,
                name: 'garage'
            }, {
                id: 8,
                name: 'garden'
            }]
        }
    }
}(window, document, jQuery));