$(document).ready(function(){
	
	var score = 0;
	var colorStandard = '#fff';
	var colorHover    = '#ABEBFF';
	var colorActive   = 'rgb(81, 213, 255)';
	var colorBad      = 'rgb(255, 121, 121)';
	var colorGood     = 'rgb(137, 255, 81)';
	var answers = [
		{a:'czwartek'},
		{a:'kwiecień'},
		{a:'wtorek'},
		{a:'czwartek'},
	];
	for(var  i = 0; i < answers.length; i++){
		$('.task:eq('+i+')').data('active',0).data('used',0).data('complete',0);
	}
	$(document).click(function(){
		if(document.activeElement.tagName === 'BODY'){
			$('.task').data('active',0);
			for(var i = 0; i < answers.length; i++){
				var element = $('.task').eq(i);
				if(element.data('used') != 1){
					element.css('background', colorStandard);	
				}
			}
		}
	});
	$(document).keypress(function(e){
		if(e.which == 13) {
			var activeElement = document.activeElement;
			if(activeElement.tagName === 'INPUT'){
				var parent = activeElement.parentNode.parentNode;
				$(parent).data('used',1);
				var inputValue = activeElement.value.trim();
				var answer = answers[activeElement.id-1]['a'];
				if(inputValue === answer){
					$(activeElement).val(inputValue);
					$(activeElement).prop('disabled', true);
					$(activeElement).nextAll('input').hide();
					$(parent).data('complete',1);
					$(parent).css('cursor','auto');
					$(parent).css('background', colorGood);
					$(parent).find('.suggestions').hide();
					score++;
				}
				else{
					$(parent).css('background', colorBad);
				}
				if(score == answers.length){
					$("#cover").fadeIn("slow");
					$("#message").fadeIn("slow");
				}
			}
		}
	});
	$('.task').hover(function(){
		if($(this).data('active') != 1 && $(this).data('used') != 1){
			$(this).css('background', colorHover);
		}
	},function(){
		if($(this).data('complete') != 1 && $(this).data('used') == 1){
			$(this).css('background', colorBad);
		}
		if($(this).data('active') == 1 && $(this).data('used') != 1 ){
			$(this).css('background', colorActive);
		}
		if($(this).data('active') == 0 && $(this).data('used') != 1){
			$(this).css('background', colorStandard);
		}
	});
	$('input[type="button"]').click(function(){
		var inputText = $(this).prevAll('input');
		var inputValue = inputText.val().trim();
		var answer = answers[inputText.attr('id')-1]['a'];
		var thisParent = $(this).parent().parent();
		thisParent.data('used',1);
		if(inputValue === answer){
			$(this).hide();
			inputText.prop('disabled', true);
			inputText.val(inputValue);
			thisParent.data('complete',1);
			thisParent.css('cursor','auto');
			thisParent.css('background', colorGood);
			thisParent.find('.suggestions').hide();
			score++;
		}
		if(score == answers.length){
			$("#cover").fadeIn("slow");
			$("#message").fadeIn("slow");
		}
	});
	$('.task').click(function(){
		$('.task').data('active',0);
		for(var i = 0; i < answers.length; i++){
			var element = $('.task').eq(i);
			if(element.data('used') != 1){
				element.css('background', colorStandard);	
			}
		}
		$(this).data('active',1);
		if($(this).data('complete') != 1){
			if($(this).data('used') != 1){
				$(this).css('background', colorActive);
			}
			else{
				$(this).css('background', colorBad);
			}
			$(this).find('input[type=text]').focus();
		}
	});
	
});