;
(function($, window, document, undefined)
{
    var pluginName = "game10ISE",
        defaults = {};

    function Plugin(element, options)
    {
        this.element = element;
        this.$element = $(element);
        this.settings = $.extend({}, defaults, options);
        this._defaults = defaults;
        this._name = pluginName;
        this.init();
    }

    $.extend(Plugin.prototype, {
        init: function()
        {
            var _this = this;

            this.$element.find(".element input").on("keyup", function()
            {
                $(this).removeClass("result-incorrect");

                var value = $(this).val();
                var correctValue = $(this).closest(".element").attr("data-correct-result");
                if(correctValue === value)
                {
                    $(this).blur()
                        .addClass("result-correct")
                        .attr("disabled", "disabled");

                    $(this).closest(".element").find(".operation").animate({
                        width: "0px"
                    }, 150, "linear");

                    $(this).closest(".element").addClass("ready")
                        .find(".letter").addClass("animated").addClass("ready").end();
                }
                else
                {
                    $(this).addClass("result-incorrect");
                }
            });

            this.$element.find(".draggable").draggable({
                revert: "invalid",
                drag: function(event, obj)
                {
                    $(obj.helper).closest(".element").find(".animated").removeClass("animated");

                    if($(obj.helper).closest(".element").size() && !$(obj.helper).closest(".element").find("input").hasClass("result-correct"))
                    {
                        obj.position.top = 0;
                        obj.position.left = 0;

                        $(obj.helper).find("input").focus().trigger("focus");
                    }
                }
            }).on("click", function()
            {
                if(!$(this).find("input").hasClass("result-correct"))
                {
                    $(this).find("input").focus().trigger("focus");
                }
            });

            this.$element.find(".droppable").droppable({
                accept: ".draggable.ready",
                drop: function(e, ui)
                {
                    if ($(this).find(".draggable").size())
                    {
                        var index = $(this).find(".draggable").attr("data-index");
                        $(this).find(".draggable").prependTo(_this.$element.find(".element").eq(index));
                    }

                    $(this).removeClass("drag-over");

                    $(ui.draggable).appendTo(this).css({
                        position: "relative",
                        left: "auto",
                        top: "auto"
                    });

                    _this.check();
                },
                out: function()
                {
                    $(this).removeClass("drag-over");
                },
                over: function()
                {
                    $(this).addClass("drag-over");
                }
            });

            this.$element.find("#refresh").on("click", function()
            {
                window.location.reload();
                return false;
            });
        },
        check: function()
        {
            var correctResult = "CZAROWNICA",
                result = "";
            this.$element.find("td").each(function()
            {
                result += $(this).find(".letter").text().trim();
            });
            if (result === correctResult)
            {
                $(".popup.result-success, .popup-overlay").show();
            }
        }
    });

    $.fn[pluginName] = function(options)
    {
        this.each(function()
        {
            if(!$.data(this, "plugin_" + pluginName))
            {
                $.data(this, "plugin_" + pluginName, new Plugin(this, options));
            }
        });

        return this;
    };

})(jQuery, window, document);