$(function () {
    var Game = {
        stage: 1,
        animationDuration: 9,
        delay: 3,
        clickedGood: 0,
        itemsOnStage: 0,
        correctItemsOnStage: 0,
        currentItem: 0,
        currentStageItem: 0,
        currentWord: 0,
        score: 0,
        clickedLetters: [],
        goodWords: 0,
        words: [ "hand", "left", "right", "foot", "head", "backside" ],
        letters: [ 'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z' ],
        init: function () {
            var items = '';
            $('#word').html(Game.words[0]);
            $('#disp_score').html(Game.score);
            for (var i = 0; i < Game.words.length; i++) {
                var word = Game.words[i];
                var j = 0;
                while(j < word.length) {
                    var rand = Math.floor(Math.random()*10);
                    if(rand < 7){
                        items += '<div class="flying-item" data-word-id="'+ i +'" data-element-id="1">' + word[j] + '</div>';
                        j++;
                    }else{
                        var rand_letter = 0;
                        do{
                            rand_letter = Math.floor(Math.random()* Game.letters.length);
                        }while(word.indexOf(Game.letters[rand_letter]) > -1);
                        items += '<div class="flying-item" data-word-id="'+ i +'" data-element-id="0">' + Game.letters[rand_letter]  + '</div>';
                    }
                }
            }

            $('#stage1').append(items);

            $('.flying-item').on('click', function () {
                Game.choosen($(this));
            }).css('visibility', 'visible').hide();
        },
        animateItem: function ($item) {
            var left = Math.floor((Math.random() * ($('#stage1').width() - 250)));
            $item.css('left', left + 'px');
            if ($item.data('element-id') == 1) {
                Game.correctItemsOnStage++;
            }
            if($item.data('word-id') != Game.currentWord){
                $('#word').html(Game.words[$item.data('word-id')]);
                Game.clickedLetters = [];
                Game.currentWord = $item.data('word-id');
            }

            Game.currentStageItem++;
            $item.show();
            $item.animate({
                top: $(document).height() + "px"
            }, (Game.animationDuration - Game.stage + 1) * 1000, "linear", function () {
                var item_stage_id = $item.data('stage-id');
                $item.remove();
                if ( item_stage_id == Game.itemsOnStage && Game.stage <= 3) {
                    Game.nextStage();
                }
            });

        },
        startStage: function () {
            var items = $('#stage1').find('div.flying-item');
            Game.itemsOnStage = items.length;

            items.each(function (i, element) {
                $(element).data('stage-id', (i + 1));
                setTimeout(function () {
                    Game.currentItem++;
                    Game.animateItem($(element));
                }, Game.delay * 1000 * i);
            });


        },
        choosen: function ($element) {
            if ($element.data('element-id') == 1) {
                $element.addClass('good');
                Game.clickedGood++;
            } else {
                $element.addClass('wrong');
                Game.clickedGood--;
            }

            Game.clickedLetters.push($element.html());

            var current_word = Game.words[Game.currentWord];
            var clickedWord = Game.clickedLetters.join('');
            if(clickedWord.indexOf(current_word) > -1){
                Game.score += 10 * Game.stage;
                $('#disp_score').html(Game.score);
                Game.goodWords++;
            }
        },
        nextStage: function () {
            $('span#score').html(Game.score);
            if (Game.goodWords == Game.words.length) {
                $('#success_info').show();
                $('#wrong_info').hide();
                $('#stage-popup').removeClass('error');
            } else {
                $('#success_info').hide();
                $('#wrong_info').show();
                $('#stage-popup').addClass('error');
            }
            Game.stage++;
            Game.clickedGood = 0;
            Game.clickedLetters = [];
            Game.correctItemsOnStage = 0;
            Game.itemsOnStage = 0;
            Game.currentStageItem = 0;
            Game.goodWords = 0;
            $('#stage-popup').show();
            if (Game.stage > 3) {
                $('#next-stage').hide();
                $('.refresh.outer').show();
            }
        }

    };

    $('#start-game').on('click', function () {
        var first_count = 3;
        var first_counter = setInterval(countdown, 1000);
        $('.start-info').html('<span id="counter">3</span>');

        $('.refresh').on('click', function () {
            location.reload();
        });

        $.fn.randomize = function (a) {
            (a ? this.find(a) : this)
                .parent().each(function () {
                    $(this)
                        .children(a).sort(function () {
                            return Math.random() - 0.5
                        })
                        .detach().appendTo(this)
                });
            return this
        };

        $('body').delegate('a#next-stage', 'click', function () {
            $('#stage-popup').hide();
            Game.init();
            Game.startStage();
        });
        function countdown() {
            first_count--;
            $('span#counter').html(first_count);
            if (first_count <= 0) {
                $('.start-popup').hide();
                Game.init();
                Game.startStage();
                clearInterval(first_counter);
            }
        }



    });

});