$(function () {

    $('.emotion-name').draggable({
        start: function (event, ui) {
            ui.helper.data('dropped', false);

            if ($(this).parent().hasClass('name-cntnr') &&
                $(this).parent().children('.emotion-name').length == 1) {
                $(this).parent().find('span.message').show();
                $(this).parent().css('border', '1px solid red');
            }
            $(this).css('z-index', '1');
        },
        revert: function (dropped) {
            var dropped = dropped && dropped[0].id == "droppable";
            if (!dropped) {
                $(this).data("ui-draggable").originalPosition = {top: 0, left: 0};
                $(this).appendTo($(this).data('originalParent'));
               // $(this).css('width', 'auto');
            }
            if ($(this).parent().hasClass('name-cntnr')) {
                $(this).parent().find('span.message').hide();
                $(this).parent().css('border', 'none');
            }
            return !dropped;
        }
    });

    $('.name-cntnr').droppable({
        accept: ".emotion-name",
        activeClass: "ui-state-hover",
        hoverClass: "ui-state-active",
        drop: function (event, ui) {
            ui.draggable.data('dropped', true);
            $(this).find('span.message').hide();
            $(this).css('border', 'none');

            var prev_emotion = $(this).children('.emotion-name');

            if (prev_emotion.length > 0 &&
                prev_emotion.first().data('emotion-id') === ui.draggable.data('emotion-id')) {
                return true;
            }

            $(ui.draggable).detach().css({
                top: 0,
                left: 0
            }).appendTo(this)
                .css('z-index', '0').css('width', 'auto');


            prev_emotion.each(function () {
                $(this).appendTo('#emotions_labels').removeClass('notapproved')
                    .css('width', '15.66%');
            });

            if ($(this).data('emotion-id') === ui.draggable.data('emotion-id')) {
                $(this).parent().find('input').show();
                ui.draggable.draggable({disabled: true});
                $(this).droppable('disable');
                ui.draggable.removeClass('notapproved').addClass('approved');
            }else{
                ui.draggable.addClass('notapproved');
            }
        }
    });

    $('#emotions_labels').droppable({
        accept: ".emotion-name",
        activeClass: "ui-state-hover",
        hoverClass: "ui-state-active",
        drop: function (event, ui) {
            ui.draggable.data('dropped', true);
            $(ui.draggable).detach().css({
                top: 0,
                left: 0
            }).appendTo(this)
                .css('z-index', '0').css('width', '15.66%');

            ui.draggable.removeClass('notapproved');
        }
    });

    $('input').on('keyup', function () {
        if ($(this).val().toLowerCase() === $(this).data('emotion')) {
            $(this).css('border', '1px solid green');
        } else {
            $(this).css('border', '1px solid red');
        }


        var allRight = true;
        $('input').each(function () {
            if ($(this).val().toLocaleLowerCase()
                !== $(this).data('emotion')) {
                allRight = false;
            }
        });

        if (allRight) {
            $('div.end-popup').show();
            $('html, body').on('click', function () {
                $('div.end-popup').hide();
                location.reload();
            });
        }

    }).val('');

    $.fn.randomize = function (a) {
        (a ? this.find(a) : this)
            .parent().each(function () {
                $(this)
                    .children(a).sort(function () {
                        return Math.random() - 0.5
                    })
                    .detach().appendTo(this)
            });
        return this
    };
    $('div#emotions_labels div.col').randomize();
    $('div.col.bg-clr').randomize();

});

