;
(function($, window, document, undefined)
{
    var pluginName = "game",
        defaults = {
            photos: [
                {
                    url: "img/items/feta-cheese.png",
                    correctAnswer: "Greece"
                },
                {
                    url: "img/items/tapas.png",
                    correctAnswer: "Spain"
                },
                {
                    url: "img/items/wine-cheese.png",
                    correctAnswer: "France"
                },
                {
                    url: "img/items/fish-and-chips.png",
                    correctAnswer: "England"
                },
                {
                    url: "img/items/hamburger.png",
                    correctAnswer: "the USA"
                },
                {
                    url: "img/items/pizza.png",
                    correctAnswer: "Italy"
                },
                {
                    url: "img/items/sushi.png",
                    correctAnswer: "Japan"
                }
            ],
            answers: [
                "Greece",
                "Spain",
                "France",
                "England",
                "the USA",
                "Italy",
                "Japan"
            ]
        };

    function Plugin(element, options)
    {
        this.element = element;
        this.$element = $(element);
        this.settings = $.extend({}, defaults, options);
        this._defaults = defaults;
        this._name = pluginName;
        this.init();
    }

    $.extend(Plugin.prototype, {
        init: function()
        {
            var _this = this;

            var $el = $("<div class='element'><div class='photo'><img/></div><div class='answer'></div></div>");
            $.each(this.settings.photos, function(index, obj)
            {
                $el
                    .clone()
                    .find(".answer").attr("data-correct-answer", obj.correctAnswer).addClass("droppable").end()
                    .find("img").attr("src", obj.url).end()
                    .appendTo(_this.$element.find(".wrapper .photos"));
            });

            this.$element.find(".element").randomize();

            var $answer = $("<div/>").addClass("draggable");
            $.each(this.settings.answers, function(index, obj)
            {
                $answer
                    .clone()
                    .text(obj)
                    .appendTo(_this.$element.find(".wrapper .answers"));
            });

            this.$element.find(".draggable").draggable({
                revert: "invalid",
                helper: "clone",
                appendTo: "#game .wrapper"
            });

            this.$element.find(".droppable").droppable({
                accept: '.draggable',
                drop: function(evt, ui)
                {
                    if($(this).find(".draggable").size())
                    {
                        $(this).find(".draggable").appendTo(_this.$element.find(".answers"));
                    }

                    $(ui.draggable).detach().css({
                        top: 0,
                        left: 0
                    }).appendTo($(this));

                    _this.resizeFonts();
                    _this.check();

                    $(this).removeClass("active-drop");
                },
                over: function(event, ui)
                {
                    $(this).addClass('active-drop');
                },
                out: function(event, ui)
                {
                    $(this).removeClass('active-drop');
                }
            });


          //  Soundlink.init('sound-link', 'soundlink/');
            $('#jquery_jplayer_1').jPlayer({
                swfPath: '/',
                solution: 'html, flash',
                supplied: 'mp3',
                preload: 'metadata',
                volume: 0.8,
                muted: false,
                backgroundColor: '#000000',
                errorAlerts: true,
                warningAlerts: false,
                ready: function(event)
                {
                    $(this).jPlayer("setMedia", {
                        title: "",
                        mp3: "audio/kraje-do-potraw.mp3"
                    });
                }
            });

            $(window).on("resize", function()
            {
                _this.resize();
            }).trigger("resize");

            this.$element.find("#refresh").on("click", function()
            {
                window.location.reload();
                return false;
            });
        },
        resize: function()
        {
            this.$element.css("line-height", $(window).height() + "px");
            this.resizeFonts();
        },
        resizeFonts: function()
        {
            this.$element.find(".photos .draggable").each(function()
            {
                $(this).css("font-size", "25px");
                var fontSize = parseInt($(this).css("font-size"));
                while($(this).height() > 30 || $(this).width() > $(this).parent().width() - 10)
                {
                    fontSize -= 1;
                    $(this).css("font-size", fontSize + "px");
                }
            });
        },
        check: function()
        {
            this.$element.find(".answer").each(function()
            {
                $(this).removeClass("correct-answer").removeClass("incorrect-answer");

                if ($(this).find(".draggable").size())
                {
                    if($(this).attr("data-correct-answer") === $(this).find(".draggable").text())
                    {
                        $(this).addClass("correct-answer");
                    }
                    else
                    {
                        $(this).addClass("incorrect-answer");
                    }
                }
            });

            if (this.$element.find(".answer.correct-answer").size() === this.settings.answers.length)
            {
                this.$element.find(".popup.result-success, .popup-overlay").show();
            }
        }
    });
    $.fn.randomize = function(selector)
    {
        (selector ? this.find(selector) : this).parent().each(function()
        {
            $(this).children(selector).sort(function()
            {
                return Math.random() - 0.5;
            }).detach().appendTo(this);
        });

        return this;
    };
    $.fn[pluginName] = function(options)
    {
        this.each(function()
        {
            if(!$.data(this, "plugin_" + pluginName))
            {
                $.data(this, "plugin_" + pluginName, new Plugin(this, options));
            }
        });
        return this;
    };

})(jQuery, window, document);