;
(function ($, window, document, undefined) {
    $.fn.randomize = function (selector) {
        (selector ? this.find(selector) : this).parent().each(function () {
            $(this).children(selector).sort(function () {
                return Math.random() - Math.random();
            }).detach().appendTo(this);
        });

        return this;
    };

    var View = function (game, opts) {
        var _this = this;

        this.game = game;
        this.opts = opts;
        this.$element = $(opts.element);

        this.render = function () {
            var $sentence = $("<div><span/></div>").addClass("sentence"),
                $sentencePlaceholder = $("<div/>").addClass("sentence-placeholder");

            $.each(this.opts.sentences, function (i, sentence) {
                var $s = $sentence.clone()
                    .find("span").html(sentence.sentence).end()
                    .attr("data-correct-value", i)
                    .appendTo(_this.$element.find(".sentences-container .sentences"));

                var $sentencePh = $sentencePlaceholder.clone()
                    .attr("data-correct-value", i)
                    .addClass("sentence-placeholder-" + i)
                    .appendTo(_this.$element.find(".postcard"));
            });

            this.$element.find(".sentences-container .sentence").draggable({
                helper: "clone",
                revert: "invalid",
                appendTo: _this.$element.find(".tmp-container")
            });

            this.$element.find(".postcard .sentence-placeholder, .sentences-container").droppable({
                accept: ".sentence",
                drop: function (e, ui) {
                    $(this).removeClass("active-drop");
                    if ($(this).data('correct-value') == $(ui.draggable).data('correct-value')) {
                        $(this).removeClass("active-drop").addClass("has-text");

                        if ($(this).find(".sentence").size()) {
                            $(this).find(".sentence").appendTo(_this.$element.find(".sentences-container"));
                        }

                        $(ui.draggable).detach().appendTo($(this));

                        _this.check();
                    }
                },
                over: function () {
                    $(this).addClass("active-drop");
                },
                out: function () {
                    $(this).removeClass("active-drop");
                }
            });

            this.resize();

            this.$element.find(".popup.popup-instruction, .popup-overlay").show();
        };

        this.check = function () {
            var correct = 0;

            this.$element.find(".postcard .sentence-placeholder").each(function () {
                var $this = $(this);

                if ($this.find(".sentence").size()) {
                    if ($this.find(".sentence").attr("data-correct-value") === $this.attr("data-correct-value")) {
                        $this.addClass("result-correct");
                        correct += 1;
                    }
                    else {
                        $this.addClass("result-incorrect");
                    }
                }
            });

            if (correct === this.opts.sentences.length) {
                this.$element.find(".popup.popup-result, .popup-overlay").show();
            }
        };

        this.delegateEvents = function () {
            this.$element.find(".start").on("click", function () {
                _this.$element.find(".popup.popup-instruction, .popup-overlay").hide();
                return false;
            });

            this.$element.find("#refresh").on("click", function () {
                window.location.reload();
                return false;
            });

            $(window).on("resize", function () {
                _this.resize();
            }).trigger("resize");
        };

        this.resize = function () {
            //this.$element.find(".sentences-container").css("line-height", this.$element.find(".right-container").height() + "px");

            this.$element.find(".sentences-container .sentence").css("max-width", (this.$element.find(".postcard").width() * 0.9) + "px");

            this.$element.find(".postcard .sentence-placeholder").each(function () {
                var $this = $(this),
                    $sentence = _this.$element.find(".sentence[data-correct-value='" + $this.attr("data-correct-value") + "']"),
                    width = $sentence.find("span").width() + 15,
                    height = $sentence.find("span").height() + 14;

                $this.width(width).height(height);
            });
        };
    };

    var Game = function (opts) {
        this.opts = opts;
        this.view = new View(this, opts);

        this.start = function () {
            this.view.render();
            this.view.delegateEvents();
        };
    };

    window.Game = Game;

})(jQuery, window, document);