;
(function($, window, document, undefined)
{
    $.fn.randomize = function(selector)
    {
        (selector ? this.find(selector) : this).parent().each(function()
        {
            $(this).children(selector).sort(function()
            {
                return Math.random() - Math.random();
            }).detach().appendTo(this);
        });

        return this;
    };

    var View = function(game, opts)
    {
        var _this = this;

        this.game = game;
        this.opts = opts;
        this.$element = $(opts.element);

        this.render = function()
        {
            this.$element.find(".exercise-a .draggable").draggable({
                revert: function (dropped) {
                    if(!dropped){
                        $(this).appendTo($(this).data('originalParent'));
                        return true;
                    }

                    if(!$(dropped).hasClass('elements-container') && $(dropped).find(".element").length > 1) {
                        $(this).appendTo($(this).data('originalParent'));
                        return true;
                    }

                    if(!$(dropped).hasClass('elements-container') && $(dropped).find(".element").length == 1) {
                        $(this).css('left', '-3px').css('top', '-3px');
                    }
                    return false;
                }
            });

            this.$element.find(".exercise-a .droppable").droppable({
                accept: ".draggable",
                drop: function(e, ui)
                {
                    ui.draggable.data('dropped', true);
                    var $this = $(this);

                    var is_good = false;

                   if($this.find(".element").length > 0)
                    {
                       $this.find(".element").each(function(){
                           if($(this).hasClass('result-correct')){
                               is_good = true;
                               return false;
                           }
                           $(this).removeClass('result-incorrect').appendTo(_this.$element.find('.exercise-a').find(".elements-container"));
                       });
                    }
                    if(is_good) {
                        return false;
                    }
                    $(ui.draggable).detach().appendTo($(this));
                   // $(ui.draggable).css('top', 0).css('left', 0);
                    $this.removeClass("active-drop");

                    if($this.hasClass('text-container')){
                        $(ui.draggable).css('width', '100%').css('height', '100%')
                            .css('left', '-3px').css('top', '-3px').css('right', '-3px').css('bottom', '-3px');
                    }else{
                        $(ui.draggable).css('width', 'auto').css('height', 'auto').css('left', '0')
                            .css('top', '0').css('right', '-3px').css('bottom', '-3px');
                    }

                    _this.checkExerciseA();
                    _this.resize();
                },
                over: function()
                {
                    $(this).addClass("active-drop");
                },
                out: function()
                {
                    $(this).removeClass("active-drop");
                }
            });

            this.$element.find(".exercise-a .elements-container").droppable({
                accept: ".draggable",
                drop: function(e, ui)
                {
                    var $this = $(this);

                    $(ui.draggable).detach().appendTo($(this));
                    $(ui.draggable).css('top', '0').css('left', '0')

                },
                over: function()
                {
                    $(this).addClass("active-drop");
                },
                out: function()
                {
                    $(this).removeClass("active-drop");
                }
            });

            this.$element.find(".exercise-b .draggable").draggable({
                revert: function (dropped) {
                    if(!dropped){
                        $(this).appendTo($(this).data('originalParent'));
                        return true;
                    }

                    if(!$(dropped).hasClass('elements-container') && $(dropped).find(".element").length > 1) {
                        $(this).appendTo($(this).data('originalParent'));
                        return true;
                    }

                    if(!$(dropped).hasClass('elements-container') && $(dropped).find(".element").length == 1) {
                        $(this).css('left', '-3px').css('top', '-3px');
                    }
                    return false;
                }
            });

            this.$element.find(".exercise-b .droppable").droppable({
                accept: ".draggable",
                drop: function(e, ui)
                {
                    ui.draggable.data('dropped', true);
                    var $this = $(this);

                    if($this.find(".element").length > 0)
                    {
                        $this.find(".element").each(function(){
                            $(this).removeClass('result-incorrect').appendTo(_this.$element.find('.exercise-b').find(".elements-container"));
                        });
                    }



                    $(ui.draggable).detach().appendTo($(this));
                    $(ui.draggable).css('top', 0).css('left', 0);
                    $this.removeClass("active-drop");

                    if($this.hasClass('text-container')){
                        $(ui.draggable).css('width', '100%').css('height', '100%')
                            .css('left', '-3px').css('top', '-3px').css('right', '-3px');
                    }else{
                        $(ui.draggable).css('width', 'auto').css('height', 'auto').css('left', '0')
                            .css('top', '0').css('right', '-3px');
                    }

                    _this.resize();
                    _this.checkExerciseB();
                },
                over: function()
                {
                    $(this).addClass("active-drop");
                },
                out: function()
                {
                    $(this).removeClass("active-drop");
                }
            });

            this.$element.find(".exercise-b .elements-container").droppable({
                accept: ".draggable",
                drop: function(e, ui)
                {
                    var $this = $(this);

                    $(ui.draggable).detach().appendTo($(this));
                    $(ui.draggable).css('top', '0').css('left', '0')

                },
                over: function()
                {
                    $(this).addClass("active-drop");
                },
                out: function()
                {
                    $(this).removeClass("active-drop");
                }
            });

            this.$element.find(".exercise-a .element").randomize();
            this.$element.find(".exercise-a .clock").randomize();

            this.$element.find(".exercise-b .element").randomize();
            this.$element.find(".exercise-b .clock").randomize();

            this.$element.find(".popup.popup-instruction-a, .popup-overlay").show();
        };

        this.delegateEvents = function()
        {
            this.$element.find(".popup.popup-instruction-a .start").on("click", function()
            {
                _this.$element.find(".popup.popup-instruction-a, .popup-overlay").hide();
                return false;
            });

            this.$element.find(".popup.popup-result-a .next").on("click", function()
            {
                _this.$element.find(".popup.popup-result-a, .popup-overlay, .exercise-a").hide();
                _this.$element.find(".exercise-b").show();
                _this.$element.find(".popup.popup-instruction-b, .popup-overlay").show();
                return false;
            });

            this.$element.find(".popup.popup-instruction-b .start").on("click", function()
            {
                _this.$element.find(".popup.popup-instruction-b, .popup-overlay").hide();
                return false;
            });

            this.$element.find("#refresh").on("click", function()
            {
                window.location.reload();
                return false;
            });

            $(window).on("resize", function()
            {
                _this.resize();
            }).trigger("resize");
        };

        this.checkExerciseA = function()
        {
            var incorrect = 0,
                nbChecked = 0;
            this.$element.find(".exercise-a .text-container").each(function()
            {
                var $element = $(this).find(".element").removeClass("result-correct").removeClass("result-incorrect");
                if($element.size())
                {
                    nbChecked += 1;
                    if($element.attr("data-value") !== $(this).closest(".clock").attr("data-correct-value"))
                    {
                        $element.addClass("result-incorrect");
                        incorrect += 1;
                    }
                    else
                    {
                        $element.addClass("result-correct").draggable({disabled: true});
                    }
                }
            });

            if(incorrect === 0 && nbChecked === 5)
            {
                this.$element.find(".popup.popup-result-a, .popup-overlay").show();
            }
        };

        this.checkExerciseB = function()
        {
            var incorrect = 0,
                nbChecked = 0;
            this.$element.find(".exercise-b .text-container").each(function()
            {
                var $element = $(this).find(".element").removeClass("result-correct").removeClass("result-incorrect");
                if($element.size())
                {
                    nbChecked += 1;
                    if($element.attr("data-value") !== $(this).closest(".clock").attr("data-correct-value"))
                    {
                        $element.addClass("result-incorrect");
                        incorrect += 1;
                    }
                    else
                    {
                        $element.addClass("result-correct").draggable({disabled: true});
                    }
                }
            });

            if(incorrect === 0 && nbChecked === 3)
            {
                this.$element.find(".popup.popup-result-b, .popup-overlay").show();
            }
        };

        this.resize = function()
        {
            this.$element.find(".text-container .element span").each(function()
            {
                var fontSize = 22;
                do
                {
                    fontSize -= 2;
                    $(this).css("font-size", fontSize + "px");
                }
                while($(this).height() > 25);
            });
        };
    };

    var Game = function(opts)
    {
        this.opts = opts;
        this.view = new View(this, opts);

        this.start = function()
        {
            this.view.render();
            this.view.delegateEvents();
        };
    };

    window.Game = Game;

})(jQuery, window, document);