;
(function($, window, document, undefined)
{
    var pluginName = "game",
        defaults = {
            elements: [
                {
                    word: "one",
                    value: 1
                },
                {
                    word: "two",
                    value: 2
                },
                {
                    word: "three",
                    value: 3
                },
                {
                    word: "four",
                    value: 4
                },
                {
                    word: "five",
                    value: 5
                },
                {
                    word: "six",
                    value: 6
                },
                {
                    word: "seven",
                    value: 7
                },
                {
                    word: "eight",
                    value: 8
                },
                {
                    word: "nine",
                    value: 9
                },
                {
                    word: "ten",
                    value: 10
                },
                {
                    word: "eleven",
                    value: 11
                },
                {
                    word: "twelve",
                    value: 12
                },
                {
                    word: "thirteen",
                    value: 13
                },
                {
                    word: "fourteen",
                    value: 14
                },
                {
                    word: "fifteen",
                    value: 15
                },
                {
                    word: "sixteen",
                    value: 16
                },
                {
                    word: "seventeen",
                    value: 17
                },
                {
                    word: "eighteen",
                    value: 18
                },
                {
                    word: "nineteen",
                    value: 19
                },
                {
                    word: "twenty",
                    value: 20
                }
            ],
            result: [
                {
                    range: [0, 5],
                    img: "img/emoticon-angry.png",
                    text: "Następnym razem będzie lepiej!"
                },
                {
                    range: [6, 13],
                    img: "img/emoticon-sad.png",
                    text: "Może być lepiej!"
                },
                {
                    range: [14, 20],
                    img: "img/emoticon-happy.png",
                    text: "Super!"
                }
            ],
            secondsForAnimation: 14,
            maxScore: 20
        },
        shuffle = function shuffle(array)
        {
            var counter = array.length, temp, index;
            while(counter)
            {
                index = Math.floor(Math.random() * counter);
                counter--;
                temp = array[counter];
                array[counter] = array[index];
                array[index] = temp;
            }
            return array;
        };

    function Plugin(element, options)
    {
        this.element = element;
        this.$element = $(element);
        this.settings = $.extend({}, defaults, options);
        this._defaults = defaults;
        this._name = pluginName;
        this.init();

        this.currentElement = -1;
        this.score = {
            correct: 0,
            total: 0,
            incorrect: 0
        }
    }

    $.extend(Plugin.prototype, {
        init: function()
        {
            var $key = $("<div/>").addClass("key"),
                i,
                elements = [],
                _this = this,
                fnHandler = function()
                {
                    if(_this.$element.find(".element").attr("data-value") == $(this).attr("data-value"))
                    {
                        _this.$element.find(".element").addClass("transition").delay(400).animate({
                            opacity: 1
                        }, 0, function()
                        {
                            _this.score.correct += 1;
                            _this.$element.find(".score-correct").text(_this.score.correct);
                            $(this).stop(false, false).remove();
                            _this.animate(_this.getNextElement());
                        });
                    }
                    else
                    {
                        $(this).addClass("incorrect");
                    }
                    return false;
                };

            for(i = 1; i <= 20; i++)
            {
                $key.clone().attr("data-value", i).text(i).appendTo(this.$element.find(".keyboard .container")).on("click", fnHandler);
            }
            this.settings.elements = shuffle(this.settings.elements);

            this.$element.find(".start").on("click", function()
            {
                var intervalId = null,
                    timer = 3,
                    fnInterval = function()
                    {
                        timer -= 1;
                        _this.$element.find(".timer").text(timer);
                        if(timer === 0)
                        {
                            clearInterval(intervalId);
                            _this.$element.find(".timer").hide();
                            _this.startGame();
                        }
                    };

                $(this).animate({
                    opacity: 0
                }, 500, function()
                {
                    $(this).hide();
                    _this.$element.find(".timer").delay(1000).animate({
                        opacity: 1
                    }, 500);
                    _this.$element.find(".score-container").delay(1000).animate({
                        opacity: 1
                    });
                    _this.$element.find(".keyboard").delay(1000).animate({
                        opacity: 1
                    }, 500, function()
                    {
                        _this.$element.find(".timer").show();
                        intervalId = setInterval(fnInterval, 1000);
                    });
                });
                return false;
            });

            this.$element.find("#refresh").on("click", function()
            {
                window.location.reload();
                return false;
            });
        },
        startGame: function()
        {
            this.calculateSpeed();
            this.animate(this.getNextElement());
        },
        getNextElement: function()
        {
            return this.settings.elements[++this.currentElement];
        },
        getCurrentElement: function()
        {
            return this.settings.elements[this.currentElement];
        },
        displayResult: function()
        {
            var $img = $("<img/>"),
                $h1 = $("<h1/>"),
                i = 0,
                score = this.score.correct;

            for(i = 0; i < this.settings.result.length; i += 1)
            {
                if(score >= this.settings.result[i].range[0] && score <= this.settings.result[i].range[1])
                {
                    $img.attr("src", this.settings.result[i].img).appendTo(".popup.result");
                    $h1.text(this.settings.result[i].text);
                    break;
                }
            }
            this.$element.find(".popup-overlay, .popup.result").show().prepend($h1);
            this.$element.find(".score-container").appendTo(this.$element.find(".popup"));
            this.$element.find(".score-container .score-correct").before($("<span/>").text("Dobre odpowiedzi: "));
            this.$element.find(".score-container .score-incorrect").before($("<span/>").text("Złe odpowiedzi: "));
        },
        animate: function(element)
        {
            if(!element)
            {
                return this.displayResult();
            }
            this.score.total += 1;
            this.$element.find(".key.incorrect").removeClass("incorrect");
            var _this = this,
                $el = $("<div><span></span></div>")
                    .addClass("element")
                    .attr("data-value", element.value)
                    .find("span").text(element.word).end()
                    .prependTo(this.$element)
                    .delay(300)
                    .css({
                        left: Math.floor(Math.random() * (70 - 30 + 1) + 30) + "%"
                    })
                    .animate({
                        top: this.maxTop + "px"
                    }, {
                        duration: this.settings.secondsForAnimation * 1000,
                        queue: false,
                        easing: "linear",
                        complete: function()
                        {
                            _this.score.incorrect += 1;
                            _this.$element.find(".score-incorrect").text(_this.score.incorrect);
                            $(this).remove();
                            _this.animate(_this.getNextElement())
                        }
                    });
        },
        calculateSpeed: function()
        {
            this.maxTop = $(window).height();
        }
    });

    $.fn[pluginName] = function(options)
    {
        this.each(function()
        {
            if(!$.data(this, "plugin_" + pluginName))
            {
                $.data(this, "plugin_" + pluginName, new Plugin(this, options));
            }
        });

        return this;
    };

})(jQuery, window, document);