;
(function ($, window, document, undefined) {
    var pluginName = "game",
        defaults = {
            elements: [
                {
                    img: "http://placehold.it/250x250",
                    correctAnswer: "summer"
                },
                {
                    img: "http://placehold.it/250x250",
                    correctAnswer: "summer"
                },
                {
                    img: "http://placehold.it/250x250",
                    correctAnswer: "summer"
                },
                {
                    img: "http://placehold.it/250x250",
                    correctAnswer: "summer"
                },
                {
                    img: "http://placehold.it/250x250",
                    correctAnswer: "summer"
                },
                {
                    img: "http://placehold.it/250x250",
                    correctAnswer: "summer"
                },
                {
                    img: "http://placehold.it/250x250",
                    correctAnswer: "summer"
                },
                {
                    img: "http://placehold.it/250x250",
                    correctAnswer: "summer"
                },
                {
                    img: "http://placehold.it/250x250",
                    correctAnswer: "summer"
                },
                {
                    img: "http://placehold.it/250x250",
                    correctAnswer: "summer"
                },
                {
                    img: "http://placehold.it/250x250",
                    correctAnswer: "summer"
                },
                {
                    img: "http://placehold.it/250x250",
                    correctAnswer: "summer"
                }
            ]
        };

    function Plugin(element, options) {
        this.element = element;
        this.$element = $(element);
        this.settings = $.extend({}, defaults, options);
        this._defaults = defaults;
        this._name = pluginName;
        this.init();
    }

    $.extend(Plugin.prototype, {
        init: function () {
            var _this = this;

            var $el = $("<div class='element'><div class='photo'><img/></div><div class='input'><input type='text' /></div></div>");
            $.each(this.settings.elements, function (index, obj) {
                $el
                    .clone()
                    .find("input").attr("data-correct-answer", obj.correctAnswer).end()
                    .find("img").attr("src", obj.img).end()
                    .prependTo(_this.$element.find(".elements .wrapper"));
            });

            this.$element.find(".element").randomize().hover(function () {
                $(this).addClass("transition");
            }, function () {
                if (!$(this).find("input").hasClass("focused")) {
                    $(this).removeClass("transition");
                }
            }).on("click", function () {
                $(this).find("input").trigger("focus").focus();
            });
            this.$element.find("input").on("keyup", function () {
                $(this)
                    .removeClass("value-incorrect")
                    .removeClass("value-correct")
                    .removeClass("focused")
                    .closest(".element")
                    .removeClass("transition");

                if ($.trim($(this).val())) {
                    if ($.trim($(this).val().toLowerCase()) !== $.trim($(this).attr("data-correct-answer").toLowerCase())) {
                        $(this).addClass("value-incorrect");
                    }
                    else {
                        $(this).addClass("value-correct");
                        $(this).attr('disabled', 'disabled');
                        _this.checkResult();
                    }
                }
            }).on("keydown", function () {
                $(this).removeClass("value-incorrect").removeClass("value-correct");
            }).on("focus", function () {
                $(this).addClass("focused").closest(".element").addClass("transition");
            }).on("blur", function () {
                if ($.trim($(this).val().toLowerCase()) !== $.trim($(this).attr("data-correct-answer").toLowerCase())) {
                    $(this).addClass("value-incorrect");
                }
            });

            $(window).on("resize", function () {
                _this.resize();
            }).trigger("resize");

            this.$element.find("#refresh").on("click", function () {
                window.location.reload();
                return false;
            });

            this.$element.find("#initial-popup").show();

            this.$element.find("#start-game").on("click", function()
            {
                    var first_count = 3;
                    var first_counter = setInterval(countdown, 1000);
                    $('#initial-popup-info').html('<span id="counter">3</span>');

                    function countdown() {
                        first_count--;
                        $('span#counter').html(first_count);
                        if (first_count <= 0) {
                            $('#initial-popup').hide();
                            clearInterval(first_counter);
                        }
                    }

                return false;
            });
        },
        resize: function () {
            this.$element.find(".elements").css("line-height", $(window).height() + "px");
        },
        checkResult: function () {
            var allok = true;
            $('.element').find('input').each(function () {
                if ($.trim($(this).val().toLowerCase()) !== $.trim($(this).attr("data-correct-answer").toLowerCase())) {
                    allok = false;
                }
            });

            if (allok) {
                $('#end-popup-success').show();
            }
        }
    });
    $.fn.randomize = function (selector) {
        (selector ? this.find(selector) : this).parent().each(function () {
            $(this).children(selector).sort(function () {
                return Math.random() - 0.5;
            }).detach().appendTo(this);
        });

        return this;
    };
    $.fn[pluginName] = function (options) {
        this.each(function () {
            if (!$.data(this, "plugin_" + pluginName)) {
                $.data(this, "plugin_" + pluginName, new Plugin(this, options));
            }
        });
        return this;
    };

    $('body').delegate('.refresh', 'click', function () {
        location.reload();
    });


})(jQuery, window, document);