;
(function($, window, document, undefined)
{
    var pluginName = "game",
        defaults = {
            elementsToDrag: [
                {
                    word: "styczeń",
                    position: 1
                },
                {
                    word: "luty",
                    position: 2
                },
                {
                    word: "kwiecień",
                    position: 4
                },
                {
                    word: "czerwiec",
                    position: 6
                },
                {
                    word: "lipiec",
                    position: 7
                },
                {
                    word: "sierpień",
                    position: 8
                },
                {
                    word: "październik",
                    position: 10
                },
                {
                    word: "listopad",
                    position: 11
                },
                {
                    word: "grudzień",
                    position: 12
                }
            ],
            elementsToType: [
                {
                    word: "marzec",
                    position: 3
                },
                {
                    word: "maj",
                    position: 5
                },
                {
                    word: "wrzesień",
                    position: 9
                }
            ]
        };

    function Plugin(element, options)
    {
        this.element = element;
        this.$element = $(element);
        this.settings = $.extend({}, defaults, options);
        this._defaults = defaults;
        this._name = pluginName;
        this.init();
    }

    $.extend(Plugin.prototype, {
        init: function()
        {
            var _this = this,
                i = 0,
                length = this.settings.elementsToDrag.length + this.settings.elementsToType.length,
                droppableContainer = $('<div/>').addClass("table"),
                $droppable = $("<div class='element'><div class='number'></div><div class='container'></div></div>"), $newTr,
                j = 0,
                insertInput,
                insertPositions = [],
                $draggable = $("<div/>").addClass("draggable");

            for (i = 0; i < length; i += 1)
            {
                insertInput = false;
                for (j = 0; j < this.settings.elementsToType.length; j += 1)
                {
                    if (this.settings.elementsToType[j].position === i + 1 && insertPositions.indexOf(this.settings.elementsToType[j].position) === -1)
                    {
                        insertPositions.push(this.settings.elementsToType[j].position);
                        insertInput = true;
                        break;
                    }
                }
                $newTr = $droppable
                    .clone()
                    .find(".number").text(i + 1 + ".").end()
                    .appendTo(droppableContainer);

                if (insertInput)
                {
                    $newTr.attr("data-correct-value", this.settings.elementsToType[j].word).find('.container').addClass("has-input").html('<input type="text" />');
                }
                else
                {
                    $newTr.attr("data-position", i + 1).find(".container").addClass("droppable");
                }
            }
            droppableContainer.appendTo(this.$element.find(".left .elements"));

            $.each(this.settings.elementsToDrag, function(index, obj)
            {
                $draggable
                    .clone()
                    .text(obj.word)
                    .attr("data-position", obj.position)
                    .appendTo(_this.$element.find(".right .elements"));
            });

            this.$element.find(".draggable").randomize();

            this.$element.find(".draggable").draggable({
                revert: "invalid",
                helper: "clone",
                appendTo: "#game .wrapper"
            });

            this.$element.find(".droppable").droppable({
                accept: '.draggable',
                drop: function(evt, ui)
                {
                    if($(this).find(".draggable").size())
                    {
                        $(this).find(".draggable").appendTo(_this.$element.find(".right .elements"));
                    }

                    $(ui.draggable).detach().css({
                        top: 0,
                        left: 0,
                        height: "auto",
                        lineHeight: 1
                    }).appendTo($(this));

                    $(this).removeClass("active-drop");

                    _this.resize();
                    _this.check();
                },
                over: function(event, ui)
                {
                    $(this).addClass('active-drop');
                },
                out: function(event, ui)
                {
                    $(this).removeClass('active-drop');
                }
            });

            this.$element.find("input").on("blur", function()
            {
                _this.check();
                _this.resize();
            });

            $(window).on("resize", function()
            {
                _this.resize();
            }).trigger("resize");

            this.$element.find("#refresh").on("click", function()
            {
                window.location.reload();
                return false;
            });
        },
        resize: function()
        {
            var height = this.$element.find(".left .elements").height() / this.$element.find(".element").size() - 1,
                lineHeight = Math.floor(height);
            this.$element.find(".element").height(Math.floor(height)).css("line-height", lineHeight + "px");
            this.$element.find(".element input")
                .height(Math.floor(height * 0.7))
                .css("line-height", Math.floor(lineHeight * 0.7) + "px")
                .css("font-size", Math.floor(lineHeight * 0.6) + "px");
            this.$element.find(".element .draggable").height(Math.floor(height * 0.5)).css("line-height", Math.floor(lineHeight * 0.5) + "px");
        },
        check: function()
        {
            var successed = 0;
            this.$element.find(".element .draggable, .element input").each(function()
            {
                $(this).closest(".element").removeClass("answer-correct").removeClass("answer-incorrect");

                if ($(this).is(".draggable"))
                {
                    if ($(this).attr("data-position") === $(this).closest(".element").attr("data-position"))
                    {
                        $(this).closest(".element").addClass("answer-correct");
                        successed += 1;
                    }
                    else
                    {
                        $(this).closest(".element").addClass("answer-incorrect");
                    }
                }
                else
                {
                    if ($.trim($(this).val()))
                    {
                        if($(this).closest(".element").attr("data-correct-value").toLowerCase() === $.trim($(this).val().toLowerCase()))
                        {
                            $(this).closest(".element").addClass("answer-correct");
                            successed += 1;
                        }
                        else
                        {
                            $(this).closest(".element").addClass("answer-incorrect");
                        }
                    }
                }
            });

            if (successed === this.settings.elementsToDrag.length + this.settings.elementsToType.length)
            {
                this.$element.find(".popup-overlay, .popup").show();
            }
        }
    });
    $.fn.randomize = function(selector)
    {
        (selector ? this.find(selector) : this).parent().each(function()
        {
            $(this).children(selector).sort(function()
            {
                return Math.random() - 0.5;
            }).detach().appendTo(this);
        });

        return this;

};
$.fn[pluginName] = function(options)
{
    this.each(function()
    {
        if(!$.data(this, "plugin_" + pluginName))
        {
            $.data(this, "plugin_" + pluginName, new Plugin(this, options));
        }
    });
    return this;
};

})(jQuery, window, document);