;
(function($, window, document, undefined)
{
    $.fn.randomize = function(selector)
    {
        (selector ? this.find(selector) : this).parent().each(function()
        {
            $(this).children(selector).sort(function()
            {
                return Math.random() - Math.random();
            }).detach().appendTo(this);
        });

        return this;
    };

    var View = function(game, opts)
    {
        var _this = this;

        this.game = game;
        this.opts = opts;
        this.$element = $(opts.element);

        this.render = function()
        {
            var $element = $("<div><div class='image-container'><img src alt /></div><div class='text-container'></div><div class='answer-container'></div></div>").addClass("element");

            $.each(this.opts.elements, function(i, element)
            {
                var $el = $element.clone().appendTo(_this.$element.find(".elements-container")).attr("data-correct-answer", i),
                    $answer = $("<div/>").addClass("answer");

                if(element.hasOwnProperty("img"))
                {
                    $el.addClass("has-image").find("img").attr("src", element.img);
                }
                else
                {
                    if(element.hasOwnProperty("txt"))
                    {
                        $el.addClass("has-text").find(".text-container").text(element.txt);
                    }
                }

                var $a = $answer.clone().text(element.answer).appendTo(_this.$element.find(".answers-container")).attr("data-correct-answer", i);
            });

            this.$element.find(".answer").randomize().draggable({
                helper: "clone",
                appendTo: _this.$element.find(".tmp-container"),
                revert: "invalid"
            });

            this.$element.find(".element .answer-container").droppable({
                accept: ".answer",
                drop: function(e, ui)
                {
                    $(this).removeClass("active-drop");

                    if($(this).find(".answer").size())
                    {
                        $(this).find(".answer").appendTo(_this.$element.find(".answers-container"));
                    }

                    $(ui.draggable).detach().appendTo($(this));
                    _this.resize();
                    _this.check();
                },
                over: function()
                {
                    $(this).addClass("active-drop");
                },
                out: function()
                {
                    $(this).removeClass("active-drop");
                }
            });

            this.$element.find(".popup-instruction, .popup-overlay").show();
        };

        this.delegateEvents = function()
        {
            this.$element.find("#refresh").on("click", function()
            {
                window.location.reload();
                return false;
            });

            $(window).on("resize", function()
            {
                _this.resize();
            }).trigger("resize");

            this.$element.find(".start").on("click", function()
            {
                _this.$element.find(".popup-instruction, .popup-overlay").hide();
                return false;
            });
        };

        this.check = function()
        {
            this.$element.find(".element .answer").each(function()
            {
                var $answer = $(this).removeClass("result-correct").removeClass("result-incorrect"),
                    $element = $answer.closest(".element");

                if($answer.attr("data-correct-answer") === $element.attr("data-correct-answer"))
                {
                    $answer.addClass("result-correct");
                }
                else
                {
                    $answer.addClass("result-incorrect");
                }
            });

            if(this.$element.find(".element .answer").size() === this.opts.elements.length)
            {
                this.$element.find(".popup.popup-result, .popup-overlay").show();
            }
        };

        this.resize = function()
        {
            this.$element.find(".element .text-container").css("line-height", this.$element.find(".element .text-container:visible").height() + "px");
            this.$element.find(".answers-container").css("line-height", this.$element.find(".answers-container").height() + "px");
            this.$element.find(".element .answer").css("line-height", this.$element.find(".element .answer-container").height() + "px");
        };
    };

    var Game = function(opts)
    {
        this.opts = opts;
        this.view = new View(this, opts);

        this.start = function()
        {
            this.view.render();
            this.view.delegateEvents();
        };
    };

    window.Game = Game;

})(jQuery, window, document);