;
(function($, window, document, undefined)
{
    $.fn.randomize = function(selector)
    {
        (selector ? this.find(selector) : this).parent().each(function()
        {
            $(this).children(selector).sort(function()
            {
                return Math.random() - Math.random();
            }).detach().appendTo(this);
        });

        return this;
    };

    var View = function(game, opts)
    {
        var _this = this;

        this.game = game;
        this.opts = opts;
        this.$element = $(opts.element);

        this.render = function()
        {
            var $element = $("<div><div class='photo-container'><img src alt /></div><div class='input-container'><input type='text' /></div></div>").addClass("element"),
                $word = $("<div/>").addClass("word");

            $.each(this.opts.elements, function(i, element)
            {
                var $el = $element.clone()
                    .appendTo(_this.$element.find(".elements"))
                    .find("img").attr("src", element.img).end()
                    .find("input").attr("data-correct-value", element.correctValue).end();

                var $w = $word.clone()
                    .text(element.correctValue)
                    .appendTo(_this.$element.find(".words"));
            });

            this.$element.find(".element").randomize();
            this.$element.find(".word").randomize();

            this.$element.screenKeyboard({
                keys: {
                    type: "alpha"
                },
                inputs: {
                    selectors: ["input"],
                    next: function($input)
                    {
                        if($input.val() && $input.val().toLowerCase() === $input.attr("data-correct-value"))
                        {
                            return $input.closest(".element").next(".element").find("input");
                        }
                    }
                }
            });

            this.$element.on("screenKeyboard.on", function()
            {
                _this.$element.find("input:not(.result-correct)").trigger("click");
                _this.$element.addClass("screen-keyboard-on");
            });

            this.$element.on("screenKeyboard.off", function()
            {
                _this.$element.removeClass("screen-keyboard-on");
            });

            this.$element.find(".popup-instruction, .popup-overlay").show();
        };

        this.delegateEvents = function()
        {
            this.$element.find("#refresh").on("click", function()
            {
                window.location.reload();
                return false;
            });

            this.$element.find("input").on("keyup", function()
            {
                var $this = $(this).removeClass("result-correct").removeClass("result-incorrect"),
                    value = $this.val() || "";

                if(value)
                {
                    if(value.toLowerCase() === $this.attr("data-correct-value").toLowerCase())
                    {
                        $this.addClass("result-correct");
                        _this.check();
                    }
                }
            }).on("blur", function()
            {
                var $this = $(this).removeClass("result-correct").removeClass("result-incorrect"),
                    value = $this.val() || "";

                if(value)
                {
                    if(value.toLowerCase() === $this.attr("data-correct-value").toLowerCase())
                    {
                        $this.addClass("result-correct")
                    }
                    else
                    {
                        $this.addClass("result-incorrect");
                    }
                    _this.check();
                }
            });

            this.$element.find(".start").on("click", function()
            {
                _this.$element.find(".popup-instruction, .popup-overlay").hide();
                return false;
            });

            $(window).on("resize", function()
            {
                _this.resize();
            }).trigger("resize");
        };

        this.check = function()
        {
            if(this.$element.find("input.result-correct").size() === this.$element.find("input").size())
            {
                _this.$element.data("plugin_screenKeyboard").hideKeyboard();
                _this.$element.find(".popup.popup-result, .popup-overlay").show();
            }
        };

        this.resize = function()
        {
            this.$element.find(".words").css("line-height", this.$element.find(".words").height() + "px");
            this.$element.find(".elements").css("line-height", this.$element.find(".elements").height() + "px");
        };
    };

    var Game = function(opts)
    {
        this.opts = opts;
        this.view = new View(this, opts);

        this.start = function()
        {
            this.view.render();
            this.view.delegateEvents();
        };
    };

    window.Game = Game;

})(jQuery, window, document);