;
(function($, window, document, undefined)
{
    var pluginName = "game",
        defaults = {
            equations: [
                {
                    equation: "7 + 8 = ",
                    correctValue: 15
                },
                {
                    equation: "6 + 5 = ",
                    correctValue: 11
                },
                {
                    equation: "9 + 8 = ",
                    correctValue: 17
                },
                {
                    equation: "6 + 6 = ",
                    correctValue: 12
                },
                {
                    equation: "8 + 9 = ",
                    correctValue: 17
                },
                {
                    equation: "3 + 8 = ",
                    correctValue: 11
                }
            ]
        };

    function Plugin(element, options)
    {
        this.element = element;
        this.$element = $(element);
        this.settings = $.extend({}, defaults, options);
        this._defaults = defaults;
        this._name = pluginName;
        this.init();
    }

    $.extend(Plugin.prototype, {
        init: function()
        {
            var _this = this;

            this.currentEquation = -1;
            this.showNextEquation();

            this.$element.find(".next").on("click", function()
            {
                _this.showNextEquation();
                return false;
            });

            this.$element.find("#refresh").on("click", function()
            {
                window.location.reload();
                return false;
            });

            this.$element.find(".popup-instruction .start").on("click", function()
            {
                _this.$element.find(".popup.popup-instruction, .popup-overlay").hide();
                return false;
            });

            this.$element.screenKeyboard({
                keys: {
                    type: "num"
                },
                inputs: {
                    selectors: ["input"]
                }
            });

            this.$element.on("screenKeyboard.on", function()
            {
                _this.$element.find(".equation-wrapper input").trigger("click");
                $('#game .wrapper').addClass("screen-keyboard-on");
            }).on("screenKeyboard.off", function () {
                $('#game .wrapper').removeClass("screen-keyboard-on");
            });

            $(window).on("resize", function()
            {
                _this.resize();
            }).trigger("resize");

            this.$element.find(".popup.popup-instruction, .popup-overlay").show();
        },
        showNextEquation: function()
        {
            var _this = this;

            this.currentEquation += 1;
            this.$element.find(".next").hide();
            if(this.currentEquation === this.settings.equations.length)
            {
                this.$element.data("plugin_screenKeyboard").hideKeyboard();
                $(".popup.popup-result, .popup-overlay").show();
            }
            else
            {
                var element = this.settings.equations[this.currentEquation],
                    $equation = this.$element.find("#template-equation").clone()
                        .find("p").text(element.equation).end()
                        .find("input").attr("data-correct-value", element.correctValue).end()
                        .html();

                this.$element.find(".wrapper .equation-wrapper").remove();
                $($equation).appendTo(this.$element.find(".wrapper")).find("input").on("keyup", function()
                {
                    var $this = $(this).removeClass("result-correct").removeClass("result-incorrect"),
                        value = $this.val();

                    if(value)
                    {
                        if(value === $this.attr("data-correct-value"))
                        {
                            $this.addClass("result-correct");
                            _this.$element.find(".next").show();
                        }
                        else
                        {
                            $this.addClass("result-incorrect");
                        }
                    }
                }).trigger("focus").trigger("click").end();
            }
        },
        resize: function()
        {
            var height = $(".wrapper").height();
            this.$element.find(".wrapper").css("line-height", height + "px");
        }
    });
    $.fn.randomize = function(selector)
    {
        (selector ? this.find(selector) : this).parent().each(function()
        {
            $(this).children(selector).sort(function()
            {
                return Math.random() - Math.random();
            }).detach().appendTo(this);
        });

        return this;
    };
    $.fn[pluginName] = function(options)
    {
        this.each(function()
        {
            if(!$.data(this, "plugin_" + pluginName))
            {
                $.data(this, "plugin_" + pluginName, new Plugin(this, options));
            }
        });
        return this;
    };

})(jQuery, window, document);