;
(function($, window, document, undefined)
{
    $.fn.randomize = function(selector)
    {
        (selector ? this.find(selector) : this).parent().each(function()
        {
            $(this).children(selector).sort(function()
            {
                return Math.random() - Math.random();
            }).detach().appendTo(this);
        });

        return this;
    };

    var View = function(game, opts)
    {
        var _this = this;

        this.game = game;
        this.opts = opts;
        this.$element = $(opts.element);

        this.render = function()
        {
            var $element = $("<div><div class='photo-container'><img src alt /></div></div>").addClass("element"),
                $droppable = $("<div></div>").addClass("element-placeholder");

            $.each(this.opts.elements, function(i, element)
            {
                var $el = $element.clone()
                    .find("img").attr("src", element.img).end()
                    .attr("data-element-index", i)
                    .appendTo(_this.$element.find(".elements"));

                var $drppble = $droppable.clone()
                    .html(element.value.replace(" ", "<br/>"))
                    .attr("data-element-index", i)
                    .appendTo(_this.$element.find(".element-placeholders"));
            });

            this.$element.find(".element").randomize();
            this.$element.find(".element-placeholder").randomize();

            this.$element.find(".popup.popup-instruction, .popup-overlay").show();
        };

        this.delegateEvents = function()
        {
            this.$element.find("#refresh").on("click", function()
            {
                window.location.reload();
                return false;
            });

            this.$element.find(".start").on("click", function()
            {
                _this.$element.find(".popup.popup-instruction, .popup-overlay").hide();
                return false;
            });

            this.$element.find(".element").draggable({
                helper: "clone",
                revert: "invalid",
                appendTo: _this.$element.find(".elements")
            });

            this.$element.find(".element-placeholder").droppable({
                accept: function($draggable)
                {
                    return $draggable.attr("data-element-index") === $(this).attr("data-element-index");
                },
                drop: function(e, ui)
                {
                    $(this).removeClass("active-drop");

                    $(ui.draggable).detach().appendTo($(this));
                    _this.check();
                },
                over: function()
                {
                    $(this).addClass("active-drop");
                },
                out: function()
                {
                    $(this).removeClass("active-drop");
                }
            });

            $(window).on("resize", function()
            {
                _this.resize();
            }).trigger("resize");
        };

        this.check = function()
        {
            if(this.$element.find(".element-placeholder .element").size() === this.opts.elements.length)
            {
                this.$element.find(".popup.popup-result, .popup-overlay").show();
            }
        };

        this.resize = function()
        {
            this.$element.find(".element-placeholders-outer, .elements-outer").css("line-height", this.$element.find(".element-placeholders-outer").height() + "px");
        };
    };

    var Game = function(opts)
    {
        this.opts = opts;
        this.view = new View(this, opts);

        this.start = function()
        {
            this.view.render();
            this.view.delegateEvents();
        };
    };

    window.Game = Game;

})(jQuery, window, document);