;
(function($, window, document, undefined)
{
    var pluginName = "game",
        defaults = {};

    function Plugin(element, options)
    {
        this.element = element;
        this.$element = $(element);
        this.settings = $.extend({}, defaults, options);
        this._defaults = defaults;
        this._name = pluginName;
        this.init();
    }

    $.extend(Plugin.prototype, {
        init: function()
        {
            var _this = this,
                $signModal = $("<div><input type='text' /></div>").addClass("sign-modal");

            this.$element.find(".elements-1 .element").randomize();
            this.$element.find(".elements-2 .element").randomize();

            this.$element.find(".element").each(function()
            {
                var $sm = $signModal.clone();

                $(this).on("click", function()
                {
                    var $this = $(this);
                    if($this.is(".is-correct"))
                    {
                        return false;
                    }

                });
            });

            this.$element.find("#boy").droppable({
                accept: ".element",
                drop: function(e, ui)
                {
                    var $this = this,
                        $draggable = $(ui.draggable),
                        draggableLeft = ui.position.left / _this.$element.find("#boy").width(),
                        draggableTop = ui.position.top / _this.$element.find("#boy").height(),
                        correctLeft = $draggable.attr("data-correct-position-left"),
                        correctTop = $draggable.attr("data-correct-position-top"),
                        correctLeftValue = parseInt(correctLeft, 10) / 100,
                        correctTopValue = parseInt(correctTop, 10) / 100;

                    if(draggableLeft < correctLeftValue + 0.15 && draggableLeft > correctLeftValue - 0.15
                        && draggableTop < correctTopValue + 0.15 && draggableTop > correctTopValue - 0.15)
                    {
                        $draggable.detach().css({
                            position: "absolute",
                            left: (correctLeftValue * 100) + "%",
                            top: (correctTopValue * 100) + "%"
                        }).appendTo($(this));

                        var $sm = $signModal.clone();
                        $sm.appendTo(_this.$element.find(".sign-modals"))
                            .css({
                                left: Math.floor(($draggable.offset().left + $draggable.width() / 2) - ($sm.outerWidth() / 2)) + "px",
                                top: Math.floor(($draggable.offset().top + $draggable.height() / 2) - ($sm.outerHeight() / 2)) + "px"
                            })
                            .fadeIn("fast").find("input").on("keyup", function onKeyUp(e)
                            {
                                var value = $(this).val() || "",
                                    correctValue = $draggable.attr("data-correct-value");

                                if(value.toLocaleLowerCase() === correctValue.toLowerCase())
                                {

                                    $(this).closest(".sign-modal").fadeOut("fast", function()
                                    {
                                        $(this).remove();
                                    });

                                    $draggable.addClass("result-correct");

                                    _this.check();
                                }
                            }).trigger("focus");
                    }
                    else
                    {
                        $draggable.detach().css({
                            position: "relative"
                        }).appendTo(_this.$element.find(".elements-2"));
                    }
                }
            });

            this.$element.find(".element").draggable({
                appendTo: "#game .wrapper #boy",
                helper: "clone",
                revert: "invalid"
            });

            this.$element.find("#refresh").on("click", function()
            {
                window.location.reload();
                return false;
            });

            $(window).on("resize", function()
            {
                _this.resize();
            }).trigger("resize");

            this.$element.find(".popup.popup-instruction .start").on("click", function()
            {
                _this.$element.find(".popup.popup-instruction, .popup-overlay").hide();
                return false;
            });

            this.$element.find(".popup.popup-instruction, .popup-overlay").show();
        },
        check: function()
        {
            if(this.$element.find(".element.result-correct").size() === this.$element.find(".element").size())
            {
                this.$element.find(".popup, .popup-overlay").show();
            }
        },
        resize: function()
        {
            var windowWidth = $(window).width(),
                windowHeight = $(window).height(),
                boySizeRatio = 588 / 1451,
                boyHeight = windowHeight * 0.8,
                boyWidth = boyHeight * boySizeRatio;

            this.$element.find("#boy").width(boyWidth).height(boyHeight);
            this.$element.find(".elements").width(boyWidth).height(boyHeight);

            var sizeRatioWidth = boyWidth / 588,
                sizeRatioHeight = boyHeight / 1451;

            this.$element.find(".element").each(function()
            {
                var $el = $(this),
                    originalWidth = $el.attr("data-original-width"),
                    originalHeight = $el.attr("data-original-height");

                $el.width(originalWidth * sizeRatioWidth).height(originalHeight * sizeRatioHeight);
            });
        }
    });
    $.fn.randomize = function(selector)
    {
        (selector ? this.find(selector) : this).parent().each(function()
        {
            $(this).children(selector).sort(function()
            {
                return Math.random() - Math.random();
            }).detach().appendTo(this);
        });

        return this;
    };
    $.fn[pluginName] = function(options)
    {
        this.each(function()
        {
            if(!$.data(this, "plugin_" + pluginName))
            {
                $.data(this, "plugin_" + pluginName, new Plugin(this, options));
            }
        });
        return this;
    };

})(jQuery, window, document);