var class_draggable = '.caption';
var class_droppable = '.image-caption';
var screenid = 1;

function startThird(){
    $('.illustrations-box .illustration img').on('click', function(){
       if($(this).parent().hasClass('chosen')){
           $(this).parent().removeClass('chosen');
       } else{
           $(this).parent().addClass('chosen');
       }
        testOrder();
    });
    $('.illustration').randomize();
}

function testOrder() {
    var all = true;
    var allok = true;
    switch(screenid){
        case 1:
            $(class_droppable + '.screen-1').each(function () {
                if ($(this).find(class_draggable).length == 0) {
                    all = false;
                }

                if($(this).data('element-id') != $(this).find(class_draggable).data('element-id')){
                    allok = false;
                }
            });

            if(all && allok){
                $('#first-screen').hide();
                $('#second-screen').show();
                $('.caption.screen-2').randomize();
                screenid++;
            }
            break;
        case 2:
            $(class_droppable + '.screen-2').each(function () {
                if ($(this).find(class_draggable).length == 0) {
                    all = false;
                }

                if($(this).data('element-id') != $(this).find(class_draggable).data('element-id')){
                    allok = false;
                }
            });

            if(all && allok){
                $('#second-screen').hide();
                $('#third-screen').show();
                startThird();
                screenid++;
            }
            break;
        case 3:
            $('.illustration').each(function () {
                if (!$(this).hasClass('chosen') && $(this).data('illustration-id') == 1) {
                    all = false;
                }

                if($(this).hasClass('chosen') && $(this).data('illustration-id') == 0){
                    allok = false;
                }
            });

            if(all && allok){
                $('.end-popup').show();
                screenid++;
            }

            break;
    }

}

$(function () {
    $('.refresh.outer').on('click', function () {
        $('div.end-popup').hide();
        location.reload();
    });


    $(class_draggable).draggable({
        start: function (event, ui) {
            $(this).removeClass('locked');
            ui.helper.data('dropped', false);
            if ($(this).parent().hasClass(class_droppable.replace('.', ''))) {
                $(this).parent().removeClass('haselement');
            }
            $(this).css('z-index', '10');
        },
        revert: function (dropped_ele) {
            var $dropped_ele = $(dropped_ele);
            var dropped = $dropped_ele.hasClass('image-caption') || $dropped_ele.hasClass('draggables');
            $(this).addClass('locked');
            if ($(this).parent().hasClass(class_droppable.replace('.', ''))) {
                $(this).parent().addClass('haselement');
            }
            if (!dropped) {
                $(this).data("ui-draggable").originalPosition = {top: 0, left: 0};
                $(this).appendTo($(this).data('originalParent'));
                $(this).css('z-index', '2');
            }

            if(screenid == 2 && $dropped_ele.hasClass('image-caption')){
                $(this).css('left', '-3px').css('top', '-3px');
            }

            return !dropped;
        }
    });

    $(class_droppable).droppable({
        accept: class_draggable,
        activeClass: "ui-state-hover",
        hoverClass: "ui-state-active",
        drop: function (event, ui) {

            if($(this).hasClass('haselement')){
                return false;
            }

            ui.draggable.data('dropped', true);


            var prev_element = $(this).children(class_draggable);

            if (prev_element.length > 0 &&
                prev_element.first().data('element-id') === ui.draggable.data('element-id')) {
                return true;
            }

            $(ui.draggable).detach().css({
                top: 0,
                left: 0
            }).appendTo(this);
            $(this).addClass('haselement');


            prev_element.each(function () {
                $(this).appendTo('#draggables').removeClass('notapproved');
            });

            if ($(this).data('element-id') === ui.draggable.data('element-id')) {
                ui.draggable.draggable({disabled: true});
                $(this).droppable('disable');
                ui.draggable.removeClass('notapproved').addClass('approved');
            } else {
                ui.draggable.addClass('notapproved');
            }
            testOrder();
        }
    });

    $('.draggables').droppable({
        accept: class_draggable,
        activeClass: "ui-state-hover",
        hoverClass: "ui-state-active",
        drop: function (event, ui) {
            ui.draggable.data('dropped', true);
            ui.draggable.parent().removeClass('haselement');
            $(ui.draggable).detach().css({
                top: 0,
                left: 0
            }).appendTo(this);

            ui.draggable.removeClass('notapproved');
        }
    });


    $.fn.randomize = function (a) {
        (a ? this.find(a) : this)
            .parent().each(function () {
                $(this)
                    .children(a).sort(function () {
                        return Math.random() - 0.5
                    })
                    .detach().appendTo(this)
            });
        return this
    };
    $(class_draggable).randomize();


    $('#start-game').on('click', function () {

        var first_count = 3;
        var first_counter = setInterval(countdown, 1000);
        $('.start-info').html('<span id="counter">3</span>');

        function countdown() {
            first_count--;
            $('span#counter').html(first_count);
            if (first_count <= 0) {
                $('.start-popup').hide();
                clearInterval(first_counter);
            }
            
        }

    });
    
});

