;
(function($, window, document, undefined)
{
    $.fn.randomize = function(selector)
    {
        (selector ? this.find(selector) : this).parent().each(function()
        {
            $(this).children(selector).sort(function()
            {
                return Math.random() - Math.random();
            }).detach().appendTo(this);
        });

        return this;
    };

    var View = function(game, opts)
    {
        this.game = game;
        this.opts = opts;
        this.$element = $(opts.element);

        var _this = this,
            $element = $("<div><div class='image-wrapper'><img src alt></div><p class='input'><input type='text' /></p></div>").addClass("element");

        this.render = function()
        {
            $.each(this.opts.elements, function(i, obj)
            {
                var $el = $element.clone()
                    .find("img").attr("src", obj.img).end()
                    .find("input").attr("data-correct-value", obj.correctValue).end()
                    .appendTo(_this.$element.find(".elements"));
            });

            this.$element.find(".element").randomize();

            this.$element.screenKeyboard({
                keys: {
                    type: "alpha"
                },
                inputs: {
                    selectors: ["input"],
                    next: function($input)
                    {
                        if($input.val() && $input.val().toLowerCase() === $input.attr("data-correct-value").toLowerCase())
                        {
                            return $input.closest(".element").next(".element").find("input");
                        }
                    }
                }
            });
            this.$element.on("screenKeyboard.on", function()
            {
                _this.$element.find(".element:not(.result-correct):first input").trigger("click");
                $('#game .elements').addClass("screen-keyboard-on");
            }).on("screenKeyboard.off", function () {
                $('#game .elements').removeClass("screen-keyboard-on");
            });

            this.$element.find(".popup.popup-instruction, .popup-overlay").show();
        };

        this.delegateEvents = function()
        {
            this.$element.find(".element, .element *").on("click", function()
            {
                var $this = $(this);
                if(!$this.is(".element"))
                {
                    $this = $this.closest(".element");
                }
                $this.addClass("is-active").find("input").trigger("focus");
            });

            this.$element.find(".element input").on("focus", function()
            {
                _this.$element.find(".element.is-active").removeClass("is-active");
                $(this).closest(".element").addClass("is-active");
            }).on("keyup", function()
            {
                var $this = $(this).removeClass("result-correct").removeClass("result-incorrect");
                if($this.val() && $this.val().toLowerCase() === $this.attr("data-correct-value").toLowerCase())
                {
                    $this.closest(".element").addClass("result-correct");
                    _this.check();
                }
            });

            this.$element.find(".element input").on("blur", function()
            {
                var $this = $(this);
                $this.closest(".element").removeClass("result-correct").removeClass("result-incorrect");
                if ($this.val())
                {
                    if($this.val().toLowerCase() === $this.attr("data-correct-value").toLowerCase())
                    {
                        $this.closest(".element").addClass("result-correct");
                    }
                    else
                    {
                        $this.closest(".element").addClass("result-incorrect");
                    }
                    _this.check();
                }
            });

            this.$element.find(".popup-instruction .start").on("click", function()
            {
                _this.$element.find(".popup.popup-instruction, .popup-overlay").hide();
                return false;
            });

            this.$element.find("#refresh").on("click", function()
            {
                window.location.reload();
                return false;
            });
        };

        this.check = function()
        {
            if(this.$element.find(".element.result-correct").size() === this.opts.elements.length)
            {
                this.$element.data("plugin_screenKeyboard").hideKeyboard();
                this.$element.find(".popup.popup-result, .popup-overlay").show();
            }
        };
    };

    var Game = function(opts)
    {
        this.opts = opts;
        this.view = new View(this, opts);

        this.start = function()
        {
            this.view.render();
            this.view.delegateEvents();
        };
    };

    window.Game = Game;

})(jQuery, window, document);