;
(function($, window, document, undefined)
{
    $.fn.randomize = function(selector)
    {
        (selector ? this.find(selector) : this).parent().each(function()
        {
            $(this).children(selector).sort(function()
            {
                return Math.random() - Math.random();
            }).detach().appendTo(this);
        });

        return this;
    };

    var View = function(game, opts)
    {
        var _this = this;

        this.game = game;
        this.opts = opts;
        this.$element = $(opts.element);
        this.currentScreen = -1;

        this.render = function()
        {
            this.showNextScreen();
            this.$element.find(".popup-instruction, .popup-overlay").show();
        };

        this.showNextScreen = function()
        {
            this.currentScreen += 1;
            if(this.currentScreen === this.opts.pairs.length)
            {
                return this.$element.find(".popup.popup-result, .popup-overlay").show();
            }

            var $screen = $(this.$element.find("#template-screen").html()),
                pair = this.opts.pairs[this.currentScreen];

            this.$element.find(".wrapper .pair-container").fadeOut("fast", function()
            {
                $(this).remove();

                $screen.find(".left img").attr("src", pair.img1).attr("data-is-correct", pair.correct === "img1" ? 1 : 0).end()
                    .find(".right img").attr("src", pair.img2).attr("data-is-correct", pair.correct === "img2" ? 1 : 0).end()
                    .appendTo(_this.$element.find(".wrapper"))
                    .fadeIn("fast");

                if(Math.random() > 0.5)
                {
                    var $img1 = $screen.find(".left img"),
                        $parent1 = $img1.parent(),
                        $img2 = $screen.find(".right img"),
                        $parent2 = $img2.parent();

                    $img1.appendTo($parent2);
                    $img2.appendTo($parent1);
                }

                _this.$element.find(".sentence").text(pair.sentence);

                _this.resize();
            });
        };

        this.delegateEvents = function()
        {
            this.$element.on("click", ".pair-container img", function()
            {
                if($(this).attr("data-is-correct") === "1")
                {
                    _this.showNextScreen();
                }
                else
                {
                    $(this).addClass("result-incorrect");
                }
            });

            this.$element.find(".start").on("click", function()
            {
                _this.$element.find(".popup-instruction, .popup-overlay").hide();
                return false;
            });

            this.$element.find("#refresh").on("click", function()
            {
                window.location.reload();
                return false;
            });

            $(window).on("resize", function()
            {
                _this.resize();
            }).trigger("resize");
        };

        this.resize = function()
        {
            this.$element.find(".wrapper .pair-container").css("line-height", this.$element.find(".wrapper .pair-container .left-container").height() + "px");
            this.$element.find(".has-sentence .sentence").css("line-height", this.$element.find(".has-sentence").height() + "px");
        };
    };

    var Game = function(opts)
    {
        this.opts = opts;
        this.view = new View(this, opts);

        this.start = function()
        {
            this.view.render();
            this.view.delegateEvents();
        };
    };

    window.Game = Game;

})(jQuery, window, document);