;
(function($, window, document, undefined)
{
    $.fn.randomize = function(selector)
    {
        (selector ? this.find(selector) : this).parent().each(function()
        {
            $(this).children(selector).sort(function()
            {
                return Math.random() - Math.random();
            }).detach().appendTo(this);
        });

        return this;
    };

    var View = function(game, opts)
    {
        var _this = this;

        this.game = game;
        this.opts = opts;
        this.$element = $(opts.element);
        this.currentEquation = -1;

        this.render = function()
        {
            var $equation = $(this.$element.find("#template-equation").html());

            $.each(this.opts.equations, function(i, equation)
            {
                var $eq = $equation.clone()
                    .find(".equation-text").text(equation.txt).end()
                    .find("input").attr("data-correct-value", equation.correctValue).end()
                    .appendTo(_this.$element.find(".equations"));
            });

            this.$element.screenKeyboard({
                keys: {
                    type: "custom",
                    keys: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, "+", "-", "="]
                },
                inputs: {
                    selectors: ["input"]
                }
            });

            this.$element.on("screenKeyboard.on", function()
            {
                _this.$element.find(".equation.is-visible input").trigger("click");
            });

            this.showNextEquation();
            this.$element.find(".popup.popup-instruction, .popup-overlay").show();
        };

        this.showNextEquation = function()
        {
            this.currentEquation += 1;
            if(this.currentEquation === this.opts.equations.length)
            {
                this.$element.data("plugin_screenKeyboard").hideKeyboard();
                this.$element.find(".popup.popup-result, .popup-overlay").show();
            }

            this.$element.find(".equation.is-visible").removeClass("is-visible");
            this.$element.find(".equation").eq(this.currentEquation).addClass("is-visible")
                .find("input").on("keyup", function()
                {
                    var $this = $(this).removeClass("result-correct").removeClass("result-incorrect"),
                        value = $this.val() || "";

                    value = value.replace(/\s+/g, "");
                    if(value === $this.attr("data-correct-value").replace(/\s+/g, ""))
                    {
                        $this.addClass("result-correct");
                        _this.$element.find(".equation.is-visible .next").show();
                    }
                }).on("blur", function()
                {
                    var $this = $(this).removeClass("result-correct").removeClass("result-incorrect"),
                        value = $this.val() || "";

                    if(value)
                    {
                        if(value.replace(/\s+/g, "") === $this.attr("data-correct-value").replace(/\s+/g, ""))
                        {
                            $this.addClass("result-correct");
                            _this.$element.find(".equation.is-visible .next").show();
                        }
                        else
                        {
                            $this.addClass("result-incorrect");
                            _this.$element.find(".equation.is-visible .next").hide();
                        }
                    }
                }).end().find(".next").on("click", function()
                {
                    _this.showNextEquation();
                    return false;
                });

            if(this.$element.data("plugin_screenKeyboard").isKeyboardOn())
            {
                this.$element.find(".equation.is-visible input").trigger("click");
            }
        };

        this.delegateEvents = function()
        {
            this.$element.find(".popup .start").on("click", function()
            {
                _this.$element.find(".popup.popup-instruction, .popup-overlay").hide();
                return false;
            });

            this.$element.find("#refresh").on("click", function()
            {
                window.location.reload();
                return false;
            });

            $(window).on("resize", function()
            {
                _this.resize();
            }).trigger("resize");
        };

        this.resize = function()
        {

        };
    };

    var Game = function(opts)
    {
        this.opts = opts;
        this.view = new View(this, opts);

        this.start = function()
        {
            this.view.render();
            this.view.delegateEvents();
        };
    };

    window.Game = Game;

})(jQuery, window, document);