$(function () {
    var Game = {
        stage: 1,
        animationDuration: 10,
        delay: 3,
        clickedGood: 0,
        itemsOnStage: 0,
        correctItemsOnStage: 0,
        currentItem: 0,
        currentStageItem: 0,
        init: function () {
            $('.flying-item').randomize();
            $('.flying-item').on('click', function () {
                Game.choosen($(this));
            }).css('visibility', 'visible').hide();
            $('#stage2, #stage3').css('visibility', 'visible').hide();
            $('body').delegate('a#next-stage', 'click', function () {
                $('#stage-popup').hide();
                $('#stage' + (Game.stage - 1)).hide();
                $('#stage' + Game.stage).show();
                Game.startStage();
            });
        },
        animateItem: function ($item) {
            var left = Math.floor((Math.random() * ($('#stage' + Game.stage).width() - 250)));
            $item.css('left', left + 'px');
            if ($item.data('element-id') == 1) {
                Game.correctItemsOnStage++;
            }
            Game.currentStageItem++;
            $item.show();
            $item.animate({
                top: $(document).height() + "px"
            }, Game.animationDuration * 1000, "linear", function () {
                var item_stage_id = $item.data('stage-id');
                $item.remove();
                if ( item_stage_id == Game.itemsOnStage && Game.stage <= 3) {
                    Game.nextStage();
                }
            });

        },
        startStage: function () {
            var items = $('#stage' + Game.stage).find('div.flying-item');
            Game.itemsOnStage = items.length;

            items.each(function (i, element) {
                $(element).data('stage-id', (i + 1));
                setTimeout(function () {
                    Game.currentItem++;
                    Game.animateItem($(element));
                }, Game.delay * 1000 * i);
            });


        },
        choosen: function ($element) {
            if ($element.data('element-id') == 1) {
                $element.addClass('good');
                Game.clickedGood++;
            } else {
                $element.addClass('wrong');
                Game.clickedGood--;
            }
        },
        nextStage: function () {
            $('span#score').html(Game.clickedGood + '/' + Game.correctItemsOnStage);
            if (Game.clickedGood == Game.correctItemsOnStage) {
                $('#success_info').show();
                $('#wrong_info').hide();
                $('#stage-popup').removeClass('error');
            } else {
                $('#success_info').hide();
                $('#wrong_info').show();
                $('#stage-popup').addClass('error');
            }
            Game.stage++;
            Game.clickedGood = 0;
            Game.correctItemsOnStage = 0;
            Game.itemsOnStage = 0;
            Game.currentStageItem = 0;
            $('#stage-popup').show();
            if (Game.stage > 3) {
                $('#next-stage').hide();
                $('.refresh.outer').show();
            }
        }

    };

    $('#start-game').on('click', function () {
        var first_count = 3;
        var first_counter = setInterval(countdown, 1000);
        $('.start-info').html('<span id="counter">3</span>');

        $('.refresh').on('click', function () {
            location.reload();
        });

        $.fn.randomize = function (a) {
            (a ? this.find(a) : this)
                .parent().each(function () {
                    $(this)
                        .children(a).sort(function () {
                            return Math.random() - 0.5
                        })
                        .detach().appendTo(this)
                });
            return this
        };


        function countdown() {
            first_count--;
            $('span#counter').html(first_count);
            if (first_count <= 0) {
                $('.start-popup').hide();
                Game.init();
                Game.startStage();
                clearInterval(first_counter);
            }
        }



    });

});