;
(function($, window, document, undefined)
{
    $.fn.randomize = function(selector)
    {
        (selector ? this.find(selector) : this).parent().each(function()
        {
            $(this).children(selector).sort(function()
            {
                return Math.random() - Math.random();
            }).detach().appendTo(this);
        });

        return this;
    };

    var View = function(game, opts)
    {
        var _this = this;

        this.game = game;
        this.opts = opts;
        this.$element = $(opts.element);

        this.render = function()
        {
            var $element = $("<div><div class='photo-container'><img src alt/></div><div class='text-container'></div></div>").addClass("element"),
                $letterPlaceholder = $("<div/>").addClass("letter-placeholder");

            $.each(this.opts.elements, function(i, el)
            {
                var $el = $element.clone()
                    .find("img").attr("src", el.img).end()
                    .find(".text-container").attr("data-correct-value", el.correctValue).end()
                    .attr("data-element-index", i)
                    .appendTo(_this.$element.find(".elements"));

                var $lettersContainer = $("<div></div>").addClass("letters").attr("data-element-index", i);

                $.each(el.initialValue.split(""), function(j, letter)
                {
                    var $letter = $("<div/>").addClass("letter")
                        .appendTo($lettersContainer)
                        .attr("data-letter", letter)
                        .attr("data-element-index", i)
                        .text(letter);
                });
                $lettersContainer.appendTo(_this.$element.find(".letters-container"));

                $.each(el.correctValue.split(""), function(j, letter)
                {
                    var $lP = $letterPlaceholder.clone()
                        .appendTo($el.find(".text-container"))
                        .attr("data-correct-value", letter)
                        .attr("data-element-index", i);
                });
            });

            this.$element.find(".element").randomize();
            this.$element.find(".letters").randomize();

            this.$element.find(".popup.popup-instruction, .popup-overlay").show();
        };

        this.delegateEvents = function()
        {
            this.$element.find(".popup.popup-instruction .start").on("click", function()
            {
                _this.$element.find(".popup.popup-instruction, .popup-overlay").hide();
                return false;
            });

            this.$element.find(".letter-placeholder").droppable({
                accept: function($draggable)
                {
                    return $draggable.is(".letter") && $draggable.attr("data-element-index") === $(this).attr("data-element-index");
                },
                drop: function(e, ui)
                {
                    if($(this).find(".letter").size())
                    {
                        $(this).find(".letter").appendTo(_this.$element.find(".letters[data-element-index='" + ($(this).find(".letter").attr("data-element-index")) + "']").show())
                    }
                    var $draggable = $(ui.draggable).detach().appendTo($(this));
                    _this.check();
                    $(this).removeClass("active-drop");
                },
                over: function()
                {
                    $(this).addClass("active-drop");
                },
                out: function()
                {
                    $(this).removeClass("active-drop");
                }
            });

            this.$element.find(".letters .letter").draggable({
                revert: "invalid",
                helper: "clone",
                appendTo: _this.$element.find(".tmp-container")
            });

            $(window).on("resize", function()
            {
                _this.resize();
            }).trigger("resize");

            this.$element.find("#refresh").on("click", function()
            {
                window.location.reload();
                return false;
            });
        };

        this.check = function()
        {
            var allFilled = true;
            this.$element.find(".text-container").each(function()
            {
                $(this).find(".letter-placeholder").each(function()
                {
                    $(this).removeClass("result-correct").removeClass("result-incorrect");

                    if($(this).find(".letter").size())
                    {
                        var letterValue = $(this).find(".letter").attr("data-letter"),
                            correctValue = $(this).attr("data-correct-value");

                        if(letterValue === correctValue)
                        {
                            $(this).addClass("result-correct");
                        }
                        else
                        {
                            $(this).addClass("result-incorrect");
                        }
                    }
                    else
                    {
                        allFilled = false;
                    }
                });

                if($(this).find(".letter-placeholder .result-incorrect").size() === 0 && $(this).find(".letter-placeholder .letter").size() === $(this).find(".letter-placeholder").size())
                {
                    var elementIndex = $(this).closest(".element").attr("data-element-index");
                    _this.$element.find(".letters[data-element-index='"+elementIndex+"']").hide();
                }
            });

            if(allFilled && !this.$element.find(".result-incorrect").size())
            {
                this.$element.find(".popup.popup-result, .popup-overlay").show();
            }
        };

        this.resize = function()
        {

        };
    };

    var Game = function(opts)
    {
        this.opts = opts;
        this.view = new View(this, opts);

        this.start = function()
        {
            this.view.render();
            this.view.delegateEvents();
        };
    };

    window.Game = Game;

})(jQuery, window, document);