;
(function($, window, document, undefined)
{
    $.fn.randomize = function(selector)
    {
        (selector ? this.find(selector) : this).parent().each(function()
        {
            $(this).children(selector).sort(function()
            {
                return Math.random() - Math.random();
            }).detach().appendTo(this);
        });

        return this;
    };

    var View = function(game, opts)
    {
        var _this = this;

        this.game = game;
        this.opts = opts;
        this.$element = $(opts.element);

        this.render = function()
        {
            var $element = $("<div><div class='photo-container'><img src alt /></div><div class='input-container'><input type='text' /></div></div>").addClass("element"),
                $word = $("<div/>").addClass("word");
            $.each(this.opts.elements, function(i, element)
            {
                var $el = $element.clone()
                    .find("img").attr("src", element.img).end()
                    .find("input").attr("data-correct-value", element.value).end()
                    .appendTo(_this.$element.find(".elements"));

                var $w = $word.clone()
                    .appendTo(_this.$element.find(".words"))
                    .text(element.value);
            });

            this.$element.find(".popup .start").on("click", function()
            {
                _this.$element.find(".popup.popup-instruction, .popup-overlay").hide();
                return false;
            });

            this.$element.screenKeyboard({
                keys: {
                    type: "alpha"
                },
                inputs: {
                    selectors: ["input"],
                    next: function($input)
                    {
                        if($input.val() && $input.val().toLowerCase() === $input.attr("data-correct-value").toLowerCase())
                        {
                            return $input.closest(".element").next(".element").find("input");
                        }
                    }
                }
            });
            this.$element.on("screenKeyboard.on", function()
            {
                _this.$element.find(".element:not(.result-correct):first input").trigger("click");
                $('#game').addClass("screen-keyboard-on");
            }).on("screenKeyboard.off", function () {
                $('#game').removeClass("screen-keyboard-on");
            });

            this.$element.find(".popup.popup-instruction, .popup-overlay").show();

            this.$element.find(".element").randomize();
        };

        this.delegateEvents = function()
        {
            this.$element.find("input").on("keyup", function()
            {
                var $this = $(this);
                $this.closest(".element").removeClass("result-correct").removeClass("result-incorrect");
                if($this.val())
                {
                    if($this.val().toLowerCase() === $this.attr("data-correct-value").toLowerCase())
                    {
                        $this.closest(".element").addClass("result-correct");
                    }
                    _this.check();
                }
            }).on("blur", function()
            {
                var $this = $(this);
                $this.closest(".element").removeClass("result-correct").removeClass("result-incorrect");
                if($this.val())
                {
                    if($this.val().toLowerCase() === $this.attr("data-correct-value").toLowerCase())
                    {
                        $this.closest(".element").addClass("result-correct");
                    }
                    else
                    {
                        $this.closest(".element").addClass("result-incorrect");
                    }
                    _this.check();
                }
            });

            this.$element.find("#refresh").on("click", function()
            {
                window.location.reload();
                return false;
            });

            $(window).on("resize", function()
            {
                _this.resize();
            }).trigger("resize");
        };

        this.check = function()
        {
            if(this.$element.find(".result-incorrect").size() === 0 && this.$element.find(".result-correct").size() === this.opts.elements.length)
            {
                this.$element.data("plugin_screenKeyboard").hideKeyboard();
                this.$element.find(".popup.popup-result, .popup-overlay").show();
            }
        };

        this.resize = function()
        {
            this.$element.find(".words").css("line-height", this.$element.find(".words").height() + "px");
        };
    };

    var Game = function(opts)
    {
        this.opts = opts;
        this.view = new View(this, opts);

        this.start = function()
        {
            this.view.render();
            this.view.delegateEvents();
        };
    };

    window.Game = Game;

})(jQuery, window, document);