$(function () {
    var cavnas_pos_x = 0;
    var cavnas_pos_y = 0;

    $.fn.drawTouch = function(ctx) {
        var start = function(e) {
            e = e.originalEvent;
            ctx.beginPath();
            var x = e.changedTouches[0].pageX - cavnas_pos_x;
            var y = e.changedTouches[0].pageY - cavnas_pos_y;
            ctx.moveTo(x,y);
        };
        var move = function(e) {
            e.preventDefault();
            e = e.originalEvent;
            var x = e.changedTouches[0].pageX - cavnas_pos_x;
            var y = e.changedTouches[0].pageY - cavnas_pos_y;
            ctx.lineTo(x,y);
            ctx.stroke();
        };
        $(this).on("touchstart", start);
        $(this).on("touchmove", move);
    };

// prototype to	start drawing on pointer(microsoft ie) using canvas moveTo and lineTo
    $.fn.drawPointer = function(ctx) {
        var start = function(e) {
            e = e.originalEvent;
            ctx.beginPath();
            var x = e.pageX - cavnas_pos_x;
            var y = e.pageY - cavnas_pos_y;
            ctx.moveTo(x,y);
        };
        var move = function(e) {
            e.preventDefault();
            e = e.originalEvent;
            var x = e.pageX - cavnas_pos_x;
            var y = e.pageY - cavnas_pos_y;
            ctx.lineTo(x,y);
            ctx.stroke();
        };
        $(this).on("MSPointerDown", start);
        $(this).on("MSPointerMove", move);
    };

// prototype to	start drawing on mouse using canvas moveTo and lineTo
    $.fn.drawMouse = function(ctx) {
        var clicked = 0;
        var start = function(e) {
            clicked = 1;
            ctx.beginPath();
            var x = e.pageX - cavnas_pos_x;
            var y = e.pageY - cavnas_pos_y;
            ctx.moveTo(x,y);
        };
        var move = function(e) {
            if(clicked){
                var x = e.pageX - cavnas_pos_x;
                var y = e.pageY - cavnas_pos_y;
                ctx.lineTo(x,y);
                ctx.stroke();
            }
        };
        var stop = function(e) {
            clicked = 0;
        };
        $(this).on("mousedown", start);
        $(this).on("mousemove", move);
        $(window).on("mouseup", stop);
    };

    $(document).ready(function () {
        var BGame = {
            getPixelIndex: function getPixelIndex(x, y) {
                return y * BGame.imageData.width * 4 + x * 4;
            },
            init: function () {
                BGame.$canvas = $("#bordering");

                BGame.$image = $("#bordering-container").find("img");
                BGame.canvas = BGame.$canvas.get(0);
                BGame.ctx = this.canvas.getContext("2d");
                BGame.imageOriginalWidth = BGame.$image.get(0).naturalWidth;
                BGame.imageOriginalHeight = BGame.$image.get(0).naturalHeight;
                BGame.pixelsCount =  BGame.imageOriginalWidth *  BGame.imageOriginalHeight;
                BGame.color = "#000";

                BGame.$canvas.attr('width', BGame.imageOriginalWidth).attr('height', BGame.imageOriginalHeight);
                BGame.ctx.drawImage(BGame.$image.get(0), 0, 0, BGame.imageOriginalWidth, BGame.imageOriginalHeight);
                BGame.imageData = BGame.ctx.getImageData(0, 0, BGame.imageOriginalWidth, BGame.imageOriginalHeight);

                BGame.ctx.strokeStyle = BGame.color;
                BGame.ctx.lineWidth = 5;

                cavnas_pos_x = BGame.$canvas.offset().left;
                cavnas_pos_y = BGame.$canvas.offset().top;

                BGame.$canvas.drawTouch(BGame.ctx);
                BGame.$canvas.drawPointer(BGame.ctx);
                BGame.$canvas.drawMouse(BGame.ctx);

            },
            findPos: function (obj) {
                var curleft = 0, curtop = 0;
                if (obj.offsetParent) {
                    do {
                        curleft += obj.offsetLeft;
                        curtop += obj.offsetTop;
                    } while (obj = obj.offsetParent);
                    return {x: curleft, y: curtop};
                }
                return undefined;
            },
            isColorBlack: function (x, y) {
                var index = BGame.getPixelIndex(x, y),
                    r = BGame.imageData.data[index + 0],
                    g = BGame.imageData.data[index + 1],
                    b = BGame.imageData.data[index + 2];
                return r < 10 && g < 10 && b < 10;
            },
            isColorBlue: function (x, y) {
                var index = BGame.getPixelIndex(x, y),
                    r = BGame.imageData.data[index + 0],
                    g = BGame.imageData.data[index + 1],
                    b = BGame.imageData.data[index + 2];
                return r > 5 && r < 220 && g > 80 && g < 255 && b > 90 && b < 255;
            },
            setPixel: function (x, y, r, g, b, a) {
                BGame.ctx.fillStyle = "rgba(" + r + "," + g + "," + b + "," + (a / 255) + ")";
                BGame.ctx.fillRect(x, y, 1, 1);
            },
            onPaint: function () {
                if (BGame.isColorBlue(BGame.mouseX, BGame.mouseY)) {
                    for (var i = 0; i <= 20; i++) {
                        for (var j = 0; j <= 20; j++) {
                            if (BGame.isColorBlue(BGame.mouseX + i, BGame.mouseY + j)) {
                                BGame.setPixel(BGame.mouseX + i, BGame.mouseY + j, 0, 0, 0, 255);
                            }
                        }
                    }
                }
            },
            checkIfEnd: function(){
                var uncolored = 0;
                for(var i = 0; i < BGame.imageOriginalWidth; i++){
                    for(var j = 0; j < BGame.imageOriginalHeight; j++){
                        if(BGame.isColorBlue(i, j)){
                            uncolored++;
                        }
                    }
                }
                if( (uncolored / BGame.bluePixels) < 0.99){
                    $('#stage-popup').show();
                }
            }
        };


        $('#start-game').on('click', function () {

            BGame.init();
            var first_count = 3;
            var first_counter = setInterval(countdown, 100);
            $('.start-info').html('<span id="counter">3</span>');

            $('#refresh').on('click', function () {
                location.reload();
            });



            function countdown() {
                first_count--;
                $('span#counter').html(first_count);
                if (first_count <= 0) {
                    $('.start-popup').hide();
                    clearInterval(first_counter);
                }
            }

            return false;



        });


    });
});
