$( document ).ready(function() {

// DATA
  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/wiem-co-jem/quiz/1/1.wav');


  var questionNumber = 1;
  var noOfQuestions = 10;

  var questionTypes = [
    'image',
    'image',
    'image',
    'image',
    'image',
    'image',
    'text',
    'text',
    'text',
    'text',
  ]

  var questions = {
    1: "Można ze mnie zrobić mizerię, albo zamknąć na długo w słoiku.",
    2: "Mam wiele sukienek, płaczesz gdy je zdejmuję.",
    3: "Zaznacz warzywa, które mają jadalne korzenie.",
    4: "Zaznacz produkty, które zawierają witaminę A.",
    5: "Zaznacz produkty, które zawierają witaminy z grupy B.",
    6: "Zaznacz produkty, które zawierają witaminę C.",
    7: "Jeśli czujesz się słaby i nie masz na nic ochoty to znak, że brakuje Ci:",
    8: "Jeśli nie mamy apetytu i wolniej rośniemy to znak że brakuje nam:",
    9: "Jeśli pogorszył ci się wzrok i często się przeziębiasz, to znak, że brakuje Ci:",
    10: "Który posiłek jest dla nas najważniejszy?"
  }
  var answers = {
    1: {
      0: ['brukselka', 'sałata', 'brokuły', 'ogórek', 'groszek zielony', 'kapusta'],
      1: ['brukselka.jpg', 'salata.jpg', 'brokul.jpg', 'ogorek.jpg', 'groszek-zielony.jpg', 'kapusta.jpg'],
      2: ['brukselka.wav', 'salata.wav', 'brokuly.wav', 'ogorek.wav', 'groszekzielony.wav', 'kapusta.wav']
    },
    2: {
      0: ['papryka', 'por', 'cebula', 'czosnek', 'kalafior'],
      1: ['papryka.jpg', 'por.jpg', 'cebula.jpg', 'czosnek.jpg', 'kalafior.jpg'],
      2: ['papryka.wav', 'por.wav', 'cebula.wav', 'czosnek.wav', 'kalafior.wav']
    },
    3: {
      0: ['burak', 'fasola', 'pietruszka', 'kalarepa', 'marchew', 'kapusta'],
      1: ['buraki.jpg', 'fasola.jpg', 'pietruszka.jpg', 'kalarepa.jpg', 'marchew.jpg', 'kapusta.jpg'],
      2: ['burak.wav', 'fasola.wav', 'pietruszka.wav', 'kalarepa.wav', 'marchew.wav', 'kapusta.wav']
    },
    4: {
      0: ['ryba', 'czerwona papryka', 'pietruszka', 'jajko', 'marchew', 'kapusta'],
      1: ['ryba.jpg', 'papryka.jpg', 'pietruszka.jpg', 'jaja.jpg', 'marchew.jpg', 'kapusta.jpg'],
      2: ['ryba.wav', 'czerwonapapryka.wav', 'pietruszka.wav', 'jajko.wav', 'marchew.wav', 'kapusta.wav']
    },
    5: {
      0: ['zboże i płatki', 'nabiał', 'ryba', 'jabłko', 'pietruszka', 'dynia'],
      1: ['zboze.jpg', 'nabial.jpg', 'ryba.jpg', 'jablko.jpg', 'pietruszka.jpg', 'dynia.jpg'],
      2: ['zboze.wav', 'nabial.wav', 'ryba.wav', 'jablko.wav', 'pietruszka.wav', 'dynia.wav']
    },
    6: {
      0: ['czarna porzeczka', 'truskawka', 'nabiał', 'ryba', 'pomarańcza', 'dynia'],
      1: ['czarna-porzeczka.jpg', 'truskawka.jpg', 'nabial.jpg', 'ryba.jpg', 'pomarancza.jpg', 'dynia.jpg'],
      2: ['czarna-porzeczka.wav', 'truskawka.wav', 'nabial.wav', 'ryba.wav', 'pomarancza.wav', 'dynia.wav']
    },
    7: {
      0: ['cynku', 'żelaza', 'potasu', 'magnezu'],
      1: ['cynku.wav', 'zelaza.wav', 'potasu.wav', 'magnezu.wav']
    },
    8: {
      0: ['cynku', 'żelaza', 'potasu', 'magnezu'],
      1: ['cynku.wav', 'zelaza.wav', 'potasu.wav', 'magnezu.wav']
    },
    9: {
      0: ['witaminy C', 'potasu', 'witaminy A', 'magnezu'],
      1: ['witaminy-c.wav', 'potasu.wav', 'witaminy-a.wav', 'magnezu.wav']
    },
    10: {
      0: ['śniadanie', 'II śniadanie', 'obiad', 'podwieczorek', 'kolacja'],
      1: ['sniadanie.wav', '2-sniadanie.wav', 'obiad.wav', 'podwieczorek.wav', 'kolacja.wav']
    }
  }

  var answerAudios = []

  var correctAnswerIndexes = {
    1: [4],
    2: [3],
    3: [1,3,5],
    4: [1,2,4,5,6],
    5: [1,2,3],
    6: [1,2,5],
    7: [3],
    8: [1],
    9: [1,3],
    10: [1]

  }

  var questionsFinished = []

  var answered = {
    1: [],
    2: [],
    3: [],
    4: [],
    5: [],
    6: [],
    7: [],
    8: [],
    9: [],
    10: []
  }

// MAIN LOGIC

  $( '.question-number' ).html( questionNumber );
  $( '.question-sum' ).html( noOfQuestions );
  $( '.question-text' ).html( questions[questionNumber] );

  $( 'body' ).on('click', '.next-question', function(event){
    event.preventDefault()
    if(questionNumber < noOfQuestions){
      questionNumber++;
      setPageDataForQuestion()
    }
    $('#modalCorrectAnswer').modal('hide')
  });

  $( '.prev-question' ).on('click', function(event){
    event.preventDefault()
    if(questionNumber > 1){
      questionNumber--;
      setPageDataForQuestion()
    }
  });

  $('.answer-audio').on('click', function(event){
    event.preventDefault();
    event.stopPropagation();
    var answerNo = parseInt($(this).attr('data-answer-no'));
    answerAudios[answerNo-1].play();
  })

  $( '.answer-button' ).on('click', function(event) {
    event.preventDefault()
    $('.wrong-answer').removeClass('wrong-answer')
    $('.last-answer').removeClass('last-answer')
    $(this).addClass('last-answer')
    var answerNo = parseInt($(this).attr('data-answer-no'))
    answered[questionNumber].push(answerNo)
    if(correctAnswerIndexes[questionNumber].indexOf(answerNo) !== -1) {
      $(this).addClass('correct-answer')
      badAnswerAudio.load()
      goodAnswerAudio.play()

      if(_.uniq(_.intersection(correctAnswerIndexes[questionNumber], answered[questionNumber])).length == correctAnswerIndexes[questionNumber].length) {

        //all correct answers selected
        if(questionsFinished.indexOf(questionNumber) == -1){
          questionsFinished.push(questionNumber)
        }
        if(!(questionsFinished.length === noOfQuestions)){
          if(questionNumber < noOfQuestions){
            showCorrectAnswerModal()
          }
        } else {
          fillEndModalAndShowIt()
        }

      }
    } else {
      goodAnswerAudio.load()
      badAnswerAudio.play()
      $(this).addClass('wrong-answer')
    }
  });

  $('.read-question').on('click', function(event) {
    event.preventDefault()
    questionAudio.play()
  })

  $('.check-answer').on('click', function(event) {
    event.preventDefault()
    $('.is-correct').toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500)
  })

  var setPageDataForQuestion = function() {
    $( '.question-number' ).html(questionNumber );
    $( '.question-text' ).html(questions[questionNumber] );

    questionAudio = new Audio('../files/audio/wiem-co-jem/quiz/' + questionNumber + '/' + questionNumber + '.wav');

    if(questionTypes[questionNumber-1] === 'image'){
      setAnswerButtonsForImage()
    } else if(questionTypes[questionNumber-1] === 'text') {
      setAnswerButtonsForText()
    }
    setAnswerAudiosButtons()
    if(questionNumber == noOfQuestions) {
      $( '.next-question' ).addClass('disabled')
    } else {
      $( '.next-question' ).removeClass('disabled');
    };
    if(questionNumber == 1) {
      $( '.prev-question' ).addClass('disabled');
    } else {
      $( '.prev-question' ).removeClass('disabled');
    }
    $('.wrong-answer').removeClass('wrong-answer')
    $('.last-answer').removeClass('last-answer')
  }

  var setAnswerAudiosButtons = function() {
    for (i = 0; i < 7; i++) {
      button = $('.answer-audio.aa-' + (i+1), '.answer-audios')
      if(answers[questionNumber][0][i]){
        $(button).removeClass('hide')
      } else {
        $(button).addClass('hide')
      }
    }
  }

  var setAnswerButtonsForText = function() {
    $('.answer-buttons-img').hide();
    $('.answer-buttons-txt').show();
    $('.answer-button').removeClass('is-correct')

    for (i = 0; i < 7; i++) {
      button = $('.answer-button.ab-' + (i+1), '.answer-buttons-txt')

      if(correctAnswerIndexes[questionNumber].indexOf(i+1) != -1){
        $(button).addClass('is-correct')
      }

      if(answers[questionNumber][0][i]){
        $(button).removeClass('hide')
        if(answered[questionNumber].indexOf(i+1) !== -1 && correctAnswerIndexes[questionNumber].indexOf(i+1) !== -1) {
          $(button).addClass('correct-answer')
        } else {
          $(button).removeClass('correct-answer')
        }
        $( '.text', $('a', button) ).html(answers[questionNumber][0][i]);
      } else {
        $(button).addClass('hide')
      }
    }
    setAnswerAudios(1)
  }

  var setAnswerButtonsForImage = function() {
    $('.answer-buttons-txt').hide();
    $('.answer-buttons-img').show();
    $('.answer-button').removeClass('is-correct')
    for (i = 0; i < 7; i++) {
      button = $('.answer-button.ab-' + (i+1), '.answer-buttons-img')

      if(correctAnswerIndexes[questionNumber].indexOf(i+1) != -1){
        $(button).addClass('is-correct')
      }

      if(answers[questionNumber][1][i]){
        $(button).removeClass('hide')
        if(answered[questionNumber].indexOf(i+1) !== -1 && correctAnswerIndexes[questionNumber].indexOf(i+1) !== -1) {
          $(button).addClass('correct-answer')
        } else {
          $(button).removeClass('correct-answer')
        }
        $( '.button-image', button ).attr('src', '../files/img/wiem-co-jem/' + answers[questionNumber][1][i]);
        $( '.button-footer', button ).text(answers[questionNumber][0][i]);
      } else {
        $(button).addClass('hide')
      }
    }
    setAnswerAudios(2)
  }

  var setAnswerAudios = function(index){
    answerAudios = []
    for (i = 0; i < answers[questionNumber][index].length; i++) {
      answerAudios.push(new Audio('../files/audio/wiem-co-jem/quiz/' + questionNumber + '/' + answers[questionNumber][index][i]))
    }
  }

  var fillEndModalAndShowIt = function() {
    var tableBodyHtml = '';
    var i = 1;
    _.each(answered, function(yourAnswers){
      var yourAnswerTexts = []
      _.each(yourAnswers, function(answer) {
        if(correctAnswerIndexes[i].indexOf(answer) != -1){
          yourAnswerTexts.push('<span class="text-success">' + answers[i][0][answer-1] + '</span>')
        } else {
          yourAnswerTexts.push('<span class="text-danger">' + answers[i][0][answer-1] + '</span>')
        }
      })
      tableBodyHtml+='<tr><td>' + i + '</td><td>' + yourAnswers.length + '</td><td>' + _.difference(yourAnswers, correctAnswerIndexes[i]).length + '</td><td>' + yourAnswerTexts.join(', ') + '</td></tr>'
      i+=1;
    })
    $('tbody', '#quizEndedModal').html(tableBodyHtml)
    $('#quizEndedModal').modal('show')
  }

  var showCorrectAnswerModal = function(){
    $('#modalCorrectAnswer').modal('show')
  }



  setAnswerButtonsForImage()
  setAnswerAudiosButtons()

});
