$( document ).ready(function() {

  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/komunikacja/policz_1/polecenie1.wav');

  var questionNumber = 1
  var noOfQuestions = 2
  var badAnswerCount = [0, 0]
  var answeredProperly = [false, false]
  var shownAnswers = ['NIE', 'NIE']
  var answers = [
    [5,4,2,7],
    [3,1,7,5,6]
  ]

  loadQuestionData = function() {
    if (questionNumber == 1) {
      $('input').mask('Z', {translation: {'Z': {pattern: /[2,4,5,7]/, optional: false}}})
      questionAudio = new Audio('../files/audio/komunikacja/policz_1/polecenie1.wav');
      $('.question-text').text('Wpisz liczby 2, 4, 5 i 7 tak, aby w każdej linii poziomej i pionowej suma liczb była nieparzysta.')
    } else {
      if (questionNumber == 2) {
        $('input').mask('Z', {translation: {'Z': {pattern: /[1,3,5,6,7]/, optional: false}}})
        questionAudio = new Audio('../files/audio/komunikacja/policz_1/polecenie2.wav');
        $('.question-text').text('Wpisz liczby 1, 3, 5, 6, 7 tak, aby w każdej linii między skrajnymi kółkami, suma liczb była parzysta.')
      }
    }
  }

  $('.next-question').on('click', function(event) {
    event.preventDefault()
    $('#modalNextQuestion').modal('hide')
    $('.container-graf-' + questionNumber).parent().addClass('hidden')
    questionNumber += 1;
    $('.container-graf-' + questionNumber).parent().removeClass('hidden')
    if (questionNumber == noOfQuestions) {
      $('.next-question').addClass('disabled')
    }
    $('.prev-question').removeClass('disabled')
    loadQuestionData()
  })

  $('.prev-question').on('click', function(event) {
    event.preventDefault()
    $('.container-graf-' + questionNumber).parent().addClass('hidden')
    questionNumber -= 1;
    $('.container-graf-' + questionNumber).parent().removeClass('hidden')
    if (questionNumber == 1) {
      $('.prev-question').addClass('disabled')
    }
    $('.next-question').removeClass('disabled')
    loadQuestionData()
  })

  $('input.graf-my-answer').on('keyup', function() {
    var currentInput = this
    if (answers[questionNumber-1].indexOf(parseInt($(currentInput).val())) != -1) {
      var valCount = 0
      $('input.graf-my-answer', '.container-graf-' + questionNumber).each(function() {
        if ($(this).val() == $(currentInput).val()) {
          valCount += 1
        }
      })
      if (valCount > 1) {
        $(currentInput).val('')
      } else {
        checkIfShouldFinishAnswer()
      }
    }
  })

  checkIfShouldFinishAnswer = function() {
    if (questionNumber == 1) {
      var properVals = checkQuestion1Answers()
    } else {
      if (questionNumber == 2) {
        var properVals = checkQuestion2Answers()
      }
    }
    console.log (properVals)
    if (properVals != null) {
      if (properVals.indexOf(false) == -1) {
        goodAnswerAudio.play()
        answeredProperly[questionNumber-1] = true
        showProperModalOnCurrentAnswerFinish()
      } else {
        badAnswerAudio.play()
        badAnswerCount[questionNumber-1] += 1
      }
    }
  }

  checkQuestion1Answers = function() {
    var properVals = [false, false, false, false]
    var val1 = parseInt($('.input-1-1', '.container-graf-' + questionNumber).val())
    var val2 = parseInt($('.input-1-2', '.container-graf-' + questionNumber).val())
    var val3 = parseInt($('.input-1-3', '.container-graf-' + questionNumber).val())
    var val4 = parseInt($('.input-1-4', '.container-graf-' + questionNumber).val())
    if (val1 > 0 && val2 > 0 && val3 > 0 && val4 > 0) {
      if ((val1 + val2)%2 == 1)
        properVals[0] = true
      if ((val2 + val4)%2 == 1)
        properVals[1] = true
      if ((val4 + val3)%2 == 1)
        properVals[2] = true
      if ((val3 + val1)%2 == 1)
        properVals[3] = true
      return properVals
    } else {
      return null
    }
  }

  checkQuestion2Answers = function() {
    console.log ('2')
    var properVals = [false, false, false, false, false, false]
    var val1 = parseInt($('.input-1-1', '.container-graf-' + questionNumber).val())
    var val2 = parseInt($('.input-1-2', '.container-graf-' + questionNumber).val())
    var val3 = parseInt($('.input-1-3', '.container-graf-' + questionNumber).val())
    var val4 = parseInt($('.input-1-4', '.container-graf-' + questionNumber).val())
    var val5 = parseInt($('.input-1-5', '.container-graf-' + questionNumber).val())
    if (val1 > 0 && val2 > 0 && val3 > 0 && val4 > 0 && val5 > 0) {
      if ((val1 + val2)%2 == 0)
        properVals[0] = true
      if ((val2 + val3)%2 == 0)
        properVals[1] = true
      if ((val3 + val4)%2 == 0)
        properVals[2] = true
      if ((val4 + val1)%2 == 0)
        properVals[3] = true
      if ((val1 + val4 + val5)%2 == 0)
        properVals[4] = true
      if ((val2 + val3 + val5)%2 == 0)
        properVals[5] = true
      return properVals
    } else {
      return null
    }
  }

  $('.read-question').on('click', function(e) {
    e.preventDefault()
    questionAudio.play()
  })

  $('.check-answer').on('click', function(e) {
    e.preventDefault()
    shownAnswers[questionNumber-1] = "TAK"
    $('.graf-my-answer', '.container-graf-' + questionNumber).each(function(index) {
      $(this).val(answers[questionNumber-1][index])
      answeredProperly[questionNumber-1][index] = true
    })
    checkIfShouldFinishAnswer()

  })

  showProperModalOnCurrentAnswerFinish = function() {
    if (answeredProperly.indexOf(false) == -1) {
      $('tbody', '#allEndedModal').html('')
      for(var i=1; i<=noOfQuestions; i++) {
        $('tbody', '#allEndedModal').append('<tr><td>' + i + '</td><td>' + shownAnswers[i-1] + '</td><td>' + badAnswerCount[i-1] + '</td></tr>')
      }
      $('#allEndedModal').modal('show')
    } else {
      $('#modalNextQuestion').modal('show')
    }
  }

  loadQuestionData()

})
