$( document ).ready(function() {

// DATA
  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/komunikacja/quiz/pyt1.wav');

  var questionNumber = 1;
  var noOfQuestions = 16;

  var questionTypes = [
    'image',
    'text',
    'image',
    'image',
    'text',
    'text',
    'text',
    'text',
    'text',
    'text',
    'image',
    'image',
    'image',
    'image',
    'image',
    'image'
  ]

  var questions = {
    1: "Jakich instrumentów używano by porozumiewać się dźwiękiem?",
    2: "Jak nazywa się język stosowany przez osoby głuchonieme?",
    3: "Do przekazywania informacji dawniej używano:",
    4: "Jakie ptaki przenosiły listy na duże odległości",
    5: "Miejsca odpoczynku dla konnych posłańców nazywano:",
    6: "Gdzie wynaleziono pierwsze telefony sznurkowe?",
    7: "Jakie zjawisko wykorzystano w telefonach rurowych?",
    8: "W jakiej odległości stały wieże telegrafu optycznego?",
    9: "Jakie sygnały wykorzystywano w alfabecie Morsa?",
    10: "Kto wynalazł telefon?",
    11: "Zaznacz znak, który informuje, że w pobliżu jest restauracja.",
    12: "Zaznacz znak, który informuje, że w pobliżu znajduje się szpital.",
    13: "Zaznacz znak, który informuje o punkcie informacyjnym.",
    14: "Zaznacz znak, który informuje gdzie możesz zaparkować samochód.",
    15: "Zaznacz znak, który informuje, że w tym miejscu jest dostępny Internet (wi-fi).",
    16: "Zaznacz znak, który informuje, że to miejsce przystosowane jest dla osób niepełnosprawnych."
  }

  var answers = {
    1: {
      0: ['bęben', 'saksofon', 'gitara'],
      1: ['beben.jpg', 'saksofon.jpg', 'gitara.jpg'],
      2: ['beben.wav', 'saksofon.wav', 'gitara.wav']
    },
    2: {
      0: ['migawka', 'język ręczny', 'język migowy'],
      1: ['migawka.wav', 'jezyk-reczny.wav', 'jezyk-migowy.wav'],
    },
    3: {
      0: ['Ognia', 'wody', 'słońca'],
      1: ['ogien.jpg', 'woda.jpg', 'slonce.jpg'],
      2: ['ognia.wav', 'wody.wav', 'slonca.wav']
    },
    4: {
      0: ['Jaskółki', 'bociany', 'gołębie'],
      1: ['jaskolka.jpg', 'bocian.jpg', 'golab.jpg'],
      2: ['jaskolki.wav', 'bociany.wav', 'golebie.wav']
    },
    5: {
      0: ['pocztylion', 'posita', 'postreston'],
      1: ['pocztylion.wav', 'posita.wav', 'postreston.wav']
    },
    6: {
      0: ['w Japonii', 'w Korei', 'w Chinach'],
      1: ['wjaponii.wav', 'wkorei.wav', 'wchinach.wav']
    },
    7: {
      0: ['Odbijania fal dźwiękowych', 'odbijania promieni świetlnych', 'fatamorgany'],
      1: ['odbijaniefal.wav', 'odbijaniepromieni.wav', 'fatamorgana.wav']
    },
    8: {
      0: ['5-6 km', '10-20 km', '20-50 km'],
      1: ['5-6km.wav', '10-20km.wav', '20-50km.wav']
    },
    9: {
      0: ['wysokie i niskie', 'szybkie i wolne', 'krótkie i długie'],
      1: ['wysokie-i-niskie.wav', 'szybkie-i-wolne.wav', 'krotkie-i-dlugie.wav']
    },
    10: {
      0: ['Graham Bell', 'Bella Swan', 'Gary Bildt'],
      1: ['graham-bell.wav', 'bella-swan.wav', 'gary-bildt.wav']
    },
    11: {
      0: ['znak_restauracja', 'znak_niepelnosprawni', 'znak_wc_dziewczynka'],
      1: ['znak_restauracja.jpg', 'znak_niepelnosprawni.jpg', 'znak_wc_dziewczynka.jpg'],
      2: []
    },
    12: {
      0: ['znak_niepelnosprawni', 'znak_szpital', 'znak_informacyjny'],
      1: ['znak_niepelnosprawni.jpg', 'znak_szpital.jpg', 'znak_informacyjny.jpg'],
      2: []
    },
    13: {
      0: ['znak_informacyjny', 'znak_wifi', 'znak_toalety'],
      1: ['znak_informacyjny.jpg', 'znak_wifi.jpg', 'znak_toalety.jpg'],
      2: []
    },
    14: {
      0: ['znak_pole_namiotowe', 'znak_budka_telefoniczna', 'znak_parking'],
      1: ['znak_pole_namiotowe.jpg', 'znak_budka_telefoniczna.jpg', 'znak_parking.jpg'],
      2: []
    },
    15: {
      0: ['znak_miejsce_noclegowe', 'znak_wifi', 'znak_plac_zabaw'],
      1: ['znak_miejsce_noclegowe.jpg', 'znak_wifi.jpg', 'znak_plac_zabaw.jpg'],
      2: []
    },
    16: {
      0: ['znak_parking', 'znak_niepelnosprawni', 'znak_toalety'],
      1: ['znak_parking.jpg', 'znak_niepelnosprawni.jpg', 'znak_toalety.jpg'],
      2: []
    }

  }

  var answerAudios = []

  var correctAnswerIndexes = {
    1: [1],
    2: [3],
    3: [1],
    4: [3],
    5: [2],
    6: [3],
    7: [1],
    8: [2],
    9: [3],
    10: [1],
    11: [1],
    12: [2],
    13: [1],
    14: [3],
    15: [2],
    16: [2]

  }

  var questionsFinished = []

  var answered = {
    1: [],
    2: [],
    3: [],
    4: [],
    5: [],
    6: [],
    7: [],
    8: [],
    9: [],
    10: [],
    11: [],
    12: [],
    13: [],
    14: [],
    15: [],
    16: []
  }

// MAIN LOGIC

  $( '.question-number' ).html( questionNumber );
  $( '.question-sum' ).html( noOfQuestions );
  $( '.question-text' ).html( questions[questionNumber] );

  $( 'body' ).on('click', '.next-question', function(event){
    event.preventDefault()
    if(questionNumber < noOfQuestions){
      questionNumber++;
      setPageDataForQuestion()
    }
    $('#modalCorrectAnswer').modal('hide')
  });

  $( '.prev-question' ).on('click', function(event){
    event.preventDefault()
    if(questionNumber > 1){
      questionNumber--;
      setPageDataForQuestion()
    }
  });

  $('.answer-audio').on('click', function(event){
    event.preventDefault();
    event.stopPropagation();
    var answerNo = parseInt($(this).attr('data-answer-no'));
    answerAudios[answerNo-1].play();
  })

  $( '.answer-button' ).on('click', function(event) {
    event.preventDefault()
    $('.wrong-answer').removeClass('wrong-answer')
    $('.last-answer').removeClass('last-answer')
    $(this).addClass('last-answer')
    var answerNo = parseInt($(this).attr('data-answer-no'))
    answered[questionNumber].push(answerNo)
    if(correctAnswerIndexes[questionNumber].indexOf(answerNo) !== -1) {
      $(this).addClass('correct-answer')
      badAnswerAudio.load()
      goodAnswerAudio.play()

      if(_.uniq(_.intersection(correctAnswerIndexes[questionNumber], answered[questionNumber])).length == correctAnswerIndexes[questionNumber].length) {

        //all correct answers selected
        if(questionsFinished.indexOf(questionNumber) == -1){
          questionsFinished.push(questionNumber)
        }
        if(!(questionsFinished.length === noOfQuestions)){
          if(questionNumber < noOfQuestions){
            showCorrectAnswerModal()
          }
        } else {
          fillEndModalAndShowIt()
        }

      }
    } else {
      goodAnswerAudio.load()
      badAnswerAudio.play()
      $(this).addClass('wrong-answer')
    }
  });

  $('.read-question').on('click', function(event) {
    event.preventDefault()
    questionAudio.play()
  })

  $('.check-answer').on('click', function(event) {
    event.preventDefault()
    $('.is-correct').toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500)
  })

  var setPageDataForQuestion = function() {
    $( '.question-number' ).html(questionNumber );
    $( '.question-text' ).html(questions[questionNumber] );
    $( '.question-image').html('')

    questionAudio = new Audio('../files/audio/komunikacja/quiz/pyt' + questionNumber + '.wav');

    if(questionTypes[questionNumber-1] === 'image'){
      setAnswerButtonsForImage()
    } else if(questionTypes[questionNumber-1] === 'text') {
      setAnswerButtonsForText()
    } else if(questionTypes[questionNumber-1] === 'text-with-image') {
      setAnswerButtonsForText()
      setImageForQuestion()
    }
    setAnswerAudiosButtons()
    if(questionNumber == noOfQuestions) {
      $( '.next-question' ).addClass('disabled')
    } else {
      $( '.next-question' ).removeClass('disabled');
    };
    if(questionNumber == 1) {
      $( '.prev-question' ).addClass('disabled');
    } else {
      $( '.prev-question' ).removeClass('disabled');
    }
    $('.wrong-answer').removeClass('wrong-answer')
    $('.last-answer').removeClass('last-answer')
  }

  var setAnswerAudiosButtons = function() {
    for (i = 0; i < 7; i++) {
      button = $('.answer-audio.aa-' + (i+1), '.answer-audios')
      if(answers[questionNumber][0][i] && questionNumber < 11){
        $(button).removeClass('hide')
      } else {
        $(button).addClass('hide')
      }
    }
  }

  var setAnswerButtonsForText = function() {
    $('.answer-buttons-img').hide();
    $('.answer-buttons-txt').show();
    $('.answer-button').removeClass('is-correct')

    for (i = 0; i < 7; i++) {
      button = $('.answer-button.ab-' + (i+1), '.answer-buttons-txt')

      if(correctAnswerIndexes[questionNumber].indexOf(i+1) != -1){
        $(button).addClass('is-correct')
      }

      if(answers[questionNumber][0][i]){
        $(button).removeClass('hide')
        if(answered[questionNumber].indexOf(i+1) !== -1 && correctAnswerIndexes[questionNumber].indexOf(i+1) !== -1) {
          $(button).addClass('correct-answer')
        } else {
          $(button).removeClass('correct-answer')
        }
        $( '.text', $('a', button) ).html(answers[questionNumber][0][i]);
      } else {
        $(button).addClass('hide')
      }
    }
    setAnswerAudios(1)
  }

  var setImageForQuestion = function () {
    $( '.question-image').html('<img src="../files/img/komunikacja/quiz/' + answers[questionNumber][2] + '">')
  }

  var setAnswerButtonsForImage = function() {
    $('.answer-buttons-txt').hide();
    $('.answer-buttons-img').show();
    $('.answer-button').removeClass('is-correct')
    for (i = 0; i < 7; i++) {
      button = $('.answer-button.ab-' + (i+1), '.answer-buttons-img')

      if(correctAnswerIndexes[questionNumber].indexOf(i+1) != -1){
        $(button).addClass('is-correct')
      }

      if(answers[questionNumber][1][i]){
        $(button).removeClass('hide')
        if(answered[questionNumber].indexOf(i+1) !== -1 && correctAnswerIndexes[questionNumber].indexOf(i+1) !== -1) {
          $(button).addClass('correct-answer')
        } else {
          $(button).removeClass('correct-answer')
        }
        $( '.button-image', button ).attr('src', '../files/img/komunikacja/quiz/' + answers[questionNumber][1][i]);
        $( '.button-footer', button ).text(answers[questionNumber][0][i]);
      } else {
        $(button).addClass('hide')
      }
    }
    setAnswerAudios(2)
  }

  var setAnswerAudios = function(index){
    answerAudios = []
    if (questionNumber < 11) {
      for (i = 0; i < answers[questionNumber][index].length; i++) {
        answerAudios.push(new Audio('../files/audio/komunikacja/quiz/' + answers[questionNumber][index][i]))
      }
    }
  }

  var fillEndModalAndShowIt = function() {
    var tableBodyHtml = '';
    var i = 1;
    _.each(answered, function(yourAnswers){
      var yourAnswerTexts = []
      _.each(yourAnswers, function(answer) {
        if(correctAnswerIndexes[i].indexOf(answer) != -1){
          yourAnswerTexts.push('<span class="text-success">' + answers[i][0][answer-1] + '</span>')
        } else {
          yourAnswerTexts.push('<span class="text-danger">' + answers[i][0][answer-1] + '</span>')
        }
      })
      tableBodyHtml+='<tr><td>' + i + '</td><td>' + yourAnswers.length + '</td><td>' + _.difference(yourAnswers, correctAnswerIndexes[i]).length + '</td><td>' + yourAnswerTexts.join(', ') + '</td></tr>'
      i+=1;
    })
    $('tbody', '#quizEndedModal').html(tableBodyHtml)
    $('#quizEndedModal').modal('show')
  }

  var showCorrectAnswerModal = function(){
    $('#modalCorrectAnswer').modal('show')
  }



  setPageDataForQuestion()

});
