$( document ).ready(function() {

  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/sport/policz/polecenie_policz.wav');

  var questionNumber = 1
  var noOfQuestions = 4
  var badAnswerCount = [0, 0, 0, 0]
  var answeredProperly = [
    [false, false, false, false, false],
    [false, false, false, false, false, false],
    [false, false, false, false, false],
    [false, false, false, false, false, false]
  ]
  var shownAnswers = [
    [false, false, false, false, false],
    [false, false, false, false, false, false],
    [false, false, false, false, false],
    [false, false, false, false, false, false]
  ]
  var answers = [
    [8, 6, 10, 11, 9],
    [5, 6, 9, 6, 8, 4],
    [10, 9, 10, 15, 13],
    [25, 26, 30, 20, 25, 15]
  ]

  $('.next-question').on('click', function(event) {
    event.preventDefault()
    $('#modalNextQuestion').modal('hide')
    $('.container-graf-' + questionNumber).parent().addClass('hidden')
    questionNumber += 1;
    $('.container-graf-' + questionNumber).parent().removeClass('hidden')
    if (questionNumber == noOfQuestions) {
      $('.next-question').addClass('disabled')
    }
    $('.prev-question').removeClass('disabled')
  })

  $('.prev-question').on('click', function(event) {
    event.preventDefault()
    $('.container-graf-' + questionNumber).parent().addClass('hidden')
    questionNumber -= 1;
    $('.container-graf-' + questionNumber).parent().removeClass('hidden')
    if (questionNumber == 1) {
      $('.prev-question').addClass('disabled')
    }
    $('.next-question').removeClass('disabled')
  })

  $('.read-question').on('click', function(e) {
    e.preventDefault()
    questionAudio.play()
  })

  $('.check-answer').on('click', function(e) {
    e.preventDefault()
    $('.graf-my-answer', '.container-graf-' + questionNumber).each(function(index) {
      $(this).val(answers[questionNumber-1][index])
      shownAnswers[questionNumber-1][index] = true
      answeredProperly[questionNumber-1][index] = true
    })
    checkIfShouldFinish()

  })

  $('.show-answer').on('click', function(e) {
    e.preventDefault()
    var inputNo = parseInt($(this).attr('data-answer'))
    $('.graf-my-answer[data-input=' + inputNo + ']', '.container-graf-' + questionNumber).val(answers[questionNumber-1][inputNo-1])
    shownAnswers[questionNumber-1][inputNo-1] = true
    answeredProperly[questionNumber-1][inputNo-1] = true
    checkIfShouldFinish()
  })

  // $('input.graf-my-answer').on
  $('input.graf-my-answer').mask('00')
  $('input.graf-my-answer').on( "keyup", function() {
    var answerNo = parseInt($(this).attr('data-input'))
    $('.wrong-answer').removeClass('wrong-answer')
    // $('.correct-answer').removeClass('correct-answer')
    if ($(this).val().toString().length == answers[questionNumber-1][answerNo-1].toString().length) {
      if( $(this).val() == answers[questionNumber-1][answerNo-1] ) {
        $(this).addClass('correct-answer');
        badAnswerAudio.load()
        goodAnswerAudio.play()
        answeredProperly[questionNumber-1][answerNo-1] = true
        checkIfShouldFinish()
      } else {
        $(this).addClass('wrong-answer').removeClass('correct-answer');
        goodAnswerAudio.load()
        badAnswerAudio.play()
        badAnswerCount[questionNumber-1] += 1
      }
    }
  })

  checkIfShouldFinish = function(){
    if (answeredProperly[questionNumber-1].indexOf(false) == -1) {
      var allAnsweredProperly = true
      for(var i=0; i<noOfQuestions; i++) {
        if (answeredProperly[i].indexOf(false) != -1) {
          allAnsweredProperly = false
        }
      }
      if (allAnsweredProperly) {
        showFinishModal()
      } else {
        showNextQuestionModal()
      }
    }
  }

  showNextQuestionModal = function() {
    $('#modalNextQuestion').modal('show')
  }

  showFinishModal = function() {
    $('tbody', '#grafEndedModal').html('')
    for(var i=1; i<=noOfQuestions; i++) {
      $('tbody', '#grafEndedModal').append('<tr><td>' + i + '</td><td>' + _.filter(shownAnswers[i-1], function(a) {return (a == true)}).length + '</td><td>' + badAnswerCount[i-1] + '</td></tr>')
    }
    $('#grafEndedModal').modal('show')
  }



})
