$( document ).ready(function() {

// DATA
  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/sport/quiz/polecenie_quiz.wav');


  var questionNumber = 1;
  var noOfQuestions = 10;

  var questionTypes = [
    'text-with-image',
    'text-with-image',
    'text-with-image',
    'text-with-image',
    'text-with-image',
    'text-with-image',
    'text-with-image',
    'text-with-image',
    'text-with-image',
    'text-with-image'
  ]

  var questions = {
    1: "Do jakiego sportu użyjesz tej piłki?",
    2: "Do jakiego sportu użyjesz tej piłki?",
    3: "Do jakiego sportu użyjesz tej piłki?",
    4: "Do jakiego sportu użyjesz tej piłki?",
    5: "Do jakiego sportu użyjesz tej piłki?",
    6: "Do jakiego sportu użyjesz tej piłki?",
    7: "Do jakiego sportu użyjesz tej piłki?",
    8: "Do jakiego sportu użyjesz tej piłki?",
    9: "Do jakiego sportu użyjesz tej piłki?",
    10: "Do jakiego sportu użyjesz tej piłki?"
  }

  var answers = {
    1: {
      0: ['Baseball', 'Golf', 'Hokej na trawie', 'Piłka nożna', 'Piłka ręczna', 'Siatkówka'],
      1: ['baseball.wav', 'golf.wav', 'hokej-na-trawie.wav', 'pilka_nozna.wav', 'pilka_reczna.wav', 'siatkowka.wav'],
      2: ['pilka_golfowa.png']
    },
    2: {
      0: ['Koszykówka', 'Siatkówka', 'Tenis ziemny', 'Baseball', 'Golf', 'Tenis stołowy'],
      1: ['koszykowka.wav', 'siatkowka.wav', 'tenis_ziemny.wav', 'baseball.wav', 'golf.wav', 'tenis_stolowy.wav'],
      2: ['pilka_siatkowa.png']
    },
    3: {
      0: ['Tenis ziemny', 'Baseball', 'Koszykówka', 'Siatkówka', 'Golf', 'Tenis stołowy'],
      1: ['tenis_ziemny.wav', 'baseball.wav', 'koszykowka.wav', 'siatkowka.wav', 'golf.wav', 'tenis_stolowy.wav'],
      2: ['pilkatenisowa.png']
    },
    4: {
      0: ['Baseball', 'Football amerykańsk', 'Koszykówka', 'Piłka nożna', 'Piłka ręczna', 'Siatkówka'],
      1: ['baseball.wav', 'football-amerykanski.wav', 'koszykowka.wav', 'pilka_nozna.wav', 'pilka_reczna.wav', 'siatkowka.wav'],
      2: ['baseball.png']
    },
    5: {
      0: ['Piłka nożna', 'Piłka ręczna', 'Siatkówka', 'Baseball', 'Football amerykański', 'Koszykówka'],
      1: ['pilka_nozna.wav', 'pilka_reczna.wav', 'siatkowka.wav', 'baseball.wav', 'football-amerykanski.wav', 'koszykowka.wav'],
      2: ['rugby.png']
    },
    6: {
      0: ['Hokej na trawie', 'Koszykówka', 'Piłka nożna', 'Piłka ręczna', 'Tenis ziemny', 'Tenis stołowy'],
      1: ['hokej-na-trawie.wav', 'koszykowka.wav', 'pilka_nozna.wav', 'pilka_reczna.wav', 'tenis_ziemny.wav', 'tenis_stolowy.wav'],
      2: ['pilka_do_pingponga.png']
    },
    7: {
      0: ['Koszykówka', 'Piłka nożna', 'Hokej na trawie', 'Tenis stołowy', 'Piłka ręczna', 'Tenis ziemny'],
      1: ['koszykowka.wav', 'pilka_nozna.wav', 'hokej-na-trawie.wav', 'tenis_stolowy.wav', 'pilka_reczna.wav', 'tenis_ziemny.wav'],
      2: ['krazek_hokejowy.jpg']
    },
    8: {
      0: ['Piłka ręczna', 'Siatkówka', 'Baseball', 'Football amerykański', 'Piłka nożna', 'Koszykówka'],
      1: ['pilka_reczna.wav', 'siatkowka.wav', 'baseball.wav', 'football-amerykanski.wav', 'pilka_nozna.wav', 'koszykowka.wav'],
      2: ['pilka_reczna.jpg']
    },
    9: {
      0: ['Koszykówka', 'Hokej na trawie', 'Tenis stołowy', 'Piłka nożna', 'Piłka ręczna', 'Tenis ziemny'],
      1: ['koszykowka.wav', 'hokej-na-trawie.wav', 'tenis_stolowy.wav', 'pilka_nozna.wav', 'pilka_nozna.wav', 'tenis_ziemny.wav'],
      2: ['pilka_do_kosza.png']
    },
    10: {
      0: ['Piłka ręczna', 'Tenis ziemny', 'Koszykówka', 'Tenis stołowy', 'Piłka nożna', 'Hokej na trawie'],
      1: ['pilka_reczna.wav', 'tenis_ziemny.wav', 'koszykowka.wav', 'tenis_stolowy.wav', 'pilka_nozna.wav', 'hokej-na-trawie.wav'],
      2: ['pilka_nozna.png']
    }
  }

  var answerAudios = []

  var correctAnswerIndexes = {
    1: [2],
    2: [2],
    3: [1],
    4: [1],
    5: [5],
    6: [6],
    7: [3],
    8: [1],
    9: [1],
    10: [5]

  }

  var questionsFinished = []

  var answered = {
    1: [],
    2: [],
    3: [],
    4: [],
    5: [],
    6: [],
    7: [],
    8: [],
    9: [],
    10: []
  }

// MAIN LOGIC

  $( '.question-number' ).html( questionNumber );
  $( '.question-sum' ).html( noOfQuestions );
  $( '.question-text' ).html( questions[questionNumber] );

  $( 'body' ).on('click', '.next-question', function(event){
    event.preventDefault()
    if(questionNumber < noOfQuestions){
      questionNumber++;
      setPageDataForQuestion()
    }
    $('#modalCorrectAnswer').modal('hide')
  });

  $( '.prev-question' ).on('click', function(event){
    event.preventDefault()
    if(questionNumber > 1){
      questionNumber--;
      setPageDataForQuestion()
    }
  });

  $('.answer-audio').on('click', function(event){
    event.preventDefault();
    event.stopPropagation();
    var answerNo = parseInt($(this).attr('data-answer-no'));
    answerAudios[answerNo-1].play();
  })

  $( '.answer-button' ).on('click', function(event) {
    event.preventDefault()
    $('.wrong-answer').removeClass('wrong-answer')
    $('.last-answer').removeClass('last-answer')
    $(this).addClass('last-answer')
    var answerNo = parseInt($(this).attr('data-answer-no'))
    answered[questionNumber].push(answerNo)
    if(correctAnswerIndexes[questionNumber].indexOf(answerNo) !== -1) {
      $(this).addClass('correct-answer')
      badAnswerAudio.load()
      goodAnswerAudio.play()

      if(_.uniq(_.intersection(correctAnswerIndexes[questionNumber], answered[questionNumber])).length == correctAnswerIndexes[questionNumber].length) {

        //all correct answers selected
        if(questionsFinished.indexOf(questionNumber) == -1){
          questionsFinished.push(questionNumber)
        }
        if(!(questionsFinished.length === noOfQuestions)){
          if(questionNumber < noOfQuestions){
            showCorrectAnswerModal()
          }
        } else {
          fillEndModalAndShowIt()
        }

      }
    } else {
      goodAnswerAudio.load()
      badAnswerAudio.play()
      $(this).addClass('wrong-answer')
    }
  });

  $('.read-question').on('click', function(event) {
    event.preventDefault()
    questionAudio.play()
  })

  $('.check-answer').on('click', function(event) {
    event.preventDefault()
    $('.is-correct').toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500)
  })

  var setPageDataForQuestion = function() {
    $( '.question-number' ).html(questionNumber );
    $( '.question-text' ).html(questions[questionNumber] );
    $( '.question-image').html('')

    // questionAudio = new Audio('../files/audio/sport/quiz/polecenie' + questionNumber + '.wav');

    if(questionTypes[questionNumber-1] === 'image'){
      setAnswerButtonsForImage()
    } else if(questionTypes[questionNumber-1] === 'text') {
      setAnswerButtonsForText()
    } else if(questionTypes[questionNumber-1] === 'text-with-image') {
      setAnswerButtonsForText()
      setImageForQuestion()
    }
    setAnswerAudiosButtons()
    if(questionNumber == noOfQuestions) {
      $( '.next-question' ).addClass('disabled')
    } else {
      $( '.next-question' ).removeClass('disabled');
    };
    if(questionNumber == 1) {
      $( '.prev-question' ).addClass('disabled');
    } else {
      $( '.prev-question' ).removeClass('disabled');
    }
    $('.wrong-answer').removeClass('wrong-answer')
    $('.last-answer').removeClass('last-answer')
  }

  var setAnswerAudiosButtons = function() {
    for (i = 0; i < 7; i++) {
      button = $('.answer-audio.aa-' + (i+1), '.answer-audios')
      if(answers[questionNumber][0][i]){
        $(button).removeClass('hide')
      } else {
        $(button).addClass('hide')
      }
    }
  }

  var setAnswerButtonsForText = function() {
    $('.answer-buttons-img').hide();
    $('.answer-buttons-txt').show();
    $('.answer-button').removeClass('is-correct')

    for (i = 0; i < 7; i++) {
      button = $('.answer-button.ab-' + (i+1), '.answer-buttons-txt')

      if(correctAnswerIndexes[questionNumber].indexOf(i+1) != -1){
        $(button).addClass('is-correct')
      }

      if(answers[questionNumber][0][i]){
        $(button).removeClass('hide')
        if(answered[questionNumber].indexOf(i+1) !== -1 && correctAnswerIndexes[questionNumber].indexOf(i+1) !== -1) {
          $(button).addClass('correct-answer')
        } else {
          $(button).removeClass('correct-answer')
        }
        $( '.text', $('a', button) ).html(answers[questionNumber][0][i]);
      } else {
        $(button).addClass('hide')
      }
    }
    setAnswerAudios(1)
  }

  var setImageForQuestion = function () {
    $( '.question-image').html('<img src="../files/img/sport/quiz/' + answers[questionNumber][2] + '">')
  }

  var setAnswerButtonsForImage = function() {
    $('.answer-buttons-txt').hide();
    $('.answer-buttons-img').show();
    $('.answer-button').removeClass('is-correct')
    for (i = 0; i < 7; i++) {
      button = $('.answer-button.ab-' + (i+1), '.answer-buttons-img')

      if(correctAnswerIndexes[questionNumber].indexOf(i+1) != -1){
        $(button).addClass('is-correct')
      }

      if(answers[questionNumber][1][i]){
        $(button).removeClass('hide')
        if(answered[questionNumber].indexOf(i+1) !== -1 && correctAnswerIndexes[questionNumber].indexOf(i+1) !== -1) {
          $(button).addClass('correct-answer')
        } else {
          $(button).removeClass('correct-answer')
        }
        $( '.button-image', button ).attr('src', '../files/img/sport/quiz/' + answers[questionNumber][1][i]);
        $( '.button-footer', button ).text(answers[questionNumber][0][i]);
      } else {
        $(button).addClass('hide')
      }
    }
    setAnswerAudios(2)
  }

  var setAnswerAudios = function(index){
    answerAudios = []
    for (i = 0; i < answers[questionNumber][index].length; i++) {
      answerAudios.push(new Audio('../files/audio/sport/quiz/' + answers[questionNumber][index][i]))
    }
  }

  var fillEndModalAndShowIt = function() {
    var tableBodyHtml = '';
    var i = 1;
    _.each(answered, function(yourAnswers){
      var yourAnswerTexts = []
      _.each(yourAnswers, function(answer) {
        if(correctAnswerIndexes[i].indexOf(answer) != -1){
          yourAnswerTexts.push('<span class="text-success">' + answers[i][0][answer-1] + '</span>')
        } else {
          yourAnswerTexts.push('<span class="text-danger">' + answers[i][0][answer-1] + '</span>')
        }
      })
      tableBodyHtml+='<tr><td>' + i + '</td><td>' + yourAnswers.length + '</td><td>' + _.difference(yourAnswers, correctAnswerIndexes[i]).length + '</td><td>' + yourAnswerTexts.join(', ') + '</td></tr>'
      i+=1;
    })
    $('tbody', '#quizEndedModal').html(tableBodyHtml)
    $('#quizEndedModal').modal('show')
  }

  var showCorrectAnswerModal = function(){
    $('#modalCorrectAnswer').modal('show')
  }



  setPageDataForQuestion()

});
