$( document ).ready(function() {

// DATA
  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/sport/angielski/polecenie1.wav');

  var questionNumber = 1;
  var roundNumber = 1;
  var noOfQuestions = [1,5,5];

  var answerAudios = {
    1: {
      0: [new Audio('../files/audio/sport/angielski/football.wav'), new Audio('../files/audio/sport/angielski/basketball.wav'), new Audio('../files/audio/sport/angielski/volleyball.wav'), new Audio('../files/audio/sport/angielski/tennis.wav'), new Audio('../files/audio/sport/angielski/hockey.wav'), new Audio('../files/audio/sport/angielski/energy.wav')],
      1: [new Audio('../files/audio/sport/angielski/training.wav'), new Audio('../files/audio/sport/angielski/baseball.wav'), new Audio('../files/audio/sport/angielski/player.wav'), new Audio('../files/audio/sport/angielski/health.wav')]
    },
    2: [ new Audio('../files/audio/sport/angielski/tennis.wav'), new Audio('../files/audio/sport/angielski/training.wav'), new Audio('../files/audio/sport/angielski/energy.wav'), new Audio('../files/audio/sport/angielski/volleyball.wav'), new Audio('../files/audio/sport/angielski/hockey.wav') ],
    3: [ new Audio('../files/audio/sport/angielski/tennis.wav'), new Audio('../files/audio/sport/angielski/player.wav'), new Audio('../files/audio/sport/angielski/health.wav'), new Audio('../files/audio/sport/angielski/football.wav'), new Audio('../files/audio/sport/angielski/basketball.wav') ]
  }

//   basketball, volleyball, tennis, hockey, energy, training
// training, energy, football, baseball, player, health
// training, baseball, player, health, basketball, energy
// player, energy, training, health, volleyball, hockey
// hockey, energy, training, baseball, player, health

  var round2Images = {
    1: ['basketball.jpg', 'volleyball.png', 'tenisista.jpg', 'hockey.jpg', 'energy.jpg', 'training.jpg'],
    2: ['training.jpg', 'energy.jpg', 'football.jpg', 'baseball.png', 'player_stroj.jpg', 'health.jpg'],
    3: ['training.jpg', 'baseball.png', 'player_stroj.jpg', 'health.jpg', 'basketball.jpg', 'energy.jpg'],
    4: ['player_stroj.jpg', 'energy.jpg', 'training.jpg', 'health.jpg', 'volleyball.png', 'hockey.jpg'],
    5: ['hockey.jpg', 'energy.jpg', 'training.jpg', 'baseball.png', 'player_stroj.jpg', 'health.jpg']
  }
  var round2Answers = [3,1,6,5,1]
  var round2UserAnswers = {
    1: [],
    2: [],
    3: [],
    4: [],
    5: []
  }

  var round2CheckedAnswers = [false, false, false, false, false]

  var round3 = [
    {
      0: 'tenisista.jpg',
      1: ['basketball', 'volleyball', 'tennis']
    },
    {
      0: 'player_stroj.jpg',
      1: ['baseball', 'player', 'health']
    },
    {
      0: 'health.jpg',
      1: ['energy', 'training', 'health']
    },
    {
      0: 'football.jpg',
      1: ['training', 'energy', 'football']
    },
    {
      0: 'basketball.jpg',
      1: ['basketball', 'player', 'health']
    }
  ]
  var round3Answers = [3,2,3,3,1]
  var round3UserAnswers = {
    1: [],
    2: [],
    3: [],
    4: [],
    5: []
  }

  var round3CheckedAnswers = [false, false, false, false, false]


// MAIN LOGIC

  $('.next-round').on('click', function(){
    roundNumber += 1;
    $('.round-' + (roundNumber-1)).addClass('hidden')
    $('.round-' + roundNumber).removeClass('hidden')
    if(roundNumber == 3){
      $('.next-round').addClass('disabled')
    }
    $('.prev-round').removeClass('disabled')
    $( '.round-number' ).html( roundNumber );
    $('#round2EndedModal').modal('hide')
    questionNumber = 1;
    if(roundNumber == 2) {
      round2prepareCurrentQuestionData()
      questionAudio = new Audio('../files/audio/sport/angielski/polecenie2.wav');
    } else {
      if(roundNumber == 3){
        round3prepareCurrentQuestionData()
        questionAudio = new Audio('../files/audio/sport/angielski/polecenie3.wav');
      }
    }
  })

  $('.prev-round').on('click', function(){
    roundNumber -= 1;
    $('.round-' + (roundNumber+1)).addClass('hidden')
    $('.round-' + roundNumber).removeClass('hidden')

    if(roundNumber == 1){
      $('.prev-round').addClass('disabled')
    }
    $('.next-round').removeClass('disabled')
    $( '.round-number' ).html( roundNumber );
    questionNumber = 1;
    if(roundNumber == 2) {
      round2prepareCurrentQuestionData()
    } else {
      if(roundNumber == 3){
        round3prepareCurrentQuestionData()
        questionAudio = new Audio('../files/audio/sport/angielski/polecenie3.wav');
      }
    }
  })

// first round

  $('.answer-audio', '.answer-audios-1').on('click', function(event){
    event.preventDefault();
    event.stopPropagation();
    var answerNo = parseInt($(this).attr('data-answer-no'));
    answerAudios[1][0][answerNo-1].play();
  })

  $('.answer-audio', '.answer-audios-2').on('click', function(event){
    event.preventDefault();
    event.stopPropagation();
    var answerNo = parseInt($(this).attr('data-answer-no'));
    answerAudios[1][1][answerNo-1].play();
  })


// second round
  var round2prepareCurrentQuestionData = function() {
    $('.answer-button', '.round-2').removeClass('correct-answer-2').removeClass('wrong-answer-2')
    $('.button-image', $('.answer-buttons', '.round-2')).each(function(index){
      $(this).attr('src', '../files/img/sport/angielski/' + round2Images[questionNumber][index])
      if(index+1 == round2Answers[questionNumber-1] && round2UserAnswers[questionNumber].indexOf(index+1) != -1){
        $(this).parents('.answer-button').addClass('correct-answer-2')
      }
    })
  }

  var checkIfShouldFinishRound2 = function() {
    var allAnsweredCorrectly = true;
    for(var i=0; i<round2Answers.length; i++) {
      if(round2UserAnswers[i+1].indexOf(round2Answers[i]) == -1) {
        allAnsweredCorrectly = false
      }
    }
    if(allAnsweredCorrectly) {
      var tableBodyHtml = '';
      for (var i=1; i<=round2Answers.length; i++) {
        tableBodyHtml += '<tr><td>' + i + '</td><td>'
        if(_.without(round2UserAnswers[i], round2Answers[i-1]).length > 0) {
          tableBodyHtml += _.without(round2UserAnswers[i], round2Answers[i-1]).length
          // + ' (' + _.without(round2UserAnswers[i], round2Answers[i-1]).join(', ') + ')'
        } else {
          tableBodyHtml += '0'
        }
        tableBodyHtml += '</td><td>'
        if(round2CheckedAnswers[i-1]){
          tableBodyHtml += 'TAK'
        } else {
          tableBodyHtml += 'NIE'
        }
        tableBodyHtml += '</td>'
      }
      $('tbody', '#round2EndedModal').html(tableBodyHtml)
      $('#round2EndedModal').modal('show')
    } else {
      $('#modalCorrectAnswer').modal('show')
    }
  }

  $('.read-answer').on('click', function(event){
    event.preventDefault()
    answerAudios[roundNumber][questionNumber-1].play()
  })

  $( '.next-question', '.round-2' ).on('click', function(event){
    event.preventDefault()
    if($(this).parents('round-2')){
      if(questionNumber < noOfQuestions[1]){
        questionNumber++;
        round2prepareCurrentQuestionData()
        if(questionNumber == noOfQuestions[1]){
          $('.next-question', '.round-2').addClass('disabled')
        }
        $('.prev-question', '.round-2').removeClass('disabled')
      }
      $('#modalCorrectAnswer').modal('hide')
    }
  });

  $( '.prev-question', '.round-2' ).on('click', function(event){
    event.preventDefault()
    if(questionNumber > 1){
      questionNumber--;
      round2prepareCurrentQuestionData()
      if(questionNumber == 1){
        $('.prev-question', '.round-2').addClass('disabled')
      }
      $('.next-question', '.round-2').removeClass('disabled')
    }
  });

  $('.answer-button', '.round-2').on('click', function(event){
    event.preventDefault();
    round2UserAnswers[questionNumber].push(parseInt($(this).attr('data-answer-no')))
    $('.answer-button', '.round-2').removeClass('wrong-answer-2')
    if(parseInt($(this).attr('data-answer-no')) == round2Answers[questionNumber-1]){
      $(this).addClass('correct-answer-2')
      checkIfShouldFinishRound2()
      badAnswerAudio.load()
      goodAnswerAudio.play()
    } else {
      $(this).addClass('wrong-answer-2')
      goodAnswerAudio.load()
      badAnswerAudio.play()
    }
  })

  $('.check-answer', '.round-2').on('click', function(event) {
    event.preventDefault()
    round2CheckedAnswers[questionNumber-1] = true
    $('.answer-button[data-answer-no=' + round2Answers[questionNumber-1] + ']', '.round-2').toggleClass('correct-answer-2', 500).delay(500).toggleClass('correct-answer-2', 500).delay(500).toggleClass('correct-answer-2', 500).delay(500).toggleClass('correct-answer-2', 500).delay(500).toggleClass('correct-answer-2', 500).delay(500).toggleClass('correct-answer-2', 500)
  })

  $( '.round-number' ).html( roundNumber );

// third round

  var round3prepareCurrentQuestionData = function() {
    $('.answer-button', '.round-3').removeClass('correct-answer').removeClass('wrong-answer')
    $('.text-thumb', $('.answer-buttons', '.round-3')).each(function(index){
      $(this).html(round3[questionNumber-1][1][index])
      if(index+1 == round3Answers[questionNumber-1] && round3UserAnswers[questionNumber].indexOf(index+1) != -1){
        $(this).parents('.answer-button').addClass('correct-answer')
      }
    })
    $('.button-image', '.round-3').attr('src', '../files/img/sport/angielski/' + round3[questionNumber-1][0])
  }

  var checkIfShouldFinishRound3 = function() {
    var allAnsweredCorrectly = true;
    for(var i=0; i<round3Answers.length; i++) {
      if(round3UserAnswers[i+1].indexOf(round3Answers[i]) == -1) {
        allAnsweredCorrectly = false
      }
    }
    if(allAnsweredCorrectly) {
      var tableBodyHtml = '';
      for (var i=1; i<=round3Answers.length; i++) {
        tableBodyHtml += '<tr><td>' + i + '</td><td>'
        if(_.without(round3UserAnswers[i], round3Answers[i-1]).length > 0) {
          tableBodyHtml += _.without(round3UserAnswers[i], round3Answers[i-1]).length
          // + ' (' + _.without(round2UserAnswers[i], round2Answers[i-1]).join(', ') + ')'
        } else {
          tableBodyHtml += '0'
        }
        tableBodyHtml += '</td><td>'
        if(round3CheckedAnswers[i-1]){
          tableBodyHtml += 'TAK'
        } else {
          tableBodyHtml += 'NIE'
        }
        tableBodyHtml += '</td>'
      }
      $('tbody', '#round3EndedModal').html(tableBodyHtml)
      $('#round3EndedModal').modal('show')
    } else {
      $('#modalCorrectAnswer').modal('show')
    }
  }

  $('.read-question').on('click', function(event){
    event.preventDefault()
    questionAudio.play()
  })

  $( '.next-question', '.round-3' ).on('click', function(event){
    event.preventDefault()
    if(questionNumber < noOfQuestions[2]){
      questionNumber++;
      round3prepareCurrentQuestionData()
      if(questionNumber == noOfQuestions[2]){
        $('.next-question', '.round-3').addClass('disabled')
      }
      $('.prev-question', '.round-3').removeClass('disabled')
    }
    $('#modalCorrectAnswer').modal('hide')
  });

  $( '.prev-question', '.round-3' ).on('click', function(event){
    event.preventDefault()
    if(questionNumber > 1){
      questionNumber--;
      round3prepareCurrentQuestionData()
      if(questionNumber == 1){
        $('.prev-question', '.round-3').addClass('disabled')
      }
      $('.next-question', '.round-3').removeClass('disabled')
    }
    $('#modalCorrectAnswer').modal('hide')
  });

  $('.answer-button', '.round-3').on('click', function(event){
    event.preventDefault();
    round3UserAnswers[questionNumber].push(parseInt($(this).attr('data-answer-no')))
    $('.answer-button', '.round-3').removeClass('wrong-answer')
    if(parseInt($(this).attr('data-answer-no')) == round3Answers[questionNumber-1]){
      $(this).addClass('correct-answer')
      checkIfShouldFinishRound3()
      badAnswerAudio.load()
      goodAnswerAudio.play()
    } else {
      $(this).addClass('wrong-answer')
      goodAnswerAudio.load()
      badAnswerAudio.play()
    }
  })

  $('.check-answer', '.round-3').on('click', function(event) {
    event.preventDefault()
    round3CheckedAnswers[questionNumber-1] = true
    $('.answer-button[data-answer-no=' + round3Answers[questionNumber-1] + ']', '.round-3').toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500)
  })



});
