$( document ).ready(function() {

  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/maly-dyplomata/polecenie_policz.wav');

  var worngAnswersCount = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
  var properAnswers = [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false]
  var checkedAnswers = [false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false]
  var questionNumber = 1
  var noOfQuestions = 20

  var answerData = [
    ['3', '+', '5', '2'],
    ['5', '+', '2', '3'],
    ['6', '+', '1', '3'],
    ['7', '+', '3', '0'],
    ['8', '+', '1', '1'],
    ['2', '+', '2', '6'],
    ['1', '+', '6', '3'],
    ['4', '+', '5', '1'],
    ['4', '+', '0', '6'],
    ['3', '+', '3', '4'],
    ['8', '-', '2', '4'],
    ['7', '-', '6', '9'],
    ['5', '-', '4', '9'],
    ['4', '-', '1', '7'],
    ['7', '-', '5', '8'],
    ['8', '-', '7', '9'],
    ['4', '-', '3', '9'],
    ['9', '-', '4', '5'],
    ['7', '-', '2', '5'],
    ['9', '-', '1', '2']
  ]

  $('.read-question').on('click', function(event){
    event.preventDefault()
    questionAudio.play()
  })

  $('.check-answer').on('click', function(e) {
    e.preventDefault()
    val = answerData[questionNumber-1][3]
    $('.answer').html(val)
    checkAnswer(true)
    checkedAnswers[questionNumber-1] = true
  })

  $('a', '.answer-button').on('click', function(e) {
    e.preventDefault()
    val = $('h1', this).text()
    $('.answer').text(val)
    checkAnswer(val == answerData[questionNumber-1][3])
  })

  checkAnswer = function(isProperAnswer) {
    if (isProperAnswer) {
      goodAnswerAudio.play()
      properAnswers[questionNumber-1] = true
      if (properAnswers.indexOf(false) == -1) {
        showEndModal()
      } else {
        showCorrectAnswerModal()
      }
    } else {
      badAnswerAudio.play()
      worngAnswersCount[questionNumber-1] += 1
      showBadAnswerModal()
    }
  }

  showBadAnswerModal = function () {
    $('#modalTryAgain').modal('show')
  }
  showCorrectAnswerModal = function () {
    $('#modalCorrectAnswer').modal('show')
  }
  showEndModal = function () {
    $('tbody', '#allEndedModal').html('')
    for(var i=1; i<=noOfQuestions; i++) {
      var podpowiedz = "NIE"
      if (checkedAnswers[i-1])
        podpowiedz = 'TAK'
      $('tbody', '#allEndedModal').append('<tr><td>' + i + '</td><td>' + podpowiedz + '</td><td>' + worngAnswersCount[i-1] + '</td></tr>')
    }
    $('#allEndedModal').modal('show')
  }

  $( 'body' ).on('click', '.next-question', function(event){
    event.preventDefault()
    if(questionNumber < noOfQuestions){
      questionNumber++;
      loadQuestionData()
    }
  });

  $( '.prev-question' ).on('click', function(event){
    event.preventDefault()
    if(questionNumber > 1){
      questionNumber--;
      loadQuestionData()
    }
  });

  $('.clear-answers').on('click', function(e) {
    e.preventDefault()
    loadQuestionData()
  })

  loadQuestionData = function () {
    $('#modalCorrectAnswer').modal('hide')
    $('#modalTryAgain').modal('hide')
    if(questionNumber == noOfQuestions) {
      $( '.next-question' ).addClass('disabled')
    } else {
      $( '.next-question' ).removeClass('disabled');
    };
    if(questionNumber == 1) {
      $( '.prev-question' ).addClass('disabled');
    } else {
      $( '.prev-question' ).removeClass('disabled');
    }

    if (properAnswers[questionNumber-1]){
      $('.answer').text(answerData[questionNumber-1][3])
    } else {
      $('.answer').text('')
    }
    $('.operation-element').each(function() {
      index = parseInt($(this).attr('data-index'))
      $(this).text(answerData[questionNumber-1][index])
    })
  }


  loadQuestionData()

})