$( document ).ready(function() {

// DATA
  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/maly-dyplomata/quiz/polecenie.wav');


  var questionNumber = 1;
  var noOfQuestions = 10;

  var questionTypes = [
    'text',
    'text',
    'text',
    'text',
    'text',
    'text',
    'text',
    'text',
    'text',
    'text'
  ]

  var questions = {
    1: "Obyczaje to:",
    2: "Savoir-vivre to:",
    3: "Menu to:",
    4: "Sztućce to:",
    5: "Zastawa stołowa to:",
    6: "Normy prawne obowiązują:",
    7: "Protokół dyplomatyczny obowiązuje: ",
    8: "Przystawka do obiadu to:",
    9: "Kiedy źle postąpiliśmy mówimy:",
    10: "Kiedy chcemy coś otrzymać mówimy:"
  }


  var answers = {
    1: {
      0: ['Ustalone sposoby postępowania', 'Sposoby konserwacji urządzeń', 'Spis czynności, które wykonujesz w czasie pracy '],
      1: ['ustalone_sposoby.wav', 'sposoby_konserwacji.wav', 'spis_czynnosci.wav'],
      2: ['pilka_golfowa.png']
    },
    2: {
      0: ['Przepisy kulinarne', 'Poradnik dobrego zachowania', 'Instrukcja obsługi sokowirówki'],
      1: ['przepisy_kulinarne.wav', 'poradnik_dobrego_zach.wav', 'instrukcja_obslugi_sok.wav'],
      2: ['pilka_siatkowa.png']
    },
    3: {
      0: ['Obrus', 'Karta dań', ' książka kucharska '],
      1: ['obrus.wav', 'karta_dan.wav', 'ksiazka_kuch.wav'],
      2: ['pilkatenisowa.png']
    },
    4: {
      0: [ 'Talerze', 'Drewniane kije', 'Przybory służące do jedzenia '],
      1: ['talerze.wav', 'drewniane_kije.wav', 'przybory_sl_do.wav'],
      2: ['baseball.png']
    },
    5: {
      0: ['Zastawiony pokój', 'Stołówka szkolna ', 'Naczynia i sztućce '],
      1: ['zastawiony_pokoj.wav', 'stolowka_szkolna.wav', 'naczynia_i_sztucce.wav'],
      2: ['rugby.png']
    },
    6: {
      0: ['Wszystkich', 'Kobiety', 'Dzieci'],
      1: ['wszystkich.wav', 'kobiety.wav', 'dzieci.wav'],
      2: ['pilka_do_pingponga.png']
    },
    7: {
      0: ['Rodziców', 'Polityków', 'Turystów'],
      1: ['rodzicow.wav', 'politykow.wav', 'turystow.wav'],
      2: ['krazek_hokejowy.jpg']
    },
    8: {
      0: ['Dostawione krzesło', 'Danie podawane przed obiadem', 'Danie podawane po obiedzie '],
      1: ['dostawione_krzeslo.wav', 'danie_podawane_przed.wav', 'danie_podawane_po.wav'],
      2: ['pilka_reczna.jpg']
    },
    9: {
      0: ['Dziękuję', 'Proszę', 'Przepraszam'],
      1: ['dziekuje.wav', 'prosze.wav', 'przepraszam.wav'],
      2: ['pilka_do_kosza.png']
    },
    10: {
      0: ['Dziękuję', 'Proszę', 'Przepraszam'],
      1: ['dziekuje.wav', 'prosze.wav', 'przepraszam.wav'],
      2: ['pilka_nozna.png']
    }
  }

  var answerAudios = []

  var correctAnswerIndexes = {
    1: [1],
    2: [2],
    3: [2],
    4: [3],
    5: [3],
    6: [1],
    7: [2],
    8: [2],
    9: [3],
    10: [2]

  }

  var questionsFinished = []

  var answered = {
    1: [],
    2: [],
    3: [],
    4: [],
    5: [],
    6: [],
    7: [],
    8: [],
    9: [],
    10: []
  }

// MAIN LOGIC

  $( '.question-number' ).html( questionNumber );
  $( '.question-sum' ).html( noOfQuestions );
  $( '.question-text' ).html( questions[questionNumber] );

  $( 'body' ).on('click', '.next-question', function(event){
    event.preventDefault()
    if(questionNumber < noOfQuestions){
      questionNumber++;
      setPageDataForQuestion()
    }
    $('#modalCorrectAnswer').modal('hide')
  });

  $( '.prev-question' ).on('click', function(event){
    event.preventDefault()
    if(questionNumber > 1){
      questionNumber--;
      setPageDataForQuestion()
    }
  });

  $('.answer-audio').on('click', function(event){
    event.preventDefault();
    event.stopPropagation();
    var answerNo = parseInt($(this).attr('data-answer-no'));
    answerAudios[answerNo-1].play();
  })

  $( '.answer-button' ).on('click', function(event) {
    event.preventDefault()
    $('.wrong-answer').removeClass('wrong-answer')
    $('.last-answer').removeClass('last-answer')
    $(this).addClass('last-answer')
    var answerNo = parseInt($(this).attr('data-answer-no'))
    answered[questionNumber].push(answerNo)
    if(correctAnswerIndexes[questionNumber].indexOf(answerNo) !== -1) {
      $(this).addClass('correct-answer')
      badAnswerAudio.load()
      goodAnswerAudio.play()

      if(_.uniq(_.intersection(correctAnswerIndexes[questionNumber], answered[questionNumber])).length == correctAnswerIndexes[questionNumber].length) {

        //all correct answers selected
        if(questionsFinished.indexOf(questionNumber) == -1){
          questionsFinished.push(questionNumber)
        }
        if(!(questionsFinished.length === noOfQuestions)){
          if(questionNumber < noOfQuestions){
            showCorrectAnswerModal()
          }
        } else {
          fillEndModalAndShowIt()
        }

      }
    } else {
      goodAnswerAudio.load()
      badAnswerAudio.play()
      $(this).addClass('wrong-answer')
    }
  });

  $('.read-question').on('click', function(event) {
    event.preventDefault()
    questionAudio.play()
  })

  $('.check-answer').on('click', function(event) {
    event.preventDefault()
    $('.is-correct').toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500)
  })

  var setPageDataForQuestion = function() {
    $( '.question-number' ).html(questionNumber );
    $( '.question-text' ).html(questions[questionNumber] );
    $( '.question-image').html('')

    // questionAudio = new Audio('../files/audio/maly-dyplomata/quiz/polecenie' + questionNumber + '.wav');

    if(questionTypes[questionNumber-1] === 'image'){
      setAnswerButtonsForImage()
    } else if(questionTypes[questionNumber-1] === 'text') {
      setAnswerButtonsForText()
    } else if(questionTypes[questionNumber-1] === 'text') {
      setAnswerButtonsForText()
      setImageForQuestion()
    }
    setAnswerAudiosButtons()
    if(questionNumber == noOfQuestions) {
      $( '.next-question' ).addClass('disabled')
    } else {
      $( '.next-question' ).removeClass('disabled');
    };
    if(questionNumber == 1) {
      $( '.prev-question' ).addClass('disabled');
    } else {
      $( '.prev-question' ).removeClass('disabled');
    }
    $('.wrong-answer').removeClass('wrong-answer')
    $('.last-answer').removeClass('last-answer')
  }

  var setAnswerAudiosButtons = function() {
    for (i = 0; i < 7; i++) {
      button = $('.answer-audio.aa-' + (i+1), '.answer-audios')
      if(answers[questionNumber][0][i]){
        $(button).removeClass('hide')
      } else {
        $(button).addClass('hide')
      }
    }
  }

  var setAnswerButtonsForText = function() {
    $('.answer-buttons-img').hide();
    $('.answer-buttons-txt').show();
    $('.answer-button').removeClass('is-correct')

    for (i = 0; i < 7; i++) {
      button = $('.answer-button.ab-' + (i+1), '.answer-buttons-txt')

      if(correctAnswerIndexes[questionNumber].indexOf(i+1) != -1){
        $(button).addClass('is-correct')
      }

      if(answers[questionNumber][0][i]){
        $(button).removeClass('hide')
        if(answered[questionNumber].indexOf(i+1) !== -1 && correctAnswerIndexes[questionNumber].indexOf(i+1) !== -1) {
          $(button).addClass('correct-answer')
        } else {
          $(button).removeClass('correct-answer')
        }
        $( '.text', $('a', button) ).html(answers[questionNumber][0][i]);
      } else {
        $(button).addClass('hide')
      }
    }
    setAnswerAudios(1)
  }

  var setImageForQuestion = function () {
    $( '.question-image').html('<img src="../files/img/maly-dyplomata/quiz/' + answers[questionNumber][2] + '">')
  }

  var setAnswerButtonsForImage = function() {
    $('.answer-buttons-txt').hide();
    $('.answer-buttons-img').show();
    $('.answer-button').removeClass('is-correct')
    for (i = 0; i < 7; i++) {
      button = $('.answer-button.ab-' + (i+1), '.answer-buttons-img')

      if(correctAnswerIndexes[questionNumber].indexOf(i+1) != -1){
        $(button).addClass('is-correct')
      }

      if(answers[questionNumber][1][i]){
        $(button).removeClass('hide')
        if(answered[questionNumber].indexOf(i+1) !== -1 && correctAnswerIndexes[questionNumber].indexOf(i+1) !== -1) {
          $(button).addClass('correct-answer')
        } else {
          $(button).removeClass('correct-answer')
        }
        $( '.button-image', button ).attr('src', '../files/img/maly-dyplomata/quiz/' + answers[questionNumber][1][i]);
        $( '.button-footer', button ).text(answers[questionNumber][0][i]);
      } else {
        $(button).addClass('hide')
      }
    }
    setAnswerAudios(2)
  }

  var setAnswerAudios = function(index){
    answerAudios = []
    for (i = 0; i < answers[questionNumber][index].length; i++) {
      answerAudios.push(new Audio('../files/audio/maly-dyplomata/quiz/' + answers[questionNumber][index][i]))
    }
  }

  var fillEndModalAndShowIt = function() {
    var tableBodyHtml = '';
    var i = 1;
    _.each(answered, function(yourAnswers){
      var yourAnswerTexts = []
      _.each(yourAnswers, function(answer) {
        if(correctAnswerIndexes[i].indexOf(answer) != -1){
          yourAnswerTexts.push('<span class="text-success">' + answers[i][0][answer-1] + '</span>')
        } else {
          yourAnswerTexts.push('<span class="text-danger">' + answers[i][0][answer-1] + '</span>')
        }
      })
      tableBodyHtml+='<tr><td>' + i + '</td><td>' + yourAnswers.length + '</td><td>' + _.difference(yourAnswers, correctAnswerIndexes[i]).length + '</td><td>' + yourAnswerTexts.join(', ') + '</td></tr>'
      i+=1;
    })
    $('tbody', '#quizEndedModal').html(tableBodyHtml)
    $('#quizEndedModal').modal('show')
  }

  var showCorrectAnswerModal = function(){
    $('#modalCorrectAnswer').modal('show')
  }



  setPageDataForQuestion()

});
