$( document ).ready(function() {

  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/zwierzeta/gra-dopasuj/polecenie.wav');
  var noOfQuestions = 10
  var questionNumber = 1
  var goodAnswerIndexes = [1, 5, 9, 8, 3, 4, 7, 2, 6, 10]
  var answeredProperly = [false, false, false, false, false, false, false, false, false, false]
  var checkedAnswers = [false, false, false, false, false, false, false, false, false, false]
  var badAnswersCount = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0]

  var questionData = [
    ["bazgrać jak kura pazurem", 'bazgracjak.wav'],
    ["kura znosząca złote jaja", 'kuraznoszaca.wav'],
    ["budzi się w kimś lew", 'lew.wav'],
    ["z lotu ptaka", 'zlotu.wav'],
    ["dostać małpiego rozumu", 'dostacmalpiego.wav'],
    ["mieć muchy w nosie", 'miecmuchywnosie.wav'],
    ["mucha nie siada", 'muchaniesiada.wav'],
    ["talia osy", 'taliaosy.wav'],
    ["jak psu z gardła wyjęte", 'wyjetejak.wav'],
    ["spiec raka", 'spiecraka.wav']
  ]

  $( 'body' ).on('click', '.next-question', function(event){
    event.preventDefault()
    questionNumber++;
    if (questionNumber == noOfQuestions) {
      $('.next-question').addClass('disabled')
    }
    $('.prev-question').removeClass('disabled')
    setPageDataForQuestion()
  });

  $( '.prev-question' ).on('click', function(event){
    event.preventDefault()
    questionNumber--;
    setPageDataForQuestion()

    if (questionNumber == 1) {
      $('.prev-question').addClass('disabled')
    }
    $('.next-question').removeClass('disabled')
  });

  $('.check-answer').on('click', function(event){
    event.preventDefault()
    checkedAnswers[questionNumber-1] = true;
    $('a', '.answer-button[data-answer-no=' + goodAnswerIndexes[questionNumber-1] + ']').delay(500).addClass('good-answer-indicator', 300).delay(500).removeClass('good-answer-indicator', 300).delay(500).addClass('good-answer-indicator', 300).delay(500).removeClass('good-answer-indicator', 300).delay(500).addClass('good-answer-indicator', 300).delay(500).removeClass('good-answer-indicator', 300)
  })

  $('.read-question').on('click', function(event){
    event.preventDefault()
    questionAudio.play()
  })

  $('.read-question-helper').on('click', function(event){
    event.preventDefault()
    currentQuestionAudio.play()
  })

  $('.answer-button').on('click', function(e) {
    e.preventDefault()
    if (goodAnswerIndexes[questionNumber-1] == parseInt($(this).attr('data-answer-no'))) {
      answeredProperly[questionNumber-1] = true
      $('.wrong-answer').removeClass('wrong-answer')
      $('.correct-answer').removeClass('correct-answer')
      $(this).addClass('correct-answer')
      badAnswerAudio.load()
      goodAnswerAudio.play()
      checkIfEnded()
    } else {
      $('.correct-answer').removeClass('correct-answer')
      $('.wrong-answer').removeClass('wrong-answer')
      $(this).addClass('wrong-answer')
      badAnswersCount[questionNumber-1] += 1
      goodAnswerAudio.load()
      badAnswerAudio.play()
    }
  })


  checkIfEnded = function() {
    if (answeredProperly.indexOf(false) == -1) {
      // set modal data
      var tableBodyHtml = '';
      for (var i=1; i<=noOfQuestions; i++) {
        tableBodyHtml += '<tr><td>' + i + '</td><td>'
        if(badAnswersCount[i-1]) {
          tableBodyHtml += badAnswersCount[i-1]
        } else {
          tableBodyHtml += '0'
        }
        tableBodyHtml += '</td><td>'
        if(checkedAnswers[i-1]){
          tableBodyHtml += 'TAK'
        } else {
          tableBodyHtml += 'NIE'
        }
        tableBodyHtml += '</td>'
      }
      $('tbody', '#allEndedModal').html(tableBodyHtml)
      $('#allEndedModal').modal('show')
    } else {
      $('#modalCorrectAnswer').modal('show')
    }
  }

  setPageDataForQuestion = function() {
    $('h3', '.question-helper').html(questionData[questionNumber-1][0])
    currentQuestionAudio = new Audio('../files/audio/zwierzeta/gra-dopasuj/' + questionData[questionNumber-1][1])
    $('#modalCorrectAnswer').modal('hide')
    $('.correct-answer').removeClass('correct-answer')
    $('.wrong-answer').removeClass('wrong-answer')
  }

  setPageDataForQuestion()

})