$( document ).ready(function() {

  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/zwierzeta/policz-owce/polecenie.wav');

  var itemNumbers = [
    [[1,2,7], [3,4,5], [8,9,10]],
    [[1,2,7], [3,4,5], [8,9,10,12]],
    [[1,2], [3,4,5,6], [8,9,10,12]],
    [[1,2,7,11], [3,4,5,6], [8,9,10,12,14]],
    [[1,2,7,11,15], [3,4,5,6,13], [8,9,10,12,14]],
    [[1,2,7,11,15,17], [3,4,5,6,13], [8,9,10,12,14,16]]
  ]

  var possiblePlaces = [[1,2,7,11,15,17], [3,4,5,6,13], [8,9,10,12,14,16]]

  var usedIndexes = []
  var questionNumber = 1
  var noOfQuestions = 6
  var badAnswersCount = [0, 0, 0, 0, 0, 0]
  var answeredProperly = [false, false, false, false, false, false]
  var checkedAnswers = [false, false, false, false, false, false]
  var timeout = null
  var interval = null

  $('.btn-policz.start').on('click', function(event){
    event.preventDefault();
    $('.btn-policz.stop').click()
    prepareQuestionData()
    _.each(_.flatten(itemNumbers[questionNumber-1]), function(item) {
      $('.owca-' + item).removeClass('hidden')
    })
    var btn = this
    var properBtnHtml = $(this).html()
    var i = 5
    $('i', '.btn-policz.start').removeClass('fa-play').text(i)
    interval = setInterval(function() {
      i -= 1
      $('i', '.btn-policz.start').removeClass('fa-play').text(i)
    }, 1000)
    timeout = setTimeout(function(){
      clearInterval(interval)
      $('i', '.btn-policz.start').addClass('fa-play').text('')
      $('.img-owca:not(.hidden)').addClass('out', 600)
    }, 5000)
  })

  $('.btn-policz.stop').on('click', function(event){
    event.preventDefault();
    prepareQuestionData()
    if (timeout)
      clearTimeout(timeout)
    if (interval)
      clearInterval(interval)
    $('i', '.btn-policz.start').addClass('fa-play').text('')
  })

  $('body').on('click', '.img-owca.out:not(.used)', function() {
    $('.img-owca.selected').removeClass('selected')
    $(this).addClass('selected')
    addSheepToFarmIfShould()
    setTimeout(checkIfShouldFinish, 600)
  })

  $('body').on('click', '.zagroda', function() {
    $('.zagroda.selected').removeClass('selected')
    $(this).addClass('selected')
    addSheepToFarmIfShould()
    setTimeout(checkIfShouldFinish, 600)
  })

  addSheepToFarmIfShould = function() {
    if ($('.zagroda.selected').length > 0 && $('.img-owca.selected').length > 0) {
      var farmIndex = parseInt($('.zagroda.selected').attr('data-index'))
      var sheepSelected = $('.img-owca.selected')
      var indexToAdd = _.first(_.difference(possiblePlaces[farmIndex-1], usedIndexes))
      if (!indexToAdd) {
        indexToAdd = _.sample(possiblePlaces[farmIndex-1])
      }
      usedIndexes.push(indexToAdd)
      var oldClass = _.find(($(sheepSelected).attr('class').split(' ')), function(cl){
        return (cl.indexOf('owca-') != -1)
      })
      $(sheepSelected).attr('data-farm', farmIndex)
      $(sheepSelected).addClass('original-' + oldClass)
      $(sheepSelected).addClass('used').toggleClass(oldClass + ' out owca-' + indexToAdd, 500)
      $('.selected').removeClass('selected')
    }
  }

  checkIfShouldFinish = function() {
    if ($('.img-owca.out').length == 0) {
      var isCorrectAnswer = true
      for(var i=0; i<3; i++) {
        if ($('.img-owca[data-farm=' + (i+1) + ']').length != itemNumbers[questionNumber-1][i].length) {
          isCorrectAnswer = false
        }
      }
      if (isCorrectAnswer) {
        answeredProperly[questionNumber-1] = true
        if (answeredProperly.indexOf(false) != -1) {
          $('#modalCorrectAnswer').modal('show')
        } else {
          var tableBodyHtml = '';
          for (var i=1; i<=noOfQuestions; i++) {
            tableBodyHtml += '<tr><td>' + i + '</td><td>'
            if(badAnswersCount[i-1]) {
              tableBodyHtml += badAnswersCount[i-1]
            } else {
              tableBodyHtml += '0'
            }
            tableBodyHtml += '</td><td>'
            if(checkedAnswers[i-1]){
              tableBodyHtml += 'TAK'
            } else {
              tableBodyHtml += 'NIE'
            }
            tableBodyHtml += '</td>'
          }
          $('tbody', '#allEndedModal').html(tableBodyHtml)
          $('#allEndedModal').modal('show')
        }
        badAnswerAudio.load()
        goodAnswerAudio.play()
      } else {
        badAnswersCount[questionNumber-1] += 1
        $('#modalWrongAnswer').modal('show')
        goodAnswerAudio.load()
        badAnswerAudio.play()
      }
    }
  }

  prepareQuestionData = function() {
    $('input.ring').val('')
    $('.img-owca').addClass('hidden').removeClass('out one two three used').each(function() {
      var properClass = _.find(($(this).attr('class').split(' ')), function(cl){
        return (cl.indexOf('original-') != -1)
      })
      if (properClass && properClass.length > 0) {
        properClass = properClass.split('original-')[1]
        $(this).removeClass('original-' + properClass)
        var classToRemove = _.find(($(this).attr('class').split(' ')), function(cl){
          return (cl.indexOf('owca-') != -1)
        })
      }
      $(this).removeClass(classToRemove).addClass(properClass).attr('data-farm', null)
    })
    usedIndexes = []
    $('#modalWrongAnswer').modal('hide')
    $('#modalCorrectAnswer').modal('hide')

    if (answeredProperly[questionNumber-1]) {
      $('input.ring-1').val(itemNumbers[questionNumber-1][0].length)
      $('input.ring-2').val(itemNumbers[questionNumber-1][1].length)
      $('input.ring-3').val(itemNumbers[questionNumber-1][2].length)
      _.each(_.flatten(itemNumbers[questionNumber-1]), function(item) {
        $('.owca-' + item).removeClass('hidden')
      })
    }
  }

  $('.read-question').on('click', function(event){
    event.preventDefault()
    questionAudio.play()
  })

  $('.reset').on('click', function(e){
    e.preventDefault()
    $('#modalWrongAnswer').modal('hide')
    prepareQuestionData()
    $('.btn-policz.start').click()
  })

  $( 'body' ).on('click', '.next-question', function(event){
    event.preventDefault()
    questionNumber++;
    if (questionNumber == noOfQuestions) {
      $('.next-question').addClass('disabled')
    }
    $('.prev-question').removeClass('disabled')
    prepareQuestionData()
  });

  $( '.prev-question' ).on('click', function(event){
    event.preventDefault()
    questionNumber--;
    prepareQuestionData()

    if (questionNumber == 1) {
      $('.prev-question').addClass('disabled')
    }
    $('.next-question').removeClass('disabled')
  });

  $('.check-answer').on('click', function(event){
    event.preventDefault()
    $('input.ring-1').val(itemNumbers[questionNumber-1][0].length)
    $('input.ring-2').val(itemNumbers[questionNumber-1][1].length)
    $('input.ring-3').val(itemNumbers[questionNumber-1][2].length)
    checkedAnswers[questionNumber-1] = true
  })

  prepareQuestionData()

})