$( document ).ready(function() {

// DATA
  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/zwierzeta/angielski/polecenie1.wav');

  var questionNumber = 1;
  var roundNumber = 1;
  var noOfQuestions = [1,6,6];

  var answerAudios = {
    1: {
      0: [new Audio('../files/audio/zwierzeta/angielski/lama.wav'), new Audio('../files/audio/zwierzeta/angielski/cat.wav'), new Audio('../files/audio/zwierzeta/angielski/wild-boar.wav'), new Audio('../files/audio/zwierzeta/angielski/fox.wav'), new Audio('../files/audio/zwierzeta/angielski/hen.wav'), new Audio('../files/audio/zwierzeta/angielski/deer.wav')],
      1: [new Audio('../files/audio/zwierzeta/angielski/parrot.wav'), new Audio('../files/audio/zwierzeta/angielski/cow.wav'), new Audio('../files/audio/zwierzeta/angielski/pig.wav'), new Audio('../files/audio/zwierzeta/angielski/tiger.wav'), new Audio('../files/audio/zwierzeta/angielski/giraffe.wav'), new Audio('../files/audio/zwierzeta/angielski/dog.wav')]
    },
    2: [ new Audio('../files/audio/zwierzeta/angielski/hen.wav'), new Audio('../files/audio/zwierzeta/angielski/cow.wav'), new Audio('../files/audio/zwierzeta/angielski/cat.wav'), new Audio('../files/audio/zwierzeta/angielski/giraffe.wav'), new Audio('../files/audio/zwierzeta/angielski/tiger.wav'), new Audio('../files/audio/zwierzeta/angielski/dog.wav')  ],
    3: [ new Audio('../files/audio/zwierzeta/angielski/dog.wav'), new Audio('../files/audio/zwierzeta/angielski/pig.wav'), new Audio('../files/audio/zwierzeta/angielski/hen.wav'), new Audio('../files/audio/zwierzeta/angielski/cow.wav'), new Audio('../files/audio/zwierzeta/angielski/tiger.wav'), new Audio('../files/audio/zwierzeta/angielski/parrot.wav'),  ]
  }

  var round2Images = {
    1: ['lama.jpg', 'hen.jpg', 'deer.jpg', 'pig.jpg', 'tiger.jpg', 'dog.jpg'],
    2: ['parrot.jpg', 'cow.jpg', 'giraffe.jpg', 'dog.jpg', 'lama.jpg', 'cat.jpg'],
    3: ['dog.jpg', 'cat.jpg', 'wild-boar.jpg', 'fox.jpg', 'hen.jpg', 'pig.jpg'],
    4: ['pig.jpg', 'tiger.jpg', 'giraffe.jpg', 'dog.jpg', 'fox.jpg', 'hen.jpg'],
    5: ['deer.jpg', 'parrot.jpg', 'cow.jpg', 'pig.jpg', 'tiger.jpg', 'giraffe.jpg'],
    6: ['cat.jpg', 'wild-boar.jpg', 'cow.jpg', 'pig.jpg', 'tiger.jpg', 'dog.jpg']
  }
  var round2Answers = [2,2,2,3,5,6]
  var round2UserAnswers = {
    1: [],
    2: [],
    3: [],
    4: [],
    5: [],
    6: []
  }

  var round2CheckedAnswers = [false, false, false, false, false, false]


  var round3 = [
    {
      0: 'dog.jpg',
      1: ['cow', 'giraffe', 'dog']
    },
    {
      0: 'pig.jpg',
      1: ['wild boar', 'cow', 'pig']
    },
    {
      0: 'hen.jpg',
      1: ['fox', 'hen', 'giraffe']
    },
    {
      0: 'cow.jpg',
      1: ['lama', 'cat', 'cow']
    },
    {
      0: 'tiger.jpg',
      1: ['tiger', 'giraffe', 'dog']
    },
    {
      0: 'parrot.jpg',
      1: ['parrot', 'dog', 'lama']
    }
  ]
  var round3Answers = [3,3,2,3,1,1]
  var round3UserAnswers = {
    1: [],
    2: [],
    3: [],
    4: [],
    5: [],
    6: []
  }

  var round3CheckedAnswers = [false, false, false, false, false, false]


// MAIN LOGIC

  $('.next-round').on('click', function(){
    roundNumber += 1;
    $('.round-' + (roundNumber-1)).addClass('hidden')
    $('.round-' + roundNumber).removeClass('hidden')
    if(roundNumber == 3){
      $('.next-round').addClass('disabled')
    }
    $('.prev-round').removeClass('disabled')
    $( '.round-number' ).html( roundNumber );
    $('#round2EndedModal').modal('hide')
    questionNumber = 1;
    if(roundNumber == 2) {
      round2prepareCurrentQuestionData()
      questionAudio = new Audio('../files/audio/zwierzeta/angielski/polecenie2.wav');
    } else {
      if(roundNumber == 3){
        round3prepareCurrentQuestionData()
        questionAudio = new Audio('../files/audio/zwierzeta/angielski/polecenie3.wav');
      }
    }
  })

  $('.prev-round').on('click', function(){
    roundNumber -= 1;
    $('.round-' + (roundNumber+1)).addClass('hidden')
    $('.round-' + roundNumber).removeClass('hidden')

    if(roundNumber == 1){
      $('.prev-round').addClass('disabled')
    }
    $('.next-round').removeClass('disabled')
    $( '.round-number' ).html( roundNumber );
    questionNumber = 1;
    if(roundNumber == 2) {
      round2prepareCurrentQuestionData()
    } else {
      if(roundNumber == 3){
        round3prepareCurrentQuestionData()
        questionAudio = new Audio('../files/audio/zwierzeta/angielski/polecenie3.wav');
      }
    }
  })

// first round

  $('.answer-audio', '.answer-audios-1').on('click', function(event){
    event.preventDefault();
    event.stopPropagation();
    var answerNo = parseInt($(this).attr('data-answer-no'));
    answerAudios[1][0][answerNo-1].play();
  })

  $('.answer-audio', '.answer-audios-2').on('click', function(event){
    event.preventDefault();
    event.stopPropagation();
    var answerNo = parseInt($(this).attr('data-answer-no'));
    answerAudios[1][1][answerNo-1].play();
  })


// second round
  var round2prepareCurrentQuestionData = function() {
    $('.answer-button', '.round-2').removeClass('correct-answer-2').removeClass('wrong-answer-2')
    $('.button-image', $('.answer-buttons', '.round-2')).each(function(index){
      $(this).attr('src', '../files/img/zwierzeta/angielski/' + round2Images[questionNumber][index])
      if(index+1 == round2Answers[questionNumber-1] && round2UserAnswers[questionNumber].indexOf(index+1) != -1){
        $(this).parents('.answer-button').addClass('correct-answer-2')
      }
    })
  }

  var checkIfShouldFinishRound2 = function() {
    var allAnsweredCorrectly = true;
    for(var i=0; i<round2Answers.length; i++) {
      if(round2UserAnswers[i+1].indexOf(round2Answers[i]) == -1) {
        allAnsweredCorrectly = false
      }
    }
    if(allAnsweredCorrectly) {
      var tableBodyHtml = '';
      for (var i=1; i<=round2Answers.length; i++) {
        tableBodyHtml += '<tr><td>' + i + '</td><td>'
        if(_.without(round2UserAnswers[i], round2Answers[i-1]).length > 0) {
          tableBodyHtml += _.without(round2UserAnswers[i], round2Answers[i-1]).length
          // + ' (' + _.without(round2UserAnswers[i], round2Answers[i-1]).join(', ') + ')'
        } else {
          tableBodyHtml += '0'
        }
        tableBodyHtml += '</td><td>'
        if(round2CheckedAnswers[i-1]){
          tableBodyHtml += 'TAK'
        } else {
          tableBodyHtml += 'NIE'
        }
        tableBodyHtml += '</td>'
      }
      $('tbody', '#round2EndedModal').html(tableBodyHtml)
      $('#round2EndedModal').modal('show')
    } else {
      $('#modalCorrectAnswer').modal('show')
    }
  }

  $('.read-answer').on('click', function(event){
    event.preventDefault()
    answerAudios[roundNumber][questionNumber-1].play()
  })

  $( '.next-question', '.round-2' ).on('click', function(event){
    event.preventDefault()
    if($(this).parents('round-2')){
      if(questionNumber < noOfQuestions[1]){
        questionNumber++;
        round2prepareCurrentQuestionData()
        if(questionNumber == noOfQuestions[1]){
          $('.next-question', '.round-2').addClass('disabled')
        }
        $('.prev-question', '.round-2').removeClass('disabled')
      }
      $('#modalCorrectAnswer').modal('hide')
    }
  });

  $( '.prev-question', '.round-2' ).on('click', function(event){
    event.preventDefault()
    console.log($(this))
    if(questionNumber > 1){
      questionNumber--;
      round2prepareCurrentQuestionData()
      if(questionNumber == 1){
        $('.prev-question', '.round-2').addClass('disabled')
      }
      $('.next-question', '.round-2').removeClass('disabled')
    }
  });

  $('.answer-button', '.round-2').on('click', function(event){
    event.preventDefault();
    round2UserAnswers[questionNumber].push(parseInt($(this).attr('data-answer-no')))
    $('.answer-button', '.round-2').removeClass('wrong-answer-2')
    if(parseInt($(this).attr('data-answer-no')) == round2Answers[questionNumber-1]){
      $(this).addClass('correct-answer-2')
      checkIfShouldFinishRound2()
      badAnswerAudio.load()
      goodAnswerAudio.play()
    } else {
      $(this).addClass('wrong-answer-2')
      goodAnswerAudio.load()
      badAnswerAudio.play()
    }
  })

  $('.check-answer', '.round-2').on('click', function(event) {
    event.preventDefault()
    round2CheckedAnswers[questionNumber-1] = true
    $('.answer-button[data-answer-no=' + round2Answers[questionNumber-1] + ']', '.round-2').toggleClass('correct-answer-2', 500).delay(500).toggleClass('correct-answer-2', 500).delay(500).toggleClass('correct-answer-2', 500).delay(500).toggleClass('correct-answer-2', 500).delay(500).toggleClass('correct-answer-2', 500).delay(500).toggleClass('correct-answer-2', 500)
  })

  $( '.round-number' ).html( roundNumber );

// third round

  var round3prepareCurrentQuestionData = function() {
    $('.answer-button', '.round-3').removeClass('correct-answer').removeClass('wrong-answer')
    $('.text-thumb', $('.answer-buttons', '.round-3')).each(function(index){
      $(this).html(round3[questionNumber-1][1][index])
      if(index+1 == round3Answers[questionNumber-1] && round3UserAnswers[questionNumber].indexOf(index+1) != -1){
        $(this).parents('.answer-button').addClass('correct-answer')
      }
    })
    $('.button-image', '.round-3').attr('src', '../files/img/zwierzeta/angielski/' + round3[questionNumber-1][0])
  }

  var checkIfShouldFinishRound3 = function() {
    var allAnsweredCorrectly = true;
    for(var i=0; i<round3Answers.length; i++) {
      if(round3UserAnswers[i+1].indexOf(round3Answers[i]) == -1) {
        allAnsweredCorrectly = false
      }
    }
    if(allAnsweredCorrectly) {
      var tableBodyHtml = '';
      for (var i=1; i<=round3Answers.length; i++) {
        tableBodyHtml += '<tr><td>' + i + '</td><td>'
        if(_.without(round3UserAnswers[i], round3Answers[i-1]).length > 0) {
          tableBodyHtml += _.without(round3UserAnswers[i], round3Answers[i-1]).length
          // + ' (' + _.without(round2UserAnswers[i], round2Answers[i-1]).join(', ') + ')'
        } else {
          tableBodyHtml += '0'
        }
        tableBodyHtml += '</td><td>'
        if(round3CheckedAnswers[i-1]){
          tableBodyHtml += 'TAK'
        } else {
          tableBodyHtml += 'NIE'
        }
        tableBodyHtml += '</td>'
      }
      $('tbody', '#round3EndedModal').html(tableBodyHtml)
      $('#round3EndedModal').modal('show')
    } else {
      $('#modalCorrectAnswer').modal('show')
    }
  }

  $('.read-question').on('click', function(event){
    event.preventDefault()
    questionAudio.play()
  })

  $( '.next-question', '.round-3' ).on('click', function(event){
    event.preventDefault()
    if(questionNumber < noOfQuestions[2]){
      questionNumber++;
      round3prepareCurrentQuestionData()
      if(questionNumber == noOfQuestions[2]){
        $('.next-question', '.round-3').addClass('disabled')
      }
      $('.prev-question', '.round-3').removeClass('disabled')
    }
    $('#modalCorrectAnswer').modal('hide')
  });

  $( '.prev-question', '.round-3' ).on('click', function(event){
    event.preventDefault()
    if(questionNumber > 1){
      questionNumber--;
      round3prepareCurrentQuestionData()
      if(questionNumber == 1){
        $('.prev-question', '.round-3').addClass('disabled')
      }
      $('.next-question', '.round-3').removeClass('disabled')
    }
    $('#modalCorrectAnswer').modal('hide')
  });

  $('.answer-button', '.round-3').on('click', function(event){
    event.preventDefault();
    round3UserAnswers[questionNumber].push(parseInt($(this).attr('data-answer-no')))
    $('.answer-button', '.round-3').removeClass('wrong-answer')
    if(parseInt($(this).attr('data-answer-no')) == round3Answers[questionNumber-1]){
      $(this).addClass('correct-answer')
      checkIfShouldFinishRound3()
      badAnswerAudio.load()
      goodAnswerAudio.play()
    } else {
      $(this).addClass('wrong-answer')
      goodAnswerAudio.load()
      badAnswerAudio.play()
    }
  })

  $('.check-answer', '.round-3').on('click', function(event) {
    event.preventDefault()
    round3CheckedAnswers[questionNumber-1] = true
    $('.answer-button[data-answer-no=' + round3Answers[questionNumber-1] + ']', '.round-3').toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500)
  })



});
