$( document ).ready(function() {

  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/moda/dzielenie_elementow/polecenie.wav');
  var badAnswersCount = 0
  var goodAnswers = [[4,6,7,8], [1,2,3], [5,9,10]]

  // $('.check-answer').on('click', function(event){
  //   event.preventDefault()
  //   $('.is-correct', '.question-' + questionNumber).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500)
  //   checkedAnswers[questionNumber-1] = true
  // })

  $('.read-question').on('click', function(event){
    event.preventDefault()
    questionAudio.play()
  })

  $('.answer-button', '.people').on('click', function(event) {
    event.preventDefault()
    event.stopPropagation()
    if( $('.thumbnail', this).hasClass('selected') ){
      $('.thumbnail', this).removeClass('selected')
    } else {
      $('.thumbnail', '.people').removeClass('selected')
      $('.thumbnail', this).addClass('selected')
    }
    applyAnswerIfShould()
  })

  $('.answer-button', '.possible-answers').not('.used').on('click', function(event) {
    event.preventDefault()
    event.stopPropagation()
    if( !$(this).hasClass('used') ){
      if( $('.thumbnail', this).hasClass('selected') ){
        $('.thumbnail', this).removeClass('selected')
      } else {
        $('.thumbnail', '.possible-answers').removeClass('selected')
        $('.thumbnail', this).addClass('selected')
      }
      applyAnswerIfShould()
    }
  })

  applyAnswerIfShould = function() {
    selectedPerson = $('.selected', '.people')
    selectedAnswer = $('.selected', '.possible-answers')
    if( selectedPerson.length > 0 && selectedAnswer.length > 0 ) {
      $('.answers', $(selectedPerson).parents('.answer-container')).append('<div class="col-md-6 col-sm-6 col-xs-6 answered" data-answer-no="' + $(selectedAnswer).parents('.answer-button').attr('data-answer-no') + '"><div class="dummy"></div><div class="thumbnail"><img class="button-image" src="' + $('img', selectedAnswer).attr('src') + '" style="max-height: 100%;"></div></div>')
      $(selectedAnswer).parents('.answer-button').addClass('used').addClass('disabled')
      $(selectedAnswer).removeClass('selected')
      $(selectedPerson).removeClass('selected')
      checkIfEnded()
    }
  }

  checkIfEnded = function() {
    var answeredBadly = false
    if( $('.answer-button', '.possible-answers').not('.used').length == 0 ) {
      $('.answer-container', '.people').each(function(index){
        var container = this
        $('.answered', container).each(function(){
          if (goodAnswers[index].indexOf(parseInt($(this).attr('data-answer-no'))) == -1){
            answeredBadly = true
          }
        })
      })
      if (answeredBadly) {
        goodAnswerAudio.load()
        badAnswerAudio.play()
        badAnswersCount += 1
        $('#modalWrongAnswer').modal('show')
      } else {
        badAnswerAudio.load()
        goodAnswerAudio.play()
        $('.bad-answer-count', '#allEndedModal').html(badAnswersCount)
        $('#allEndedModal').modal('show')
      }
    }
  }

  $('.clear').on('click', function(event){
    event.preventDefault()
    $('#modalWrongAnswer').modal('hide')
    $('.answers').html('')
    $('.used').removeClass('used').removeClass('disabled')
  })

})