$( document ).ready(function() {

  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/moda/policz/polecenie.wav');

  var goodAnswers = [11, 12, 18, 17, 20, 21]
  var noOfItems = [3, 3, 4, 4, 5, 5]
  var questionNumber = 1
  var noOfQuestions = 6
  var answers = [ [], [], [], [], [], [] ]
  var checkedAnswers = [false, false, false, false, false, false]
  var timeouts = []

  drawDroppingToBasket = function(item, index){
    timeouts[index] = setTimeout(function(){
      $(item).addClass('bottom', 3000);
      if( index == noOfItems[questionNumber-1]-1 ){
        setTimeout(function(){
          $('.answer').removeClass('hidden');
          $('.answer-count').val('')
          $('.answer-count').focus()
          $('.answer').removeClass('correct-answer')
          $('.answer').removeClass('wrong-answer')
        }, 3000)
      }
    }, index*3000)
  }

  $('.btn-policz.start').on('click', function(event){
    event.preventDefault();
    $('.answer').addClass('hidden');
    $('.count-container').removeClass('bottom');
    $('.count-container.question-' + questionNumber).each(function(index){
      drawDroppingToBasket(this, index)
    })
  })

  $('.btn-policz.stop').on('click', function(event){
    _.each(timeouts, function(item){
      clearTimeout(item)
    })
    $('.count-container').removeClass('bottom');
    $('.answer').removeClass('hidden');
    $('.answer-count').val('')
    $('.answer-count').focus()
    $('.answer').removeClass('correct-answer')
    $('.answer').removeClass('wrong-answer')
  })

  $('.check-answer').on('click', function(event){
    event.preventDefault()
    $('.answer-count').val(goodAnswers[questionNumber-1])
    $('.answer').removeClass('hidden')
    $('.check-my-answer').click()
    checkedAnswers[questionNumber-1] = true
  })

  $('.read-question').on('click', function(event){
    event.preventDefault()
    questionAudio.play()
  })

  $('.next-question').on('click', function(event){
    event.preventDefault();
    questionNumber+=1;
    if(noOfQuestions == questionNumber){
      $('.next-question').addClass('disabled');
    };
    $('.prev-question').removeClass('disabled');
    $('.question-number').html(questionNumber);
    if( answers[questionNumber-1] && answers[questionNumber-1].indexOf(goodAnswers[questionNumber-1]) == -1 ) {
      $('.answer').addClass('hidden')
      $('#modalCorrectAnswer').modal('hide')
    } else {
      $('.answer').removeClass('hidden').addClass('correct-answer')
      $('.answer-count').val(goodAnswers[questionNumber-1])
      $('#modalCorrectAnswer').modal('hide')
    }
  })

  $('.prev-question').on('click', function(event){
    event.preventDefault();
    questionNumber-=1;
    if(1 == questionNumber){
      $('.prev-question').addClass('disabled');
    };
    $('.next-question').removeClass('disabled');
    $('.question-number').html(questionNumber);
    $('.answer').addClass('hidden')
    $('#modalCorrectAnswer').modal('hide')
  })

  $('.check-my-answer').on('click', function(event){
    event.preventDefault();
    answered = parseInt($('.answer-count').val())
    if( answered == goodAnswers[questionNumber-1] ) {
      badAnswerAudio.load();
      goodAnswerAudio.play();
      $('.answer').addClass('correct-answer')
      $('.answer').removeClass('wrong-answer')
      answers[questionNumber-1].push(answered)
      showProperModal()
    } else {
      goodAnswerAudio.load();
      badAnswerAudio.play();
      $('.answer').addClass('wrong-answer')
      $('.answer').removeClass('correct-answer')
      answers[questionNumber-1].push(answered)
    }
  })

  showFinishModal = function() {
    var tableBodyHtml = '';
    for (var i=0; i<noOfQuestions; i++) {
      tableBodyHtml += '<tr><td>' + (i+1) + '</td><td>'
      badAnswers = _.without(answers[i], goodAnswers[i])
      if(badAnswers.length > 0) {
        tableBodyHtml += badAnswers.length + ' (' + badAnswers.join(', ') + ')'
      } else {
        tableBodyHtml += '0'
      }
      tableBodyHtml += '</td><td>'
      if(checkedAnswers[i]){
        tableBodyHtml += 'TAK'
      } else {
        tableBodyHtml += 'NIE'
      }
      tableBodyHtml += '</td>'
    }
    $('tbody', '#countEndedModal').html(tableBodyHtml)
    $('#countEndedModal').modal('show')
  }

  showProperModal = function() {
    allAnsweredProperly = true;
    var i = 0;
    _.each(answers, function(questionAnswers){
      if( questionAnswers.indexOf(goodAnswers[i]) == -1 ){
        allAnsweredProperly = false;
      }
      i+=1;
    })
    if( allAnsweredProperly ) {
      showFinishModal()
    } else {
      $('#modalCorrectAnswer').modal('show')
    }
  }

  $('.question-number').html(questionNumber);
  $('.question-sum').html(noOfQuestions);
  $('.question-text').html('W sklepie odzieżowym była wielka wyprzedaż. Można bardzo tanio kupić ubrania, ale trzeba to robić bardzo szybko. ile trzeba zapłacić za ubrania w koszyku?');


})