$( document ).ready(function() {

// DATA
  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/moda/angielski/polecenie1.wav');

  var questionNumber = 1;
  var roundNumber = 1;
  var noOfQuestions = [1,6,6];

  var answerAudios = {
    1: {
      0: [new Audio('../files/audio/moda/angielski/t-shirt.wav'), new Audio('../files/audio/moda/angielski/shirt.wav'), new Audio('../files/audio/moda/angielski/trousers.wav'), new Audio('../files/audio/moda/angielski/skirt.wav'), new Audio('../files/audio/moda/angielski/dress.wav'), new Audio('../files/audio/moda/angielski/sweater.wav')],
      1: [new Audio('../files/audio/moda/angielski/socks.wav'), new Audio('../files/audio/moda/angielski/vest.wav'), new Audio('../files/audio/moda/angielski/hat.wav'), new Audio('../files/audio/moda/angielski/scarf.wav'), new Audio('../files/audio/moda/angielski/gloves.wav'), new Audio('../files/audio/moda/angielski/sweatshirt.wav')]
    },
    2: [ new Audio('../files/audio/moda/angielski/skirt.wav'), new Audio('../files/audio/moda/angielski/scarf.wav'), new Audio('../files/audio/moda/angielski/t-shirt.wav'), new Audio('../files/audio/moda/angielski/dress.wav'), new Audio('../files/audio/moda/angielski/socks.wav'), new Audio('../files/audio/moda/angielski/gloves.wav'),  ],
    3: [ new Audio('../files/audio/moda/angielski/gloves.wav'), new Audio('../files/audio/moda/angielski/hat.wav'), new Audio('../files/audio/moda/angielski/socks.wav'), new Audio('../files/audio/moda/angielski/trousers.wav'), new Audio('../files/audio/moda/angielski/dress.wav'), new Audio('../files/audio/moda/angielski/skirt.wav')  ]
  }

  var round2Images = {
    1: ['spodnica.jpg', 'sukienka.jpg', 'sweter.jpg', 'skarpetki.jpg', 'kamizelka.jpg', 'bluza.jpg'],
    2: ['spodnie.jpg', 'spodnica.jpg', 'koszulka.jpg', 'koszula.jpg', 'szalik.jpg', 'sweter.jpg'],
    3: ['sweter.jpg', 'skarpetki.jpg', 'kamizelka.jpg', 'czapka.jpg', 'szalik.jpg', 'koszulka.jpg'],
    4: ['kamizelka.jpg', 'czapka.jpg', 'szalik.jpg', 'rekawiczki.jpg', 'bluza.jpg', 'sukienka.jpg'],
    5: ['koszulka.jpg', 'spodnica.jpg', 'sukienka.jpg', 'sweter.jpg', 'skarpetki.jpg', 'rekawiczki.jpg'],
    6: ['rekawiczki.jpg', 'spodnie.jpg', 'sukienka.jpg', 'sweter.jpg', 'skarpetki.jpg', 'bluza.jpg']
  }
  var round2Answers = [1,5,6,6,5,1]
  var round2UserAnswers = {
    1: [],
    2: [],
    3: [],
    4: [],
    5: [],
    6: []
  }

  var round2CheckedAnswers = [false, false, false, false, false, false]

  var round3 = [
    {
      0: 'rekawiczki.jpg',
      1: ['scarf', 'gloves', 'sweatshirt']
    },
    {
      0: 'czapka.jpg',
      1: ['vest', 'hat', 'scarf']
    },
    {
      0: 'skarpetki.jpg',
      1: ['dress', 'sweater', 'socks']
    },
    {
      0: 'spodnie.jpg',
      1: ['t-shirt', 'shirt', 'trousers']
    },
    {
      0: 'sukienka.jpg',
      1: ['skirt', 'dress', 'sweater']
    },
    {
      0: 'spodnica.jpg',
      1: ['shirt', 'skirt', 'skarf']
    }
  ]
  var round3Answers = [2,2,3,3,2,2]
  var round3UserAnswers = {
    1: [],
    2: [],
    3: [],
    4: [],
    5: [],
    6: []
  }

  var round3CheckedAnswers = [false, false, false, false, false, false]


// MAIN LOGIC

  $('.next-round').on('click', function(){
    roundNumber += 1;
    $('.round-' + (roundNumber-1)).addClass('hidden')
    $('.round-' + roundNumber).removeClass('hidden')
    if(roundNumber == 3){
      $('.next-round').addClass('disabled')
    }
    $('.prev-round').removeClass('disabled')
    $( '.round-number' ).html( roundNumber );
    $('#round2EndedModal').modal('hide')
    questionNumber = 1;
    if(roundNumber == 2) {
      round2prepareCurrentQuestionData()
      questionAudio = new Audio('../files/audio/moda/angielski/polecenie2.wav');
    } else {
      if(roundNumber == 3){
        round3prepareCurrentQuestionData()
        questionAudio = new Audio('../files/audio/moda/angielski/polecenie3.wav');
      }
    }
  })

  $('.prev-round').on('click', function(){
    roundNumber -= 1;
    $('.round-' + (roundNumber+1)).addClass('hidden')
    $('.round-' + roundNumber).removeClass('hidden')

    if(roundNumber == 1){
      $('.prev-round').addClass('disabled')
    }
    $('.next-round').removeClass('disabled')
    $( '.round-number' ).html( roundNumber );
    questionNumber = 1;
    if(roundNumber == 2) {
      round2prepareCurrentQuestionData()
    } else {
      if(roundNumber == 3){
        round3prepareCurrentQuestionData()
        questionAudio = new Audio('../files/audio/moda/angielski/polecenie3.wav');
      }
    }
  })

// first round

  $('.answer-audio', '.answer-audios-1').on('click', function(event){
    event.preventDefault();
    event.stopPropagation();
    var answerNo = parseInt($(this).attr('data-answer-no'));
    answerAudios[1][0][answerNo-1].play();
  })

  $('.answer-audio', '.answer-audios-2').on('click', function(event){
    event.preventDefault();
    event.stopPropagation();
    var answerNo = parseInt($(this).attr('data-answer-no'));
    answerAudios[1][1][answerNo-1].play();
  })


// second round
  var round2prepareCurrentQuestionData = function() {
    $('.answer-button', '.round-2').removeClass('correct-answer-2').removeClass('wrong-answer-2')
    $('.button-image', $('.answer-buttons', '.round-2')).each(function(index){
      $(this).attr('src', '../files/img/moda/angielski/' + round2Images[questionNumber][index])
      if(index+1 == round2Answers[questionNumber-1] && round2UserAnswers[questionNumber].indexOf(index+1) != -1){
        $(this).parents('.answer-button').addClass('correct-answer-2')
      }
    })
  }

  var checkIfShouldFinishRound2 = function() {
    var allAnsweredCorrectly = true;
    for(var i=0; i<round2Answers.length; i++) {
      if(round2UserAnswers[i+1].indexOf(round2Answers[i]) == -1) {
        allAnsweredCorrectly = false
      }
    }
    if(allAnsweredCorrectly) {
      var tableBodyHtml = '';
      for (var i=1; i<=round2Answers.length; i++) {
        tableBodyHtml += '<tr><td>' + i + '</td><td>'
        if(_.without(round2UserAnswers[i], round2Answers[i-1]).length > 0) {
          tableBodyHtml += _.without(round2UserAnswers[i], round2Answers[i-1]).length
          // + ' (' + _.without(round2UserAnswers[i], round2Answers[i-1]).join(', ') + ')'
        } else {
          tableBodyHtml += '0'
        }
        tableBodyHtml += '</td><td>'
        if(round2CheckedAnswers[i-1]){
          tableBodyHtml += 'TAK'
        } else {
          tableBodyHtml += 'NIE'
        }
        tableBodyHtml += '</td>'
      }
      $('tbody', '#round2EndedModal').html(tableBodyHtml)
      $('#round2EndedModal').modal('show')
    } else {
      $('#modalCorrectAnswer').modal('show')
    }
  }

  $('.read-answer').on('click', function(event){
    event.preventDefault()
    answerAudios[roundNumber][questionNumber-1].play()
  })

  $( '.next-question', '.round-2' ).on('click', function(event){
    event.preventDefault()
    if($(this).parents('round-2')){
      if(questionNumber < noOfQuestions[1]){
        questionNumber++;
        round2prepareCurrentQuestionData()
        if(questionNumber == noOfQuestions[1]){
          $('.next-question', '.round-2').addClass('disabled')
        }
        $('.prev-question', '.round-2').removeClass('disabled')
      }
      $('#modalCorrectAnswer').modal('hide')
    }
  });

  $( '.prev-question', '.round-2' ).on('click', function(event){
    event.preventDefault()
    console.log($(this))
    if(questionNumber > 1){
      questionNumber--;
      round2prepareCurrentQuestionData()
      if(questionNumber == 1){
        $('.prev-question', '.round-2').addClass('disabled')
      }
      $('.next-question', '.round-2').removeClass('disabled')
    }
  });

  $('.answer-button', '.round-2').on('click', function(event){
    event.preventDefault();
    round2UserAnswers[questionNumber].push(parseInt($(this).attr('data-answer-no')))
    $('.answer-button', '.round-2').removeClass('wrong-answer-2')
    if(parseInt($(this).attr('data-answer-no')) == round2Answers[questionNumber-1]){
      $(this).addClass('correct-answer-2')
      checkIfShouldFinishRound2()
      badAnswerAudio.load()
      goodAnswerAudio.play()
    } else {
      $(this).addClass('wrong-answer-2')
      goodAnswerAudio.load()
      badAnswerAudio.play()
    }
  })

  $('.check-answer', '.round-2').on('click', function(event) {
    event.preventDefault()
    round2CheckedAnswers[questionNumber-1] = true
    $('.answer-button[data-answer-no=' + round2Answers[questionNumber-1] + ']', '.round-2').toggleClass('correct-answer-2', 500).delay(500).toggleClass('correct-answer-2', 500).delay(500).toggleClass('correct-answer-2', 500).delay(500).toggleClass('correct-answer-2', 500).delay(500).toggleClass('correct-answer-2', 500).delay(500).toggleClass('correct-answer-2', 500)
  })

  $( '.round-number' ).html( roundNumber );

// third round

  var round3prepareCurrentQuestionData = function() {
    $('.answer-button', '.round-3').removeClass('correct-answer').removeClass('wrong-answer')
    $('.text-thumb', $('.answer-buttons', '.round-3')).each(function(index){
      $(this).html(round3[questionNumber-1][1][index])
      if(index+1 == round3Answers[questionNumber-1] && round3UserAnswers[questionNumber].indexOf(index+1) != -1){
        $(this).parents('.answer-button').addClass('correct-answer')
      }
    })
    $('.button-image', '.round-3').attr('src', '../files/img/moda/angielski/' + round3[questionNumber-1][0])
  }

  var checkIfShouldFinishRound3 = function() {
    var allAnsweredCorrectly = true;
    for(var i=0; i<round3Answers.length; i++) {
      if(round3UserAnswers[i+1].indexOf(round3Answers[i]) == -1) {
        allAnsweredCorrectly = false
      }
    }
    if(allAnsweredCorrectly) {
      var tableBodyHtml = '';
      for (var i=1; i<=round3Answers.length; i++) {
        tableBodyHtml += '<tr><td>' + i + '</td><td>'
        if(_.without(round3UserAnswers[i], round3Answers[i-1]).length > 0) {
          tableBodyHtml += _.without(round3UserAnswers[i], round3Answers[i-1]).length
          // + ' (' + _.without(round2UserAnswers[i], round2Answers[i-1]).join(', ') + ')'
        } else {
          tableBodyHtml += '0'
        }
        tableBodyHtml += '</td><td>'
        if(round3CheckedAnswers[i-1]){
          tableBodyHtml += 'TAK'
        } else {
          tableBodyHtml += 'NIE'
        }
        tableBodyHtml += '</td>'
      }
      $('tbody', '#round3EndedModal').html(tableBodyHtml)
      $('#round3EndedModal').modal('show')
    } else {
      $('#modalCorrectAnswer').modal('show')
    }
  }

  $('.read-question').on('click', function(event){
    event.preventDefault()
    questionAudio.play()
  })

  $( '.next-question', '.round-3' ).on('click', function(event){
    event.preventDefault()
    if(questionNumber < noOfQuestions[2]){
      questionNumber++;
      round3prepareCurrentQuestionData()
      if(questionNumber == noOfQuestions[2]){
        $('.next-question', '.round-3').addClass('disabled')
      }
      $('.prev-question', '.round-3').removeClass('disabled')
    }
    $('#modalCorrectAnswer').modal('hide')
  });

  $( '.prev-question', '.round-3' ).on('click', function(event){
    event.preventDefault()
    if(questionNumber > 1){
      questionNumber--;
      round3prepareCurrentQuestionData()
      if(questionNumber == 1){
        $('.prev-question', '.round-3').addClass('disabled')
      }
      $('.next-question', '.round-3').removeClass('disabled')
    }
    $('#modalCorrectAnswer').modal('hide')
  });

  $('.answer-button', '.round-3').on('click', function(event){
    event.preventDefault();
    round3UserAnswers[questionNumber].push(parseInt($(this).attr('data-answer-no')))
    $('.answer-button', '.round-3').removeClass('wrong-answer')
    if(parseInt($(this).attr('data-answer-no')) == round3Answers[questionNumber-1]){
      $(this).addClass('correct-answer')
      checkIfShouldFinishRound3()
      badAnswerAudio.load()
      goodAnswerAudio.play()
    } else {
      $(this).addClass('wrong-answer')
      goodAnswerAudio.load()
      badAnswerAudio.play()
    }
  })

  $('.check-answer', '.round-3').on('click', function(event) {
    event.preventDefault()
    round3CheckedAnswers[questionNumber-1] = true
    $('.answer-button[data-answer-no=' + round3Answers[questionNumber-1] + ']', '.round-3').toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500)
  })



});
