$( document ).ready(function() {

// DATA
  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/moda/quiz/polecenie1.wav');


  var questionNumber = 1;
  var noOfQuestions = 17;

  var questionTypes = [
    'image',
    'image',
    'image',
    'image',
    'image',
    'image',
    'image',
    'image',
    'image',
    'image',
    'image',
    'image',
    'image',
    'image',
    'image',
    'image',
    'image'
  ]

  var questions = {
    1: "Wskaż koszulkę",
    2: "Wskaż koszulę",
    3: "Jak wygląda podkoszulek?",
    4: "Jak wyglądają spodnie?",
    5: "Gdzie jest spodnica?",
    6: "Jak wygląda sukienka?",
    7: "Wskaż sweter",
    8: "Znajdź krawat",
    9: "Odszukaj skarpetki",
    10: "Wskaż podkolanowki",
    11: "Znajdź rajstopy",
    12: "Gdzie jest golf?",
    13: "Odszukaj legginsy",
    14: "Jak wygląda marynarka?",
    15: "Gdzie jest kamizelka?",
    16: "Znajdź pelerynę",
    17: "Odszukaj bluzę"
  }
  var answers = {
    1: {
      0: ['koszulka', 'koszula', 'podkoszulek', 'sukienka', 'bluza', 'kamizelka'],
      1: ['koszulka.jpg', 'koszula.jpg', 'podkoszulek.jpg', 'sukienka.jpg', 'bluza.jpg', 'kamizelka.jpg'],
      2: ['koszulka.wav', 'koszula.wav', 'podkoszulek.wav', 'sukienka.wav', 'bluza.wav', 'kamizelka.wav']
    },
    2: {
      0: ['koszulka', 'koszula', 'marynarka', 'peleryna', 'bluza', 'golf'],
      1: ['koszulka.jpg', 'koszula.jpg', 'marynarka.jpg', 'peleryna.jpg', 'bluza.jpg', 'golf.jpg'],
      2: ['koszulka.wav', 'koszula.wav', 'marynarka.wav', 'peleryna.wav', 'bluza.wav', 'golf.wav']
    },
    3: {
      0: ['spodnie', 'sukienka', 'sweter', 'krawat', 'podkoszulek', 'skarpetki'],
      1: ['spodnie.jpg', 'sukienka.jpg', 'sweter.jpg', 'krawat.jpg', 'podkoszulek.jpg', 'skarpetki.jpg'],
      2: ['spodnie.wav', 'sukienka.wav', 'sweter.wav', 'krawat.wav', 'podkoszulek.wav', 'skarpetki.wav']
    },
    4: {
      0: ['legginsy', 'rajstopy', 'spodnie', 'koszulka', 'podkoszulek', 'spodnica'],
      1: ['legginsy.jpg', 'rajstopy.jpg', 'spodnie.jpg', 'koszulka.jpg', 'podkoszulek.jpg', 'spodnica.jpg'],
      2: ['legginsy.wav', 'rajstopy.wav', 'spodnie.wav', 'koszulka.wav', 'podkoszulek.wav', 'spodnica.wav']
    },
    5: {
      0: ['marynarka', 'kamizelka', 'spodnica', 'sukienka', 'sweter', 'skarpetki'],
      1: ['marynarka.jpg', 'kamizelka.jpg', 'spodnica.jpg', 'sukienka.jpg', 'sweter.jpg', 'skarpetki.jpg'],
      2: ['marynarka.wav', 'kamizelka.wav', 'spodnica.wav', 'sukienka.wav', 'sweter.wav', 'skarpetki.wav']
    },
    6: {
      0: ['podkolanowki', 'sukienka', 'sweter', 'spodnie', 'koszula', 'krawat'],
      1: ['podkolanowki.jpg', 'sukienka.jpg', 'sweter.jpg', 'spodnie.jpg', 'koszula.jpg', 'krawat.jpg'],
      2: ['podkolanowki.wav', 'sukienka.wav', 'sweter.wav', 'spodnie.wav', 'koszula.wav', 'krawat.wav']
    },
    7: {
      0: ['peleryna', 'sweter', 'sukienka', 'spodnica', 'podkolanowki', 'krawat'],
      1: ['peleryna.jpg', 'sweter.jpg', 'sukienka.jpg', 'spodnica.jpg', 'podkolanowki.jpg', 'krawat.jpg'],
      2: ['peleryna.wav', 'sweter.wav', 'sukienka.wav', 'spodnica.wav', 'podkolanowki.wav', 'krawat.wav']
    },
    8: {
      0: ['peleryna', 'bluza', 'rajstopy', 'krawat', 'legginsy', 'koszulka'],
      1: ['peleryna.jpg', 'bluza.jpg', 'rajstopy.jpg', 'krawat.jpg', 'legginsy.jpg', 'koszulka.jpg'],
      2: ['peleryna.wav', 'bluza.wav', 'rajstopy.wav', 'krawat.wav', 'legginsy.wav', 'koszulka.wav']
    },
    9: {
      0: ['skarpetki', 'podkolanowki', 'legginsy', 'rajstopy', 'kamizelka', 'bluza'],
      1: ['skarpetki.jpg', 'podkolanowki.jpg', 'legginsy.jpg', 'rajstopy.jpg', 'kamizelka.jpg', 'bluza.jpg'],
      2: ['skarpetki.wav', 'podkolanowki.wav', 'legginsy.wav', 'rajstopy.wav', 'kamizelka.wav', 'bluza.wav']
    },
    10: {
      0: ['skarpetki', 'spodnie', 'podkolanowki', 'spodnica', 'sukienka', 'koszula'],
      1: ['skarpetki.jpg', 'spodnie.jpg', 'podkolanowki.jpg', 'spodnica.jpg', 'sukienka.jpg', 'koszula.jpg'],
      2: ['skarpetki.wav', 'spodnie.wav', 'podkolanowki.wav', 'spodnica.wav', 'sukienka.wav', 'koszula.wav']
    },
    11: {
      0: ['kamizelka', 'legginsy', 'rajstopy', 'golf', 'marynarka', 'bluza'],
      1: ['kamizelka.jpg', 'legginsy.jpg', 'rajstopy.jpg', 'golf.jpg', 'marynarka.jpg', 'bluza.jpg'],
      2: ['kamizelka.wav', 'legginsy.wav', 'rajstopy.wav', 'golf.wav', 'marynarka.wav', 'bluza.wav']
    },
    12: {
      0: ['podkoszulek', 'spodnie', 'golf', 'legginsy', 'bluza', 'peleryna'],
      1: ['podkoszulek.jpg', 'spodnie.jpg', 'golf.jpg', 'legginsy.jpg', 'bluza.jpg', 'peleryna.jpg'],
      2: ['podkoszulek.wav', 'spodnie.wav', 'golf.wav', 'legginsy.wav', 'bluza.wav', 'peleryna.wav']
    },
    13: {
      0: ['legginsy', 'marynarka', 'podkolanowki', 'rajstopy', 'peleryna', 'bluza'],
      1: ['legginsy.jpg', 'marynarka.jpg', 'podkolanowki.jpg', 'rajstopy.jpg', 'peleryna.jpg', 'bluza.jpg'],
      2: ['legginsy.wav', 'marynarka.wav', 'podkolanowki.wav', 'rajstopy.wav', 'peleryna.wav', 'bluza.wav']
    },
    14: {
      0: ['koszulka', 'koszula', 'marynarka', 'spodnica', 'bluza', 'peleryna'],
      1: ['koszulka.jpg', 'koszula.jpg', 'marynarka.jpg', 'spodnica.jpg', 'bluza.jpg', 'peleryna.jpg'],
      2: ['koszulka.wav', 'koszula.wav', 'marynarka.wav', 'spodnica.wav', 'bluza.wav', 'peleryna.wav']
    },
    15: {
      0: ['golf', 'legginsy', 'marynarka', 'kamizelka', 'peleryna', 'koszula'],
      1: ['golf.jpg', 'legginsy.jpg', 'marynarka.jpg', 'kamizelka.jpg', 'peleryna.jpg', 'koszula.jpg'],
      2: ['golf.wav', 'legginsy.wav', 'marynarka.wav', 'kamizelka.wav', 'peleryna.wav', 'koszula.wav']
    },
    16: {
      0: ['koszula', 'koszulka', 'golf', 'rajstopy', 'legginsy', 'peleryna'],
      1: ['koszula.jpg', 'koszulka.jpg', 'golf.jpg', 'rajstopy.jpg', 'legginsy.jpg', 'peleryna.jpg'],
      2: ['koszula.wav', 'koszulka.wav', 'golf.wav', 'rajstopy.wav', 'legginsy.wav', 'peleryna.wav']
    },
    17: {
      0: ['koszula', 'spodnie', 'spodnica', 'sukienka', 'bluza', 'kamizelka'],
      1: ['koszula.jpg', 'spodnie.jpg', 'spodnica.jpg', 'sukienka.jpg', 'bluza.jpg', 'kamizelka.jpg'],
      2: ['koszula.wav', 'spodnie.wav', 'spodnica.wav', 'sukienka.wav', 'bluza.wav', 'kamizelka.wav']
    }
  }

  var answerAudios = []

  var correctAnswerIndexes = {
    1: [1],
    2: [2],
    3: [5],
    4: [3],
    5: [3],
    6: [2],
    7: [2],
    8: [4],
    9: [1],
    10: [3],
    11: [3],
    12: [3],
    13: [1],
    14: [3],
    15: [4],
    16: [6],
    17: [5]

  }

  var questionsFinished = []

  var answered = {
    1: [],
    2: [],
    3: [],
    4: [],
    5: [],
    6: [],
    7: [],
    8: [],
    9: [],
    10: [],
    11: [],
    12: [],
    13: [],
    14: [],
    15: [],
    16: [],
    17: []
  }

// MAIN LOGIC

  $( '.question-number' ).html( questionNumber );
  $( '.question-sum' ).html( noOfQuestions );
  $( '.question-text' ).html( questions[questionNumber] );

  $( 'body' ).on('click', '.next-question', function(event){
    event.preventDefault()
    if(questionNumber < noOfQuestions){
      questionNumber++;
      setPageDataForQuestion()
    }
    $('#modalCorrectAnswer').modal('hide')
  });

  $( '.prev-question' ).on('click', function(event){
    event.preventDefault()
    if(questionNumber > 1){
      questionNumber--;
      setPageDataForQuestion()
    }
  });

  $('.answer-audio').on('click', function(event){
    event.preventDefault();
    event.stopPropagation();
    var answerNo = parseInt($(this).attr('data-answer-no'));
    answerAudios[answerNo-1].play();
  })

  $( '.answer-button' ).on('click', function(event) {
    event.preventDefault()
    $('.wrong-answer').removeClass('wrong-answer')
    $('.last-answer').removeClass('last-answer')
    $(this).addClass('last-answer')
    var answerNo = parseInt($(this).attr('data-answer-no'))
    answered[questionNumber].push(answerNo)
    if(correctAnswerIndexes[questionNumber].indexOf(answerNo) !== -1) {
      $(this).addClass('correct-answer')
      badAnswerAudio.load()
      goodAnswerAudio.play()

      if(_.uniq(_.intersection(correctAnswerIndexes[questionNumber], answered[questionNumber])).length == correctAnswerIndexes[questionNumber].length) {

        //all correct answers selected
        if(questionsFinished.indexOf(questionNumber) == -1){
          questionsFinished.push(questionNumber)
        }
        if(!(questionsFinished.length === noOfQuestions)){
          if(questionNumber < noOfQuestions){
            showCorrectAnswerModal()
          }
        } else {
          fillEndModalAndShowIt()
        }

      }
    } else {
      goodAnswerAudio.load()
      badAnswerAudio.play()
      $(this).addClass('wrong-answer')
    }
  });

  $('.read-question').on('click', function(event) {
    event.preventDefault()
    questionAudio.play()
  })

  $('.check-answer').on('click', function(event) {
    event.preventDefault()
    $('.is-correct').toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500)
  })

  var setPageDataForQuestion = function() {
    $( '.question-number' ).html(questionNumber );
    $( '.question-text' ).html(questions[questionNumber] );

    questionAudio = new Audio('../files/audio/moda/quiz/polecenie' + questionNumber + '.wav');

    if(questionTypes[questionNumber-1] === 'image'){
      setAnswerButtonsForImage()
    } else if(questionTypes[questionNumber-1] === 'text') {
      setAnswerButtonsForText()
    }
    setAnswerAudiosButtons()
    if(questionNumber == noOfQuestions) {
      $( '.next-question' ).addClass('disabled')
    } else {
      $( '.next-question' ).removeClass('disabled');
    };
    if(questionNumber == 1) {
      $( '.prev-question' ).addClass('disabled');
    } else {
      $( '.prev-question' ).removeClass('disabled');
    }
    $('.wrong-answer').removeClass('wrong-answer')
    $('.last-answer').removeClass('last-answer')
  }

  var setAnswerAudiosButtons = function() {
    for (i = 0; i < 7; i++) {
      button = $('.answer-audio.aa-' + (i+1), '.answer-audios')
      if(answers[questionNumber][0][i]){
        $(button).removeClass('hide')
      } else {
        $(button).addClass('hide')
      }
    }
  }

  var setAnswerButtonsForText = function() {
    $('.answer-buttons-img').hide();
    $('.answer-buttons-txt').show();
    $('.answer-button').removeClass('is-correct')

    for (i = 0; i < 7; i++) {
      button = $('.answer-button.ab-' + (i+1), '.answer-buttons-txt')

      if(correctAnswerIndexes[questionNumber].indexOf(i+1) != -1){
        $(button).addClass('is-correct')
      }

      if(answers[questionNumber][0][i]){
        $(button).removeClass('hide')
        if(answered[questionNumber].indexOf(i+1) !== -1 && correctAnswerIndexes[questionNumber].indexOf(i+1) !== -1) {
          $(button).addClass('correct-answer')
        } else {
          $(button).removeClass('correct-answer')
        }
        $( '.text', $('a', button) ).html(answers[questionNumber][0][i]);
      } else {
        $(button).addClass('hide')
      }
    }
    setAnswerAudios(1)
  }

  var setAnswerButtonsForImage = function() {
    $('.answer-buttons-txt').hide();
    $('.answer-buttons-img').show();
    $('.answer-button').removeClass('is-correct')
    for (i = 0; i < 7; i++) {
      button = $('.answer-button.ab-' + (i+1), '.answer-buttons-img')

      if(correctAnswerIndexes[questionNumber].indexOf(i+1) != -1){
        $(button).addClass('is-correct')
      }

      if(answers[questionNumber][1][i]){
        $(button).removeClass('hide')
        if(answered[questionNumber].indexOf(i+1) !== -1 && correctAnswerIndexes[questionNumber].indexOf(i+1) !== -1) {
          $(button).addClass('correct-answer')
        } else {
          $(button).removeClass('correct-answer')
        }
        $( '.button-image', button ).attr('src', '../files/img/moda/quiz/' + answers[questionNumber][1][i]);
        $( '.button-footer', button ).text(answers[questionNumber][0][i]);
      } else {
        $(button).addClass('hide')
      }
    }
    setAnswerAudios(2)
  }

  var setAnswerAudios = function(index){
    answerAudios = []
    for (i = 0; i < answers[questionNumber][index].length; i++) {
      answerAudios.push(new Audio('../files/audio/moda/quiz/' + answers[questionNumber][index][i]))
    }
  }

  var fillEndModalAndShowIt = function() {
    var tableBodyHtml = '';
    var i = 1;
    _.each(answered, function(yourAnswers){
      var yourAnswerTexts = []
      _.each(yourAnswers, function(answer) {
        if(correctAnswerIndexes[i].indexOf(answer) != -1){
          yourAnswerTexts.push('<span class="text-success">' + answers[i][0][answer-1] + '</span>')
        } else {
          yourAnswerTexts.push('<span class="text-danger">' + answers[i][0][answer-1] + '</span>')
        }
      })
      tableBodyHtml+='<tr><td>' + i + '</td><td>' + yourAnswers.length + '</td><td>' + _.difference(yourAnswers, correctAnswerIndexes[i]).length + '</td><td>' + yourAnswerTexts.join(', ') + '</td></tr>'
      i+=1;
    })
    $('tbody', '#quizEndedModal').html(tableBodyHtml)
    $('#quizEndedModal').modal('show')
  }

  var showCorrectAnswerModal = function(){
    $('#modalCorrectAnswer').modal('show')
  }



  setAnswerButtonsForImage()
  setAnswerAudiosButtons()

});
