$( document ).ready(function() {

  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/rodzina/polecenie_obowiazki.wav');
  var badAnswersCount = 0

  // $('.check-answer').on('click', function(event){
  //   event.preventDefault()
  //   $('.is-correct', '.question-' + questionNumber).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500)
  //   checkedAnswers[questionNumber-1] = true
  // })

  $('.read-question').on('click', function(event){
    event.preventDefault()
    questionAudio.play()
  })

  $('.answer-button', '.people').on('click', function(event) {
    event.preventDefault()
    event.stopPropagation()
    if( $('.thumbnail', this).hasClass('selected') ){
      $('.thumbnail', this).removeClass('selected')
    } else {
      $('.thumbnail', '.people').removeClass('selected')
      $('.thumbnail', this).addClass('selected')
    }
    applyAnswerIfShould()
  })

  $('.answer-button', '.possible-answers').not('.used').on('click', function(event) {
    event.preventDefault()
    event.stopPropagation()
    if( !$(this).hasClass('used') ){
      if( $('.thumbnail', this).hasClass('selected') ){
        $('.thumbnail', this).removeClass('selected')
      } else {
        $('.thumbnail', '.possible-answers').removeClass('selected')
        $('.thumbnail', this).addClass('selected')
      }
      applyAnswerIfShould()
    }
  })

  applyAnswerIfShould = function() {
    selectedPerson = $('.selected', '.people')
    selectedAnswer = $('.selected', '.possible-answers')
    if( selectedPerson.length > 0 && selectedAnswer.length > 0 ) {
      $('.answers', $(selectedPerson).parents('.answer-container')).append('<div class="col-md-6 col-sm-6 col-xs-6 answered" data-answer-no="' + $(selectedAnswer).parents('.answer-button').attr('data-answer-no') + '"><div class="dummy"></div><div class="thumbnail"><img class="button-image" src="' + $('img', selectedAnswer).attr('src') + '" style="max-height: 100%;"></div></div>')
      $(selectedAnswer).parents('.answer-button').addClass('used').addClass('disabled')
      $(selectedAnswer).removeClass('selected')
      $(selectedPerson).removeClass('selected')
      checkIfEnded()
    }
  }

  checkIfEnded = function() {
    if( $('.answer-button', '.possible-answers').not('.used').length == 0 ){
      var answerCountsAreEqual = true
      var firstAnswersCount = null
      $('.answer-container', '.people').each(function(index){
        answersCount = $('.answered', this).length
        if(index == 0){
          firstAnswersCount = answersCount
        }
        if(answersCount != firstAnswersCount){
          answerCountsAreEqual = false
        }
      })
      if( answerCountsAreEqual ) {
        badAnswerAudio.load()
        goodAnswerAudio.play()
        $('.bad-answer-count', '#allEndedModal').html(badAnswersCount)
        $('#allEndedModal').modal('show')
      } else {
        goodAnswerAudio.load()
        badAnswerAudio.play()
        badAnswersCount += 1
        $('#modalWrongAnswer').modal('show')
      }
    }
  }

  $('.clear').on('click', function(event){
    event.preventDefault()
    $('#modalWrongAnswer').modal('hide')
    $('.answers').html('')
    $('.used').removeClass('used').removeClass('disabled')
  })

  showFinishModal = function() {
    var tableBodyHtml = '';
    for (var i=0; i<3; i++) {
      tableBodyHtml += '<tr><td>' + (i+1) + '</td><td>'
      tableBodyHtml += badAnswers[i].length
      tableBodyHtml += '</td><td>'
      if(checkedAnswers[i]){
        tableBodyHtml += 'TAK'
      } else {
        tableBodyHtml += 'NIE'
      }
      tableBodyHtml += '</td>'
    }
    $('tbody', '#allEndedModal').html(tableBodyHtml)
    $('#allEndedModal').modal('show')
  }

  showProperModal = function() {
    allCurrentAnsweredProperly = true;
    $('.picture', '.question-' + questionNumber).each(function(index){
      if( $(this).hasClass('is-correct') && !($(this).hasClass('correct-answer')) ){
        allCurrentAnsweredProperly = false;
      }
    })
    if( allCurrentAnsweredProperly ) {
      allAnsweredProperly = true;
      $('.picture.is-correct', '.possible-answers').each(function(index){
        if( !($(this).hasClass('correct-answer')) ){
          allAnsweredProperly = false;
        }
      })
      if( allAnsweredProperly ) {
        showFinishModal()
      } else {
        $('#modalCorrectAnswer').modal('show')
      }
    }
  }

})