$( document ).ready(function() {

  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/rodzina/polecenie_policz.wav');

  var answerData = [
    {
      numbers: [8,5,2,1,3,2],
      indexesToMove: [4,5,6],
      answer: 6
    },
    {
      numbers: [1,1,6,4,1,2],
      indexesToMove: [4,5,6],
      answer: 7
    },
    {
      numbers: [9,0,3,4,1,1,2,3],
      indexesToMove: [5,6,7,8],
      answer: 7
    },
    {
      numbers: [7,4,3,2,2,0,4,3],
      indexesToMove: [5,6,7,8],
      answer: 9
    },
    {
      numbers: [4,6,8,9,2,3,1,6,0],
      indexesToMove: [6,7,8,9],
      answer: 10
    },
    {
      numbers: [2,3,2,3,4,1,1,1,2,6],
      indexesToMove: [6,7,8,9,10],
      answer: 11
    },
    {
      numbers: [3,4,5,6,7,2,2,2,2,2,2],
      indexesToMove: [6,7,8,9,10,11],
      answer: 12
    }
  ]
  var questionNumber = 1
  var noOfQuestions = 7
  var answers = [ [], [], [], [], [], [], [] ]
  var checkedAnswers = [false, false, false, false, false, false, false]
  var intervals = []

  drawMoving = function(){
    var tmout = []
    intervals = []
    $('.will-move', '.liczby-container').each(function() {
      var item = this
      if ($(item).hasClass('left') || $(item).hasClass('center') || $(item).hasClass('right') || $(item).hasClass('top') || $(item).hasClass('middle') || $(item).hasClass('bottom')) {
        $(item).removeClass('left center right top middle bottom', 1000)
      } else {
        $(item).toggleClass(_.sample(_.shuffle(['left', 'center', 'right'])) + ' ' + _.sample(_.shuffle(['top', 'middle', 'bottom'])), 1000)
      }

      intervals.push(setInterval(function(){
        if ($(item).hasClass('left') || $(item).hasClass('center') || $(item).hasClass('right') || $(item).hasClass('top') || $(item).hasClass('middle') || $(item).hasClass('bottom')) {
          $(item).removeClass('left center right top middle bottom', 1000)
        } else {
          $(item).toggleClass(_.sample(['left', 'center', 'right']) + ' ' + _.sample(['top', 'middle', 'bottom']), 1000)
        }
      },1100))
    })
  }

  stopMoving = function() {
    _.each(intervals, function(item){
      clearInterval(item)
    })
  }

  $('.check-answer').on('click', function(event){
    event.preventDefault()
    $('.answer-box').val(answerData[questionNumber-1]['answer'])
    $('.check-my-answer').click()
    checkedAnswers[questionNumber-1] = true
  })

  $('.read-question').on('click', function(event){
    event.preventDefault()
    questionAudio.play()
  })

  $('.next-question').on('click', function(event){
    event.preventDefault();
    if ($(this).hasClass('blocked')) {
      return
    }
    questionNumber+=1;
    if(noOfQuestions == questionNumber){
      $('.next-question').addClass('disabled');
    };
    $('.prev-question').removeClass('disabled');
    $('.question-number').html(questionNumber);

    loadQuestionData()
  })

  $('.prev-question').on('click', function(event){
    event.preventDefault();
    if ($(this).hasClass('blocked')) {
      return
    }
    questionNumber-=1;
    if(1 == questionNumber){
      $('.prev-question').addClass('disabled');
    };
    $('.next-question').removeClass('disabled');
    $('.question-number').html(questionNumber);

    loadQuestionData()
  })

  loadQuestionData = function() {
    stopMoving()
    $('.count-number').addClass('hidden')
    $('.check-my-answer').removeClass('wrong-answer correct-answer')
    $('.next-question').addClass('blocked')
    $('.prev-question').addClass('blocked')

    $('#modalCorrectAnswer').modal('hide')
    if( answers[questionNumber-1] && answers[questionNumber-1].indexOf(answerData[questionNumber-1]['answer']) != -1 ) {
      $('.check-my-answer').addClass('correct-answer')
      $('.answer-box').val(answerData[questionNumber-1]['answer'])
    } else {
      $('.answer-box').val('')
    }
    setTimeout(function(){
      $('.count-number').removeClass('green will-move left center right top middle bottom').addClass('hidden')
      var i = 1
      _.each(answerData[questionNumber-1]['numbers'], function(num){
        $('.liczba-' + i).html(num)
        $('.liczba-' + i).addClass(_.sample(['green', '']))
        console.log ("\n" + i)
        if (answerData[questionNumber-1]['indexesToMove'].indexOf(i) != -1) {
          $('.liczba-' + i).addClass('will-move')
          console.log(true)
        };
        $('.liczba-' + i).removeClass('hidden')
        i += 1
      })
      drawMoving()
      $('.next-question').removeClass('blocked')
      $('.prev-question').removeClass('blocked')
    }, 1000)
  }

  $('.check-my-answer').on('click', function(event){
    event.preventDefault();
    answered = parseInt($('.answer-box').val())
    if( answered == answerData[questionNumber-1]['answer'] ) {
      badAnswerAudio.load();
      goodAnswerAudio.play();
      $('.check-my-answer').addClass('correct-answer')
      $('.check-my-answer').removeClass('wrong-answer')
      answers[questionNumber-1].push(answered)
      showProperModal()
    } else {
      goodAnswerAudio.load();
      badAnswerAudio.play();
      $('.check-my-answer').addClass('wrong-answer')
      $('.check-my-answer').removeClass('correct-answer')
      answers[questionNumber-1].push(answered)
    }
  })

  showFinishModal = function() {
    var tableBodyHtml = '';
    for (var i=0; i<noOfQuestions; i++) {
      tableBodyHtml += '<tr><td>' + (i+1) + '</td><td>'
      badAnswers = _.without(answers[i], answerData[i]['answer'])
      if(badAnswers.length > 0) {
        tableBodyHtml += badAnswers.length + ' (' + badAnswers.join(', ') + ')'
      } else {
        tableBodyHtml += '0'
      }
      tableBodyHtml += '</td><td>'
      if(checkedAnswers[i]){
        tableBodyHtml += 'TAK'
      } else {
        tableBodyHtml += 'NIE'
      }
      tableBodyHtml += '</td>'
    }
    $('tbody', '#countEndedModal').html(tableBodyHtml)
    $('#countEndedModal').modal('show')
  }

  showProperModal = function() {
    allAnsweredProperly = true;
    var i = 0;
    _.each(answers, function(questionAnswers){
      if( questionAnswers.indexOf(answerData[i]['answer']) == -1 ){
        allAnsweredProperly = false;
      }
      i+=1;
    })
    if( allAnsweredProperly ) {
      showFinishModal()
    } else {
      $('#modalCorrectAnswer').modal('show')
    }
  }

  $('.question-number').html(questionNumber);
  $('.question-sum').html(noOfQuestions);
  $('.question-text').html('Dodaj do siebie ruszające się liczby');
  loadQuestionData()

})