$( document ).ready(function() {

  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');

  var questionData = [
    {
      title: 'A',
      text: "Witamina A to pani która bardzo lubi się modnie ubierać. Najchętniej zakłada pomarańczowe jak marchewka spódniczki, zielone jak szpinak bluzeczki; lubi także sukienki w żółto - czerwone pasy. To kolory jej ulubionych owoców: mango i czerwonej papryki. Mimo, że lubi przebywać w towarzystwie znajomych tłuszczy, jest osobą szczupłą. Od wielu lat jest przewodniczącym komitetu do walki z objawami utraty wzroku. Jeśli źle widzisz - zgłoś się do niej, na pewno ci pomoże.",
      audio: new Audio('../files/audio/wiem-co-jem/dopasuj/1.wav')
    },
    {
      title: 'B',
      text: "Witaminy B są rodzeństwem. Imię ostatniej to B-12. Każde z nich jest troszeczkę inne, ale wszystkie są bardzo ważne. Rodzeństwo uwielbia zabawy: najchętniej bawią się na polu w chowanego, często wskakują do kłosów zbóż. Jeśli jadasz na śniadanie płatki zbożowe, przypatrz się im uważnie, może zobaczysz którąś z witamin B. Witaminy B lubią produkty, które zaczynają się na tę samą literę, co one - produkty białkowe. Odnajdziesz je w mleku, jajach, mięsie i rybach. Jeśli brakuje Ci towarzystwa rodzeństwa B - uważaj, będziesz się czuł przybity i nieszczęśliwy. Szybko ich poszukaj, a poprawi ci się humor.",
      audio: new Audio('../files/audio/wiem-co-jem/dopasuj/2.wav')
    },
    {
      title: 'C',
      text: "Witamina C lubi żarty. Uwielbia, gdy rymuje się jej imię, na przykład: witamina - cytryna. Jest bardzo zahartowaną osobą. Gdy przebywasz w jej towarzystwie, możesz nie bać się przeziębień, a wszystkie rany i zadrapania szybko ci się zagoją. Witamina C ma swoje humory - to osoba, która nie lubi ciepła ani światła - opalając się niestety maleje. Jest bardzo zwinna, uwielbia wdrapywać się na krzaki czarnych porzeczek i chować w ich owocach. Lubi też chodzić na plotki do pani truskawki. Znajdziesz ją też u państwa ziemniaków. Jeżeli dawno nie widziałeś witaminy C prawdopodobnie czujesz się zmęczony, uważaj też, bo łatwo możesz złapać wirusa.",
      audio: new Audio('../files/audio/wiem-co-jem/dopasuj/3.wav')
    },
  ]
  var questionNumber = 1
  var noOfQuestions = 3
  var badAnswers = [ [], [], [] ]
  var checkedAnswers = [false, false, false]

  $('.check-answer').on('click', function(event){
    event.preventDefault()
    $('.is-correct', '.question-' + questionNumber).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500)
    checkedAnswers[questionNumber-1] = true
  })

  $('.read-question').on('click', function(event){
    event.preventDefault()
    questionData[questionNumber-1].audio.play()
  })

  $('.next-question').on('click', function(event){
    event.preventDefault();
    questionNumber+=1;
    if(noOfQuestions == questionNumber){
      $('.next-question').addClass('disabled');
    };
    $('.prev-question').removeClass('disabled');
    loadQuestionData()
    // if( answers[questionNumber-1] && answers[questionNumber-1].indexOf(goodAnswers[questionNumber-1]) == -1 ) {
    //   $('.answer').addClass('hidden')
    //   $('#modalCorrectAnswer').modal('hide')
    // } else {
    //   $('.answer').removeClass('hidden').addClass('correct-answer')
    //   $('.answer-count').val(goodAnswers[questionNumber-1])
    //   $('#modalCorrectAnswer').modal('hide')
    // }
  })

  $('.prev-question').on('click', function(event){
    event.preventDefault();
    questionNumber-=1;
    if(1 == questionNumber){
      $('.prev-question').addClass('disabled');
    };
    $('.next-question').removeClass('disabled');
    loadQuestionData()
    // if( answers[questionNumber-1] && answers[questionNumber-1].indexOf(goodAnswers[questionNumber-1]) == -1 ) {
    //   $('.answer').addClass('hidden')
    //   $('#modalCorrectAnswer').modal('hide')
    // } else {
    //   $('.answer').removeClass('hidden').addClass('correct-answer')
    //   $('.answer-count').val(goodAnswers[questionNumber-1])
    //   $('#modalCorrectAnswer').modal('hide')
    // }
  })

  $('.picture', '.possible-answers').on('click', function(event){
    event.preventDefault();
    var answerNo = parseInt($(this).attr('data-answer'));
    if($(this).hasClass('is-correct')){
      $(this).addClass('correct-answer')
      badAnswerAudio.load();
      goodAnswerAudio.play();
      showProperModal()
    } else {
      badAnswers[questionNumber-1].push(answerNo);
      $(this).addClass('wrong-answer')
      goodAnswerAudio.load();
      badAnswerAudio.play();
    }
  })

  // $('.check-my-answer').on('click', function(event){
  //   event.preventDefault();
  //   answered = parseInt($('.answer-count').val())
  //   if( answered == goodAnswers[questionNumber-1] ) {
  //     badAnswerAudio.load();
  //     goodAnswerAudio.play();
  //     $('.answer').addClass('correct-answer')
  //     $('.answer').removeClass('wrong-answer')
  //     answers[questionNumber-1].push(answered)
  //     showProperModal()
  //   } else {
  //     goodAnswerAudio.load();
  //     badAnswerAudio.play();
  //     $('.answer').addClass('wrong-answer')
  //     $('.answer').removeClass('correct-answer')
  //     answers[questionNumber-1].push(answered)
  //   }
  // })

  showFinishModal = function() {
    var tableBodyHtml = '';
    for (var i=0; i<3; i++) {
      tableBodyHtml += '<tr><td>' + (i+1) + '</td><td>'
      tableBodyHtml += badAnswers[i].length
      tableBodyHtml += '</td><td>'
      if(checkedAnswers[i]){
        tableBodyHtml += 'TAK'
      } else {
        tableBodyHtml += 'NIE'
      }
      tableBodyHtml += '</td>'
    }
    $('tbody', '#allEndedModal').html(tableBodyHtml)
    $('#allEndedModal').modal('show')
  }

  showProperModal = function() {
    allCurrentAnsweredProperly = true;
    $('.picture', '.question-' + questionNumber).each(function(index){
      if( $(this).hasClass('is-correct') && !($(this).hasClass('correct-answer')) ){
        allCurrentAnsweredProperly = false;
      }
    })
    if( allCurrentAnsweredProperly ) {
      allAnsweredProperly = true;
      $('.picture.is-correct', '.possible-answers').each(function(index){
        if( !($(this).hasClass('correct-answer')) ){
          allAnsweredProperly = false;
        }
      })
      if( allAnsweredProperly ) {
        showFinishModal()
      } else {
        $('#modalCorrectAnswer').modal('show')
      }
    }
  }

  loadQuestionData = function() {
    $('.question-wit').html(questionData[questionNumber-1].title);
    $('.question-text').html(questionData[questionNumber-1].text);
    $('.question-data').addClass('hidden')
    $('.question-' + questionNumber).removeClass('hidden')
    $('#modalCorrectAnswer').modal('hide')
  }


  loadQuestionData()

})