$( document ).ready(function() {

  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/teatr/krzyzowka/pytanie1.wav');

  var questions = [
    "Występują na niej aktorzy",
    "Mało ruchoma lalka",
    "Musisz go mieć zanim wyjdziesz na przedstawienie",
    "Może być na torcie lub w teatrze",
    "Przedmiot używany przez aktora w czasie przedstawienia"
  ]

  var answers = [
    'scena',
    'kukiełka',
    'bilet',
    'dekoracja',
    'rekwizyt'
  ]

  var mainAnswer = 'aktor'

  var badAnswers = {}
  var checkedAnswers = {}

  var currentAnswer = 1
  var totalAnswers =  9

  $('.check-main-answer').on('click', function(event) {
    event.preventDefault();
    var answer = mainAnswer.split('')
    $('input.main-answer').each(function (i) {
      $(this).val(answer[i])
    })
  })

  $('.check-answer').on('click', function(event) {
    event.preventDefault()
    var answerArr = answers[currentAnswer-1].split('');
    $('input', $('tr[data-answer=' + currentAnswer + ']')).each(function (i) {
      $(this).val(answerArr[i]);
    })
    $('.set-answer', 'tr[data-answer=' + currentAnswer + ']').removeClass('wrong-answer').addClass('correct-answer')
    checkedAnswers[currentAnswer] = true
    if($('.set-answer:not(.correct-answer)')[0]){
      $('.set-answer:not(.correct-answer)')[0].click()
    } else {
      allAnsweredProperly()
    }
  })

  $('.set-answer').on('click', function(event) {
    event.preventDefault();
    $(this).removeClass('correct-answer').removeClass('wrong-answer')
    $('.main-color', '.crossword').removeClass('main-color')
    tr = $(this).parents('tr')
    $('input', $(tr)).val('')
    currentAnswer = parseInt($(tr).attr('data-answer'))
    loadCurrentAnswerData()

    $('img.visible', '.crossword').removeClass('visible')
    // $('img', $(tr)).addClass('visible')
    $(this).addClass('main-color')
    $('input', $(tr)).addClass('main-color')
    $('input', $(tr))[0].focus()
  })

  $('input', '.crossword').on('click', function() {
    $('.main-color', '.crossword').removeClass('main-color')
    tr = $(this).parents('tr')
    $('input', $(tr)).val('')
    currentAnswer = parseInt($(tr).attr('data-answer'))
    loadCurrentAnswerData()

    $('img.visible', '.crossword').removeClass('visible')
    // $('img', $(tr)).addClass('visible')
    $('.set-answer', $(tr)).addClass('main-color')
    $('input', $(tr)).addClass('main-color')
    $('input', $(tr))[0].focus()
  })

  var loadCurrentAnswerData = function() {
    $('.question-text').html(questions[currentAnswer-1])
    questionAudio = new Audio('../files/audio/teatr/krzyzowka/pytanie' + currentAnswer + '.wav');
  }

  $('input', '.crossword').mask('A')
  $('input', '.crossword').on( "keypress", function(event) {
    nextInput = $('input', $(this).parents('td').next('td'))
    if(nextInput[0]) {
      $(nextInput).focus()
    } else {
      $(this).val($(this).val()[0])
    }
  })
  $('input', '.crossword').on( "keyup", function(event) {
    if(event.which == 8){
      $('input', $(this).parents('td').prev('td')).focus()
    }
    nextInput = $('input', $(this).parents('td').next('td'))
    if(!nextInput[0] && $(this).val().length == 1) {
      checkProperAnswer()
    }
  })

  var checkProperAnswer = function () {
    currentAnswerText = ''
    $('input', 'tr[data-answer=' + currentAnswer + ']').each(function() {
      currentAnswerText += $(this).val()
    })
    if(currentAnswerText === answers[currentAnswer-1]) {
      badAnswerAudio.load()
      goodAnswerAudio.play()
      $('.set-answer', 'tr[data-answer=' + currentAnswer + ']').removeClass('wrong-answer').addClass('correct-answer')
      $('.visible2').addClass('visible').removeClass('visible2')
      $('.image', '[data-answer=' + currentAnswer + ']').addClass('visible2')
      if($('.set-answer:not(.correct-answer)')[0]) {
        $('.set-answer:not(.correct-answer)')[0].click()
      }else {
        allAnsweredProperly()
      }
    } else {
     goodAnswerAudio.load()
     badAnswerAudio.play()
     $('.set-answer', 'tr[data-answer=' + currentAnswer + ']').removeClass('correct-answer').addClass('wrong-answer')
     if(badAnswers[currentAnswer]) {
      badAnswers[currentAnswer].push(currentAnswerText)
     } else {
      badAnswers[currentAnswer] = [currentAnswerText]
     }
    }
  }

  var allAnsweredProperly = function() {
    var tableBodyHtml = '';
    for (var i=1; i<=9; i++) {
      tableBodyHtml += '<tr><td>' + i + '</td><td>'
      if(badAnswers[i]) {
        tableBodyHtml += badAnswers[i].length + ' (' + badAnswers[i].join(', ') + ')'
      } else {
        tableBodyHtml += '0'
      }
      tableBodyHtml += '</td><td>'
      if(checkedAnswers[i]){
        tableBodyHtml += 'TAK'
      } else {
        tableBodyHtml += 'NIE'
      }
      tableBodyHtml += '</td>'
    }
    $('tbody', '#crosswordEndedModal').html(tableBodyHtml)
    $('#crosswordEndedModal').modal('show')
  }

  $('.read-question').on('click', function() {
    questionAudio.play()
  })

  $('.set-answer')[0].click()

});
