$( document ).ready(function() {

// DATA
  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/teatr/quiz/pyt1/pytanie1.wav');


  var questionNumber = 1;
  var noOfQuestions = 14;

  var questionTypes = [
    'image',
    'image',
    'image',
    'image',
    'image',
    'image',
    'image',
    'image',
    'image',
    'image',
    'image',
    'image',
    'image',
    'image',
  ]

  var questions = {
    1: "Podpowiada aktorom w teatrze.",
    2: "Ożywia lalki na scenie.",
    3: "Rodzaj lalki teatralnej z ruchomymi rączkami.",
    4: "Zasłona na scenie",
    5: "Miejsce za sceną niewidoczne dla widza.",
    6: "Miejsca przeznaczone dla widzów.",
    7: "Elementy dekoracji na scenie.",
    8: "Siedzi na widowni.",
    9: "Przedstawienie wystawiane po raz pierwszy.",
    10: "Lalka osadzana na dłoni.",
    11: "Lalka umieszczona na kiju.",
    12: "Lalka poruszana za pomocą sznurków.",
    13: "Cała sztuka zapisana z podziałem na role.",
    14: "Czuwa nad przebiegiem sztuki"
  }
  var answers = {
    1: {
      0: ['reżyser', 'sufler', 'aktor'],
      1: ['rezyser.jpg', 'sufler.jpg', 'aktorka.jpg'],
      2: ['rezyser.wav', 'sufler.wav', 'aktor.wav']
    },
    2: {
      0: ['reżyser', 'sufler', 'aktor'],
      1: ['rezyser.jpg', 'sufler.jpg', 'aktorka.jpg'],
      2: ['rezyser.wav', 'sufler.wav', 'aktor.wav']
    },
    3: {
      0: ['pacynka', 'jawajka', 'kukiełka'],
      1: ['pacynka.jpg', 'jawajka.jpg', 'kukielka.jpg'],
      2: ['pacynka.wav', 'jawajka.wav', 'kukielka.wav']
    },
    4: {
      0: ['kurtyna', 'kulisy', 'scenografia'],
      1: ['kurtyna.jpg', 'kulisy.jpg', 'dekoracje_scenografia.jpg'],
      2: ['kurtyna.wav', 'kulisy.wav', 'scenografia.wav']
    },
    5: {
      0: ['kurtyna', 'kulisy', 'widownia'],
      1: ['kurtyna.jpg', 'kulisy.jpg', 'widownia.jpg'],
      2: ['kurtyna.wav', 'kulisy.wav', 'widownia.wav']
    },
    6: {
      0: ['kurtyna', 'kulisy', 'widownia'],
      1: ['kurtyna.jpg', 'kulisy.jpg', 'widownia.jpg'],
      2: ['kurtyna.wav', 'kulisy.wav', 'widownia.wav']
    },
    7: {
      0: ['scenografia', 'kurtyna', 'rekwizyt'],
      1: ['dekoracje_scenografia.jpg', 'kurtyna.jpg', 'rekwizyt.jpg'],
      2: ['scenografia.wav', 'kurtyna.wav', 'rekwizyt.wav']
    },
    8: {
      0: ['widz', 'sufler', 'aktor'],
      1: ['widz.jpg', 'sufler.jpg', 'aktorka.jpg'],
      2: ['widz.wav', 'sufler.wav', 'aktor.wav']
    },
    9: {
      0: ['premiera', 'pacynka', 'scenografia'],
      1: ['premiera.jpg', 'pacynka.jpg', 'dekoracje_scenografia.jpg'],
      2: ['premiera.wav', 'pacynka.wav', 'scenografia.wav']
    },
    10: {
      0: ['pacynka', 'kukiełka', 'marionetka'],
      1: ['pacynka.jpg', 'kukielka.jpg', 'marionetka.jpg'],
      2: ['pacynka.wav', 'kukielka.wav', 'marionetka.wav']
    },
    11: {
      0: ['pacynka', 'kukiełka', 'marionetka'],
      1: ['pacynka.jpg', 'kukielka.jpg', 'marionetka.jpg'],
      2: ['pacynka.wav', 'kukielka.wav', 'marionetka.wav']
    },
    12: {
      0: ['pacynka', 'kukiełka', 'marionetka'],
      1: ['pacynka.jpg', 'kukielka.jpg', 'marionetka.jpg'],
      2: ['pacynka.wav', 'kukielka.wav', 'marionetka.wav']
    },
    13: {
      0: ['scenografia', 'scenariusz', 'scena'],
      1: ['dekoracje_scenografia.jpg', 'scenariusz.jpg', 'scena.jpg'],
      2: ['scenografia.wav', 'scenariusz.wav', 'scena.wav']
    },
    14: {
      0: ['reżyser', 'aktor', 'scenarzysta'],
      1: ['rezyser.jpg', 'aktorka.jpg', 'scenarzysta.jpg'],
      2: ['rezyser.wav', 'aktor.wav', 'scenarzysta.wav']
    }
  }

  var answerAudios = []

  var correctAnswerIndexes = {
    1: [2],
    2: [3],
    3: [2],
    4: [1],
    5: [2],
    6: [3],
    7: [1],
    8: [1],
    9: [1],
    10: [1],
    11: [2],
    12: [3],
    13: [2],
    14: [1]

  }

  var questionsFinished = []

  var answered = {
    1: [],
    2: [],
    3: [],
    4: [],
    5: [],
    6: [],
    7: [],
    8: [],
    9: [],
    10: [],
    11: [],
    12: [],
    13: [],
    14: []
  }

// MAIN LOGIC

  $( '.question-number' ).html( questionNumber );
  $( '.question-sum' ).html( noOfQuestions );
  $( '.question-text' ).html( questions[questionNumber] );

  $( 'body' ).on('click', '.next-question', function(event){
    event.preventDefault()
    if(questionNumber < noOfQuestions){
      questionNumber++;
      setPageDataForQuestion()
    }
    $('#modalCorrectAnswer').modal('hide')
  });

  $( '.prev-question' ).on('click', function(event){
    event.preventDefault()
    if(questionNumber > 1){
      questionNumber--;
      setPageDataForQuestion()
    }
  });

  $('.answer-audio').on('click', function(event){
    event.preventDefault();
    event.stopPropagation();
    var answerNo = parseInt($(this).attr('data-answer-no'));
    answerAudios[answerNo-1].play();
  })

  $( '.answer-button' ).on('click', function(event) {
    $('.wrong-answer').removeClass('wrong-answer')
    $('.last-answer').removeClass('last-answer')
    $(this).addClass('last-answer')
    var answerNo = parseInt($(this).attr('data-answer-no'))
    answered[questionNumber].push(answerNo)
    if(correctAnswerIndexes[questionNumber].indexOf(answerNo) !== -1) {
      $(this).addClass('correct-answer')
      badAnswerAudio.load()
      goodAnswerAudio.play()

      if(_.uniq(_.intersection(correctAnswerIndexes[questionNumber], answered[questionNumber])).length == correctAnswerIndexes[questionNumber].length) {

        //all correct answers selected
        if(questionsFinished.indexOf(questionNumber) == -1){
          questionsFinished.push(questionNumber)
        }
        if(!(questionsFinished.length === noOfQuestions)){
          if(questionNumber < noOfQuestions){
            showCorrectAnswerModal()
          }
        } else {
          fillEndModalAndShowIt()
        }

      }
    } else {
      goodAnswerAudio.load()
      badAnswerAudio.play()
      $(this).addClass('wrong-answer')
    }
  });

  $('.read-question').on('click', function() {
    questionAudio.play()
  })

  $('.check-answer').on('click', function() {
    $('.is-correct').toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500)
  })

  var setPageDataForQuestion = function() {
    $( '.question-number' ).html(questionNumber );
    $( '.question-text' ).html(questions[questionNumber] );

    questionAudio = new Audio('../files/audio/teatr/quiz/pyt' + questionNumber + '/pytanie' + questionNumber + '.wav');

    if(questionTypes[questionNumber-1] === 'image'){
      setAnswerButtonsForImage()
    } else if(questionTypes[questionNumber-1] === 'text') {
      setAnswerButtonsForText()
    }
    setAnswerAudiosButtons()
    if(questionNumber == noOfQuestions) {
      $( '.next-question' ).addClass('disabled')
    } else {
      $( '.next-question' ).removeClass('disabled');
    };
    if(questionNumber == 1) {
      $( '.prev-question' ).addClass('disabled');
    } else {
      $( '.prev-question' ).removeClass('disabled');
    }
    $('.wrong-answer').removeClass('wrong-answer')
    $('.last-answer').removeClass('last-answer')
  }

  var setAnswerAudiosButtons = function() {
    for (i = 0; i < 7; i++) {
      button = $('.answer-audio.aa-' + (i+1), '.answer-audios')
      if(answers[questionNumber][0][i]){
        $(button).removeClass('hide')
      } else {
        $(button).addClass('hide')
      }
    }
  }

  var setAnswerButtonsForText = function() {
    $('.answer-buttons-img').hide();
    $('.answer-buttons-txt').show();
    $('.answer-button').removeClass('is-correct')

    for (i = 0; i < 7; i++) {
      button = $('.answer-button.ab-' + (i+1), '.answer-buttons-txt')

      if(correctAnswerIndexes[questionNumber].indexOf(i+1) != -1){
        $(button).addClass('is-correct')
      }

      if(answers[questionNumber][0][i]){
        $(button).removeClass('hide')
        if(answered[questionNumber].indexOf(i+1) !== -1 && correctAnswerIndexes[questionNumber].indexOf(i+1) !== -1) {
          $(button).addClass('correct-answer')
        } else {
          $(button).removeClass('correct-answer')
        }
        $( '.text', $('a', button) ).html(answers[questionNumber][0][i]);
      } else {
        $(button).addClass('hide')
      }
    }
    setAnswerAudios(1)
  }

  var setAnswerButtonsForImage = function() {
    $('.answer-buttons-txt').hide();
    $('.answer-buttons-img').show();
    $('.answer-button').removeClass('is-correct')
    for (i = 0; i < 7; i++) {
      button = $('.answer-button.ab-' + (i+1), '.answer-buttons-img')

      if(correctAnswerIndexes[questionNumber].indexOf(i+1) != -1){
        $(button).addClass('is-correct')
      }

      if(answers[questionNumber][1][i]){
        $(button).removeClass('hide')
        if(answered[questionNumber].indexOf(i+1) !== -1 && correctAnswerIndexes[questionNumber].indexOf(i+1) !== -1) {
          $(button).addClass('correct-answer')
        } else {
          $(button).removeClass('correct-answer')
        }
        $( '.button-image', button ).attr('src', '../files/img/teatr/' + answers[questionNumber][1][i]);
        $( '.button-footer', button ).text(answers[questionNumber][0][i]);
      } else {
        $(button).addClass('hide')
      }
    }
    setAnswerAudios(2)
  }

  var setAnswerAudios = function(index){
    answerAudios = []
    for (i = 0; i < answers[questionNumber][index].length; i++) {
      answerAudios.push(new Audio('../files/audio/teatr/quiz/pyt' + questionNumber + '/' + answers[questionNumber][index][i]))
    }
  }

  var fillEndModalAndShowIt = function() {
    var tableBodyHtml = '';
    var i = 1;
    _.each(answered, function(yourAnswers){
      var yourAnswerTexts = []
      _.each(yourAnswers, function(answer) {
        if(correctAnswerIndexes[i].indexOf(answer) != -1){
          yourAnswerTexts.push('<span class="text-success">' + answers[i][0][answer-1] + '</span>')
        } else {
          yourAnswerTexts.push('<span class="text-danger">' + answers[i][0][answer-1] + '</span>')
        }
      })
      tableBodyHtml+='<tr><td>' + i + '</td><td>' + yourAnswers.length + '</td><td>' + _.difference(yourAnswers, correctAnswerIndexes[i]).length + '</td><td>' + yourAnswerTexts.join(', ') + '</td></tr>'
      i+=1;
    })
    $('tbody', '#quizEndedModal').html(tableBodyHtml)
    $('#quizEndedModal').modal('show')
  }

  var showCorrectAnswerModal = function(){
    $('#modalCorrectAnswer').modal('show')
  }



  setAnswerButtonsForImage()
  setAnswerAudiosButtons()

});
