$( document ).ready(function() {

  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/teatr/policz/policz-polecenie.wav');

  var goodAnswers = [4, 3, 4, 2, 9, 8, 8]
  var items = {
    0: [
      ['goingIn right',     'mezczyzna-1.png'],
      ['goingIn center',    'kobieta-1.png'],
      ['goingIn more-left', 'mezczyzna-2.png'],
      ['goingOut left',     'mezczyzna-wychodzi-1.png'],
      ['goingOut center',   'mezczyzna-wychodzi-1.png'],
      ['goingOut left',     'kobieta-wychodzi-1.png'],
      ['goingIn more-left', 'mezczyzna-2.png'],
      ['goingIn center',    'kobieta-1.png'],
      ['goingIn right',     'kobieta-2.png'],
      ['goingOut left',     'mezczyzna-wychodzi-1.png'],
      ['goingIn more-left', 'mezczyzna-2.png'],
      ['goingIn center',    'kobieta-2.png']
    ],
    1: [
      ['goingIn right',     'mezczyzna-1.png'],
      ['goingIn center',    'kobieta-1.png'],
      ['goingOut left',     'mezczyzna-wychodzi-1.png'],
      ['goingIn more-left', 'mezczyzna-2.png'],
      ['goingOut center',   'mezczyzna-wychodzi-1.png'],
      ['goingIn more-left', 'mezczyzna-2.png'],
      ['goingIn center',    'kobieta-1.png'],
      ['goingIn right',     'kobieta-2.png'],
      ['goingOut left',     'kobieta-wychodzi-1.png']
    ],
    2: [
      ['goingIn right',     'mezczyzna-1.png'],
      ['goingIn center',    'kobieta-1.png'],
      ['goingIn more-left', 'mezczyzna-2.png'],
      ['goingIn more-left', 'mezczyzna-2.png'],
      ['goingIn center',    'kobieta-1.png'],
      ['goingOut left',     'mezczyzna-wychodzi-1.png']
    ],
    3: [
      ['goingIn right',     'mezczyzna-1.png'],
      ['goingIn center',    'kobieta-1.png'],
      ['goingOut center',   'mezczyzna-wychodzi-1.png'],
      ['goingOut left',     'kobieta-wychodzi-1.png'],
      ['goingIn more-left', 'mezczyzna-2.png'],
      ['goingIn more-left', 'mezczyzna-2.png'],
      ['goingOut left',     'mezczyzna-wychodzi-1.png'],
      ['goingOut left',     'mezczyzna-wychodzi-1.png'],
      ['goingIn center',    'kobieta-1.png'],
      ['goingIn right',     'kobieta-2.png'],
      ['goingOut center',   'mezczyzna-wychodzi-1.png'],
      ['goingIn more-left', 'mezczyzna-2.png'],
      ['goingIn center',    'kobieta-2.png'],
      ['goingOut left',     'kobieta-wychodzi-1.png']
    ],
    4: [
      ['goingIn right',     'mezczyzna-1.png'],
      ['goingIn center',    'kobieta-1.png'],
      ['goingIn more-left', 'mezczyzna-2.png'],
      ['goingIn center',    'kobieta-1.png'],
      ['goingIn right',     'kobieta-2.png'],
      ['goingIn more-left', 'mezczyzna-2.png'],
      ['goingIn more-left', 'mezczyzna-2.png'],
      ['goingIn center',    'kobieta-2.png'],
      ['goingOut center',   'mezczyzna-wychodzi-1.png'],
      ['goingOut left',     'kobieta-wychodzi-1.png'],
      ['goingIn center',    'kobieta-1.png'],
      ['goingIn more-left', 'mezczyzna-2.png'],
      ['goingIn more-left', 'mezczyzna-2.png'],
      ['goingIn center',    'kobieta-1.png'],
      ['goingOut left',     'kobieta-wychodzi-1.png']
    ],
    5: [
      ['goingIn right',     'mezczyzna-1.png'],
      ['goingIn center',    'kobieta-1.png'],
      ['goingOut center',   'mezczyzna-wychodzi-1.png'],
      ['goingIn more-left', 'mezczyzna-2.png'],
      ['goingIn center',    'kobieta-1.png'],
      ['goingOut left',     'kobieta-wychodzi-1.png'],
      ['goingIn right',     'kobieta-2.png'],
      ['goingIn more-left', 'mezczyzna-2.png'],
      ['goingOut left',     'kobieta-wychodzi-1.png'],
      ['goingIn more-left', 'mezczyzna-2.png'],
      ['goingIn center',    'kobieta-2.png'],
      ['goingOut center',   'mezczyzna-wychodzi-1.png'],
      ['goingIn center',    'kobieta-1.png'],
      ['goingIn more-left', 'mezczyzna-2.png'],
      ['goingIn more-left', 'mezczyzna-2.png'],
      ['goingIn center',    'kobieta-1.png']
    ],
    6: [
      ['goingIn right',     'mezczyzna-1.png'],
      ['goingIn center',    'kobieta-1.png'],
      ['goingIn more-left', 'mezczyzna-2.png'],
      ['goingOut center',   'mezczyzna-wychodzi-1.png'],
      ['goingIn center',    'kobieta-1.png'],
      ['goingIn right',     'kobieta-2.png'],
      ['goingIn more-left', 'mezczyzna-2.png'],
      ['goingOut left',     'kobieta-wychodzi-1.png'],
      ['goingIn more-left', 'mezczyzna-2.png'],
      ['goingIn center',    'kobieta-2.png'],
      ['goingIn more-left', 'mezczyzna-2.png'],
      ['goingOut left',     'kobieta-wychodzi-1.png'],
      ['goingIn more-left', 'mezczyzna-2.png'],
      ['goingIn center',    'kobieta-1.png'],
      ['goingIn center',    'kobieta-1.png'],
      ['goingOut center',   'mezczyzna-wychodzi-1.png'],
      ['goingIn right',     'mezczyzna-1.png'],
      ['goingIn center',    'kobieta-1.png'],
      ['goingIn more-left', 'mezczyzna-2.png'],
      ['goingOut left',     'mezczyzna-wychodzi-1.png'],
      ['goingOut center',   'mezczyzna-wychodzi-1.png'],
      ['goingOut left',     'kobieta-wychodzi-1.png'],
      ['goingIn more-left', 'mezczyzna-2.png'],
      ['goingIn center',    'kobieta-1.png'],
      ['goingIn right',     'kobieta-2.png'],
      ['goingOut center',   'mezczyzna-wychodzi-1.png'],
      ['goingOut left',     'kobieta-wychodzi-1.png'],
      ['goingOut left',     'mezczyzna-wychodzi-1.png']

    ],

  }
  var questionNumber = 1
  var noOfQuestions = 7
  var answers = [ [], [], [], [], [], [], [] ]
  var checkedAnswers = [false, false, false, false, false, false, false ]
  var timeouts = []

  // var steps = [ 6, 6, 8, 8, 10, 11, 12 ]

  checkGoingInOutIsFinished = function(index){
    if( items[questionNumber-1].length-1 == index){
      console.log("FINISHED!")
      setTimeout(function(){
        $('.answer').removeClass('hidden');
        $('.answer-count').val('')
        $('.answer-count').focus()
        $('.answer').removeClass('correct-answer')
        $('.answer').removeClass('wrong-answer')
      }, 1900)
    }
  }

  drawGoingIn = function(item, index){
    timeouts[index] = setTimeout(function(){
      $(item).removeClass('small').fadeIn(300).addClass('small', 500).fadeOut(300);
      checkGoingInOutIsFinished(index)
    }, index*1900)
  }

  drawGoingOut = function(item, index){
    timeouts[index] = setTimeout(function(){
      $(item).addClass('small').fadeIn(300).removeClass('small', 500).fadeOut(300);
      checkGoingInOutIsFinished(index)
    }, index*1900)
  }

  prepareQuestionData = function(){
    $('.counts', '.drzwi-container').html('')
    _.each(items[questionNumber-1], function(item){
      $('.counts', '.drzwi-container').append('<div style="display: none;" class="count-container ' + item[0] + '"><img src="../files/img/teatr/policz/' + item[1] + '"></div>')
    })
  }

  $('.btn-policz.start').on('click', function(event){
    event.preventDefault();
    $('.answer').addClass('hidden');

    $('.count-container').each(function(index){
      if($(this).hasClass('goingIn')){
        drawGoingIn(this, index)
      }
      if($(this).hasClass('goingOut')){
        drawGoingOut(this, index)
      }
    })
  })

  $('.btn-policz.stop').on('click', function(event){
    _.each(timeouts, function(item){
      clearTimeout(item)
    })
    $('.answer').removeClass('hidden');
    $('.answer-count').val('')
    $('.answer-count').focus()
    $('.answer').removeClass('correct-answer')
    $('.answer').removeClass('wrong-answer')
  })

  $('.check-answer').on('click', function(event){
    event.preventDefault()
    $('.answer-count').val(goodAnswers[questionNumber-1])
    $('.answer').removeClass('hidden')
    // $('.check-my-answer').click()
    checkedAnswers[questionNumber-1] = true
  })

  $('.read-question').on('click', function(event){
    event.preventDefault()
    questionAudio.play()
  })

  $('.next-question').on('click', function(event){
    event.preventDefault();
    questionNumber+=1;
    if(noOfQuestions == questionNumber){
      $('.next-question').addClass('disabled');
    };
    $('.prev-question').removeClass('disabled');
    $('.question-number').html(questionNumber);
    if( answers[questionNumber-1] && answers[questionNumber-1].indexOf(goodAnswers[questionNumber-1]) == -1 ) {
      $('.answer').addClass('hidden')
      $('#modalCorrectAnswer').modal('hide')
    } else {
      $('.answer').removeClass('hidden').addClass('correct-answer')
      $('.answer-count').val(goodAnswers[questionNumber-1])
      $('#modalCorrectAnswer').modal('hide')
    }
    prepareQuestionData()
  })

  $('.prev-question').on('click', function(event){
    event.preventDefault();
    questionNumber-=1;
    if(1 == questionNumber){
      $('.prev-question').addClass('disabled');
    };
    $('.next-question').removeClass('disabled');
    $('.question-number').html(questionNumber);
    $('.answer').addClass('hidden')
    $('#modalCorrectAnswer').modal('hide')
    prepareQuestionData()
  })

  $('.check-my-answer').on('click', function(event){
    event.preventDefault();
    answered = parseInt($('.answer-count').val())
    if( answered == goodAnswers[questionNumber-1] ) {
      badAnswerAudio.load();
      goodAnswerAudio.play();
      $('.answer').addClass('correct-answer')
      $('.answer').removeClass('wrong-answer')
      answers[questionNumber-1].push(answered)
      showProperModal()
    } else {
      goodAnswerAudio.load();
      badAnswerAudio.play();
      $('.answer').addClass('wrong-answer')
      $('.answer').removeClass('correct-answer')
      answers[questionNumber-1].push(answered)
    }
  })

  showFinishModal = function() {
    var tableBodyHtml = '';
    for (var i=0; i<noOfQuestions; i++) {
      tableBodyHtml += '<tr><td>' + (i+1) + '</td><td>'
      badAnswers = _.without(answers[i], goodAnswers[i])
      if(badAnswers.length > 0) {
        tableBodyHtml += badAnswers.length + ' (' + badAnswers.join(', ') + ')'
      } else {
        tableBodyHtml += '0'
      }
      tableBodyHtml += '</td><td>'
      if(checkedAnswers[i]){
        tableBodyHtml += 'TAK'
      } else {
        tableBodyHtml += 'NIE'
      }
      tableBodyHtml += '</td>'
    }
    $('tbody', '#countEndedModal').html(tableBodyHtml)
    $('#countEndedModal').modal('show')
  }

  showProperModal = function() {
    allAnsweredProperly = true;
    var i = 0;
    _.each(answers, function(questionAnswers){
      if( questionAnswers.indexOf(goodAnswers[i]) == -1 ){
        allAnsweredProperly = false;
      }
      i+=1;
    })
    if( allAnsweredProperly ) {
      showFinishModal()
    } else {
      $('#modalCorrectAnswer').modal('show')
    }
  }

  prepareQuestionData()
  $('.question-number').html(questionNumber);
  $('.question-sum').html(noOfQuestions);
  $('.question-text').html('Ile osób pozostało w teatrze?');

})