$( document ).ready(function() {

  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/recykling/polecenie_policz.wav');

  var goodAnswers = [
    [5,3],
    [4,2],
    [4,6],
    [4,6],
    [5,4],
    [2,3,4],
    [4,6,2]
  ]
  var noOfItems = [13, 15, 17, 16, 17, 14, 17]
  var questionNumber = 1
  var noOfQuestions = 7
  var answers = [ [], [], [], [], [], [], [] ]
  var checkedAnswers = [false, false, false, false, false, false, false]
  var timeouts = []

  drawDroppingToBasket = function(item, index){
    timeouts[index] = setTimeout(function(){
      $(item).addClass('bottom', 1800);
      if( index == noOfItems[questionNumber-1]-1 ){
        setTimeout(function(){
          $('.answer').removeClass('hidden');
          $('.answer-count').val('')
          $('.answer-count').focus()
          $('.answer').removeClass('correct-answer')
          $('.answer').removeClass('wrong-answer')
        }, 1800)
      }
    }, index*1800)
  }

  $('.btn-policz.start').on('click', function(event){
    event.preventDefault();
    $('.answer').addClass('hidden');
    $('.count-container').removeClass('bottom');
    $('.count-container.question-' + questionNumber).each(function(index){
      drawDroppingToBasket(this, index)
    })
  })

  $('.btn-policz.stop').on('click', function(event){
    _.each(timeouts, function(item){
      clearTimeout(item)
    })
    $('.count-container').removeClass('bottom');
    $('.answer').removeClass('hidden');
    $('.answer-count-1').val('')
    $('.answer-count-2').val('')
    $('.answer-count-3').val('')
    $('.answer-count-1').focus()
    $('.answer').removeClass('correct-answer')
    $('.answer').removeClass('wrong-answer')
  })

  $('.check-answer').on('click', function(event){
    event.preventDefault()
    $('.answer-count-1').val(goodAnswers[questionNumber-1][0])
    $('.answer-count-2').val(goodAnswers[questionNumber-1][1])
    $('.answer-count-3').val(goodAnswers[questionNumber-1][2])
    $('.answer').removeClass('hidden')
    checkedAnswers[questionNumber-1] = true
    $('.check-my-answer').click()
  })

  $('.read-question').on('click', function(event){
    event.preventDefault()
    questionAudio.play()
  })

  $('.next-question').on('click', function(event){
    event.preventDefault();
    questionNumber+=1;
    if(noOfQuestions == questionNumber){
      $('.next-question').addClass('disabled');
    };
    $('.prev-question').removeClass('disabled');
    $('.question-number').html(questionNumber);
    $('.question-data:not(.question' + questionNumber + ')').hide()
    $('.question-data.question' + questionNumber).show()
    if( answers[questionNumber-1] && answers[questionNumber-1].indexOf(goodAnswers[questionNumber-1]) == -1 ) {
      $('.answer').addClass('hidden')
      $('#modalCorrectAnswer').modal('hide')
    } else {
      $('.answer').removeClass('hidden').addClass('correct-answer')
      $('.answer-count-1').val(goodAnswers[questionNumber-1][0])
      $('.answer-count-2').val(goodAnswers[questionNumber-1][1])
      $('.answer-count-3').val(goodAnswers[questionNumber-1][2])
      $('#modalCorrectAnswer').modal('hide')
    }
  })

  $('.prev-question').on('click', function(event){
    event.preventDefault();
    questionNumber-=1;
    if(1 == questionNumber){
      $('.prev-question').addClass('disabled');
    };
    $('.next-question').removeClass('disabled');
    $('.question-number').html(questionNumber);
    $('.question-data(not:.question' + questionNumber + ')').hide()
    $('.question-data.question' + questionNumber).show()
    $('.answer').addClass('hidden')
    $('#modalCorrectAnswer').modal('hide')
  })

  $('.check-my-answer').on('click', function(event){
    event.preventDefault();
    allAnswered = true
    answered = []
    count = 1
    _.each(goodAnswers[questionNumber-1], function(answer) {
      if (parseInt($('.answer-count-' + count).val()) != answer) {
        allAnswered = false
      }
      answered.push(parseInt($('.answer-count-' + count).val()))
      count+=1
    })
    if( allAnswered ) {
      badAnswerAudio.load();
      goodAnswerAudio.play();
      $('.answer').addClass('correct-answer')
      $('.answer').removeClass('wrong-answer')
      answers[questionNumber-1].push(answered)
      showProperModal()
    } else {
      goodAnswerAudio.load();
      badAnswerAudio.play();
      $('.answer').addClass('wrong-answer')
      $('.answer').removeClass('correct-answer')
      answers[questionNumber-1].push(answered)
    }
  })

  showFinishModal = function() {
    var tableBodyHtml = '';
    for (var i=0; i<noOfQuestions; i++) {
      tableBodyHtml += '<tr><td>' + (i+1) + '</td><td>'

      badAnswers = _.filter(answers[i], function(partAnswer) {
          return _.intersection(partAnswer,goodAnswers[i]).length != goodAnswers[i].length
        })

      if(badAnswers.length > 0) {
        tableBodyHtml += badAnswers.length + ' (' + badAnswers.join(' ; ') + ')'
      } else {
        tableBodyHtml += '0'
      }
      tableBodyHtml += '</td><td>'
      if(checkedAnswers[i]){
        tableBodyHtml += 'TAK'
      } else {
        tableBodyHtml += 'NIE'
      }
      tableBodyHtml += '</td>'
    }
    $('tbody', '#countEndedModal').html(tableBodyHtml)
    $('#countEndedModal').modal('show')
  }

  showProperModal = function() {
    allAnsweredProperly = true;
    var i = 0;
    _.each(answers, function(questionAnswers){
      thisAnswerIsOK = _.filter(questionAnswers, function(partAnswer) {
          return _.intersection(partAnswer,goodAnswers[i]).length == goodAnswers[i].length
        }).length > 0
      if( !thisAnswerIsOK ){
        allAnsweredProperly = false;
      }
      i+=1;
    })
    if( allAnsweredProperly ) {
      showFinishModal()
    } else {
      $('#modalCorrectAnswer').modal('show')
    }
  }

  $('.question-number').html(questionNumber);
  $('.question-sum').html(noOfQuestions);
  $('.question-text').html('Policz spadające odpady.');
  $('.question-data:not(.question' + questionNumber + ')').hide()
  $('.question-data.question' + questionNumber).show()

})